/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.validation.checkers.expression;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.validation.checkers.IrElementChecker;
import org.jetbrains.kotlin.ir.validation.checkers.context.CheckerContext;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/validation/checkers/expression/IrConstTypeChecker;", "Lorg/jetbrains/kotlin/ir/validation/checkers/IrElementChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "<init>", "()V", "check", "", "element", "context", "Lorg/jetbrains/kotlin/ir/validation/checkers/context/CheckerContext;", "ir.validation"})
public final class IrConstTypeChecker
extends IrElementChecker<IrConst> {
    @NotNull
    public static final IrConstTypeChecker INSTANCE = new IrConstTypeChecker();

    private IrConstTypeChecker() {
        super(Reflection.getOrCreateKotlinClass(IrConst.class));
    }

    @Override
    public void check(@NotNull IrConst element, @NotNull CheckerContext context2) {
        IrType irType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        IrBuiltIns irBuiltIns = context2.getIrBuiltIns();
        IrConstKind irConstKind = element.getKind();
        if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Null.INSTANCE)) {
            if (!IrTypeUtilsKt.isNullable(element.getType())) {
                context2.error(this, element, "expected a nullable type, got " + RenderIrElementKt.render$default(element.getType(), null, 1, null));
            }
            return;
        }
        if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Boolean.INSTANCE)) {
            irType = irBuiltIns.getBooleanType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Char.INSTANCE)) {
            irType = irBuiltIns.getCharType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Byte.INSTANCE)) {
            irType = irBuiltIns.getByteType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Short.INSTANCE)) {
            irType = irBuiltIns.getShortType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Int.INSTANCE)) {
            irType = irBuiltIns.getIntType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Long.INSTANCE)) {
            irType = irBuiltIns.getLongType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.String.INSTANCE)) {
            irType = irBuiltIns.getStringType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Float.INSTANCE)) {
            irType = irBuiltIns.getFloatType();
        } else if (Intrinsics.areEqual((Object)irConstKind, (Object)IrConstKind.Double.INSTANCE)) {
            irType = irBuiltIns.getDoubleType();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrType naturalType = irType;
    }
}

