/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseGuavaTypeConversionRule
extends TypeConversionRule {
    private final Supplier<Map<String, TypeConversionDescriptorBase>> simpleDescriptors = NotNullLazyValue.softLazy(() -> {
        HashMap<String, TypeConversionDescriptorBase> map = new HashMap<String, TypeConversionDescriptorBase>();
        this.fillSimpleDescriptors(map);
        return map;
    });

    protected void fillSimpleDescriptors(Map<@NlsSafe String, TypeConversionDescriptorBase> descriptorsMap) {
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(PsiType from, PsiType to, @NotNull PsiMethod method, @NotNull @NlsSafe String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (method == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@Nullable PsiExpression context) {
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public abstract String ruleFromClass();

    @Contract(pure=true)
    @NotNull
    public abstract String ruleToClass();

    @NotNull
    protected Set<String> getAdditionalUtilityClasses() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Nullable
    public final TypeConversionDescriptorBase findConversion(@Nullable PsiType from, @Nullable PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiElement resolvedElement;
        if (from != null && to != null && !BaseGuavaTypeConversionRule.canConvert(from, to, this.ruleFromClass(), this.ruleToClass())) {
            return null;
        }
        if (member instanceof PsiMethod) {
            TypeConversionDescriptorBase descriptor;
            PsiMethod method = (PsiMethod)member;
            String methodName = method.getName();
            PsiClass aClass = method.getContainingClass();
            if (this.isValidMethodQualifierToConvert(aClass) && (descriptor = this.simpleDescriptors.get().get(methodName)) != null) {
                return descriptor;
            }
            TypeConversionDescriptorBase conversionForMethod = this.findConversionForMethod(from, to, method, methodName, context, labeler);
            return conversionForMethod != null ? conversionForMethod : this.getUnknownMethodConversion();
        }
        if (context instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)context).getAnonymousClass();
            return anonymousClass == null ? null : this.findConversionForAnonymous(anonymousClass, (GuavaConversionSettings)labeler.getSettings(GuavaConversionSettings.class));
        }
        if (context instanceof PsiMethodReferenceExpression) {
            PsiType methodReferenceType = context.getType();
            if (methodReferenceType != null && to != null && to.isAssignableFrom(methodReferenceType)) {
                return new TypeConversionDescriptorBase();
            }
        } else if (context instanceof PsiReferenceExpression && (resolvedElement = ((PsiReferenceExpression)context).resolve()) instanceof PsiVariable) {
            return this.findConversionForVariableReference(context);
        }
        return null;
    }

    protected abstract TypeConversionDescriptorBase getUnknownMethodConversion();

    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, @Nullable GuavaConversionSettings settings) {
        Set<Object> ignoredAnnotations;
        if (anonymousClass == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(3);
        }
        Set<Object> set = ignoredAnnotations = settings != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda((PsiAnonymousClass)anonymousClass, (boolean)false, ignoredAnnotations)) {
            return new TypeConversionDescriptorBase(this){

                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, (boolean)false, (boolean)true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule$1", "replace"));
                }
            };
        }
        return null;
    }

    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return aClass != null && (this.ruleFromClass().equals(aClass.getQualifiedName()) || this.getAdditionalUtilityClasses().contains(aClass.getQualifiedName()));
    }

    static boolean canConvert(@Nullable PsiType from, @Nullable PsiType to, @NotNull String fromClassName, @NotNull String toClassName) {
        if (fromClassName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(4);
        }
        if (toClassName == null) {
            BaseGuavaTypeConversionRule.$$$reportNull$$$0(5);
        }
        if (!(from instanceof PsiClassType)) {
            return false;
        }
        if (!(to instanceof PsiClassType)) {
            return false;
        }
        PsiClassType.ClassResolveResult fromResolveResult = ((PsiClassType)from).resolveGenerics();
        PsiClass fromClass = fromResolveResult.getElement();
        if (fromClass instanceof PsiAnonymousClass) {
            fromClass = ((PsiAnonymousClass)fromClass).getBaseClassType().resolve();
        }
        if (fromClass == null || !fromClassName.equals(fromClass.getQualifiedName())) {
            return false;
        }
        PsiClassType.ClassResolveResult toResolveResult = ((PsiClassType)to).resolveGenerics();
        PsiClass toClass = toResolveResult.getElement();
        return toClass != null && toClassName.equals(toClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromClassName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/BaseGuavaTypeConversionRule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalUtilityClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForMethod";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForAnonymous";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canConvert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

