/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.HighlightingComponent;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.NotebookPassConfiguration;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.InjectedFileData;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.NotebookPassProgressStatus;
import com.intellij.kotlin.jupyter.core.editor.highlighting.components.pass.state.PassProgressTracker;
import com.intellij.kotlin.jupyter.core.editor.highlighting.utils.PsiUtilsKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J4\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J,\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u0011H\u0016R3\u0010\u0005\u001a'\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressTracker;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/PassProgressTracker;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/HighlightingComponent;", "<init>", "()V", "injectedFilesDataRegistry", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/psi/KtFile;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/InjectedFileData;", "currentConfiguration", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/NotebookPassConfiguration;", "passConfiguration", "getPassConfiguration", "()Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/NotebookPassConfiguration;", "passStarting", "", "file", "Lcom/intellij/psi/PsiFile;", "focusCellIndex", "", "indexesToHighlight", "", "cellsToHighlight", "", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "createPassNewConfiguration", "cells", "targetIndexes", "getStatusAfterPassFinished", "Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressStatus;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookPassProgressTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookPassProgressTracker.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,135:1\n2792#2,3:136\n296#2,2:139\n*S KotlinDebug\n*F\n+ 1 NotebookPassProgressTracker.kt\ncom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressTracker\n*L\n74#1:136,3\n77#1:139,2\n*E\n"})
public final class NotebookPassProgressTracker
extends HighlightingComponent
implements PassProgressTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<KtFile, InjectedFileData> injectedFilesDataRegistry;
    private NotebookPassConfiguration currentConfiguration;
    public static final int INJECTED_SYNTAX_LAYER_BORDER = 1999;

    public NotebookPassProgressTracker() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.injectedFilesDataRegistry = concurrentMap;
    }

    @Override
    @NotNull
    public NotebookPassConfiguration getPassConfiguration() {
        NotebookPassConfiguration notebookPassConfiguration;
        boolean it = this.currentConfiguration != null;
        boolean bl = false;
        if (it) {
            notebookPassConfiguration = this.currentConfiguration;
            if (notebookPassConfiguration == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"currentConfiguration");
                notebookPassConfiguration = null;
            }
        } else {
            notebookPassConfiguration = NotebookPassConfiguration.Companion.getEMPTY();
        }
        return notebookPassConfiguration;
    }

    @Override
    public void passStarting(@NotNull PsiFile file, int focusCellIndex, @NotNull Collection<Integer> indexesToHighlight, @NotNull List<? extends PsiLanguageInjectionHost> cellsToHighlight) {
        NotebookPassConfiguration newConfiguration;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(indexesToHighlight, (String)"indexesToHighlight");
        Intrinsics.checkNotNullParameter(cellsToHighlight, (String)"cellsToHighlight");
        this.injectedFilesDataRegistry.clear();
        this.currentConfiguration = newConfiguration = this.createPassNewConfiguration(focusCellIndex, cellsToHighlight, indexesToHighlight);
    }

    private final NotebookPassConfiguration createPassNewConfiguration(int focusCellIndex, List<? extends PsiLanguageInjectionHost> cells, Collection<Integer> targetIndexes) {
        if (cells.isEmpty()) {
            return new NotebookPassConfiguration(focusCellIndex, MapsKt.emptyMap(), cells);
        }
        Project project = ((PsiLanguageInjectionHost)CollectionsKt.first(cells)).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project2);
        Iterator<Integer> iterator = targetIndexes.iterator();
        while (iterator.hasNext()) {
            TextRange ktFileRange;
            Pair pair2;
            Object v2;
            PsiLanguageInjectionHost psiCell;
            int ind;
            block7: {
                Object element$iv2;
                boolean bl;
                List injectedPsiFiles;
                block6: {
                    ind = ((Number)iterator.next()).intValue();
                    if ((PsiLanguageInjectionHost)CollectionsKt.getOrNull(cells, (int)ind) == null || (injectedPsiFiles = injectedLanguageManager.getInjectedPsiFiles((PsiElement)psiCell)) == null) continue;
                    Iterable $this$none$iv = injectedPsiFiles;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            Pair f = (Pair)element$iv2;
                            boolean bl2 = false;
                            if (!(f.first instanceof KtFile)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = true;
                    }
                }
                if (bl) continue;
                Iterable $this$firstOrNull$iv = injectedPsiFiles;
                boolean $i$f$firstOrNull = false;
                element$iv2 = $this$firstOrNull$iv.iterator();
                while (element$iv2.hasNext()) {
                    Object element$iv3 = element$iv2.next();
                    Pair f = (Pair)element$iv3;
                    boolean bl3 = false;
                    if (!(f.first instanceof KtFile)) continue;
                    v2 = element$iv3;
                    break block7;
                }
                v2 = null;
            }
            if ((pair2 = (Pair)v2) == null || (pair2 = (PsiElement)pair2.first) == null) continue;
            Pair ktFile = pair2;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager.injectedToHost((PsiElement)ktFile, ktFile.getTextRange()), (String)"injectedToHost(...)");
            ((Map)this.injectedFilesDataRegistry).put((KtFile)ktFile, new InjectedFileData(ind, (KtFile)ktFile, ktFileRange, psiCell, PsiUtilsKt.numberOfNonWhiteSpaceLeaves((KtFile)ktFile)));
        }
        return new NotebookPassConfiguration(focusCellIndex, (Map<KtFile, InjectedFileData>)this.injectedFilesDataRegistry, cells);
    }

    @Override
    @NotNull
    public NotebookPassProgressStatus getStatusAfterPassFinished(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        MarkupModelEx markupModelEx = editor.getFilteredDocumentMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getFilteredDocumentMarkupModel(...)");
        MarkupModelEx markupModelEx2 = markupModelEx;
        ConcurrentMap<KtFile, InjectedFileData> data = this.injectedFilesDataRegistry;
        Set skippedFiles = new LinkedHashSet();
        Set errorsToDispose = new LinkedHashSet();
        Iterator iterator = ((Map)data).entrySet().iterator();
        while (iterator.hasNext()) {
            InjectedFileData fileData = (InjectedFileData)iterator.next().getValue();
            TextRange range = fileData.getKtFileRange();
            if (range.getLength() == 0) continue;
            fileData.getAppliedTokens().set(0);
            Set seenHighlighters = new LinkedHashSet();
            markupModelEx2.processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), arg_0 -> NotebookPassProgressTracker.getStatusAfterPassFinished$lambda$1(arg_0 -> NotebookPassProgressTracker.getStatusAfterPassFinished$lambda$0(seenHighlighters, fileData, this, errorsToDispose, arg_0), arg_0));
            int tokens = seenHighlighters.size();
            if (tokens >= fileData.getTotalTokens() - 1) continue;
            skippedFiles.add(fileData.getNotebookCellIndex());
        }
        return new NotebookPassProgressStatus(skippedFiles, errorsToDispose);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.injectedFilesDataRegistry.clear();
    }

    private static final boolean getStatusAfterPassFinished$lambda$0(Set $seenHighlighters, InjectedFileData $fileData, NotebookPassProgressTracker this$0, Set $errorsToDispose, RangeHighlighterEx it) {
        int layer = it.getLayer();
        boolean bl = 1000 <= layer ? layer < 2000 : false;
        if (bl) {
            Intrinsics.checkNotNull((Object)it);
            if ($seenHighlighters.add(it)) {
                $fileData.getAppliedTokens().incrementAndGet();
            }
        }
        if (layer == 5000 && $fileData.getNotebookCellIndex() != this$0.getPassConfiguration().getFocusCell()) {
            Intrinsics.checkNotNull((Object)it);
            $errorsToDispose.add(it);
        }
        return true;
    }

    private static final boolean getStatusAfterPassFinished$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/components/pass/state/NotebookPassProgressTracker$Companion;", "", "<init>", "()V", "INJECTED_SYNTAX_LAYER_BORDER", "", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

