/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.highlighting.editor.markup;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/highlighting/editor/markup/ShadowingAwareMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "errorHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "<init>", "(Ljava/util/Set;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "intellij.kotlin.jupyter.core"})
public final class ShadowingAwareMarkupModelListener
implements MarkupModelListener {
    @NotNull
    private final Set<RangeHighlighter> errorHighlighters;

    public ShadowingAwareMarkupModelListener(@NotNull Set<RangeHighlighter> errorHighlighters) {
        Intrinsics.checkNotNullParameter(errorHighlighters, (String)"errorHighlighters");
        this.errorHighlighters = errorHighlighters;
    }

    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        HighlightInfo highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)highlighter));
        if (highlightInfo == null) {
            return;
        }
        HighlightInfo info = highlightInfo;
        if (Intrinsics.areEqual((Object)info.getSeverity(), (Object)HighlightSeverity.ERROR)) {
            String string = info.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            if (StringsKt.startsWith$default((CharSequence)string, (char)'[', (boolean)false, (int)2, null)) {
                this.errorHighlighters.add((RangeHighlighter)highlighter);
            }
        }
    }
}

