/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.notifications;

import com.intellij.kotlin.jupyter.core.notifications.KotlinNotebookNotifications;
import com.intellij.kotlin.jupyter.core.notifications.NotificationsKt;
import com.intellij.kotlin.jupyter.core.projectModel.KernelJdkAlignmentCheckResult;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.kotlin.jupyter.core.settings.ui.KotlinNotebookConfigurable;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.NlsSafe;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 $2\u00020\u0001:\u0002#$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\r\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u000b2\b\b\u0003\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u000bJ\u0006\u0010\u001a\u001a\u00020\u000bJ8\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\b2\u000b\u0010\u001d\u001a\u00070\u0010\u00a2\u0006\u0002\b\u001e2\u0019\b\u0002\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u000b0 \u00a2\u0006\u0002\b\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notificationSingletons", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications$KotlinNotebookNotificationType;", "Lcom/intellij/notification/SingletonNotificationManager;", "showOutdatedDependencies", "", "showAbsentDependencies", "showAbsentInitialBaseDependenciesInfo", "showKernelJDKInconsistentError", "loaderError", "", "showRerunActionNeeded", "showBytecodeRefactoringWarning", "showRefactoringExistingUsagesMessage", "usagesCount", "", "showKernelAndProjectModuleJdkAreNotAlignedWarning", "sdkCheckResult", "Lcom/intellij/kotlin/jupyter/core/projectModel/KernelJdkAlignmentCheckResult$MisalignedWithModule;", "showOutdatedKernelWarningIfNeeded", "showNoKernelToAttach", "notify", "type", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "customizer", "Lkotlin/Function1;", "Lcom/intellij/notification/Notification;", "Lkotlin/ExtensionFunctionType;", "KotlinNotebookNotificationType", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nnotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 notifications.kt\ncom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n72#2,2:225\n1#3:227\n*S KotlinDebug\n*F\n+ 1 notifications.kt\ncom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications\n*L\n206#1:225,2\n206#1:227\n*E\n"})
public final class KotlinNotebookNotifications {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<KotlinNotebookNotificationType, SingletonNotificationManager> notificationSingletons;

    public KotlinNotebookNotifications(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.notificationSingletons = new ConcurrentHashMap();
    }

    public final void showOutdatedDependencies() {
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.OUTDATED_DEPENDENCIES, KotlinNotebookBundle.message("kotlin.jupyter.dependencies.build.error.outdated", new Object[0]), null, 4, null);
    }

    public final void showAbsentDependencies() {
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.ABSENT_DEPENDENCIES, KotlinNotebookBundle.message("kotlin.jupyter.dependencies.build.error.severe", new Object[0]), null, 4, null);
    }

    public final void showAbsentInitialBaseDependenciesInfo() {
        this.notify(KotlinNotebookNotificationType.ABSENT_INITIAL_BASE_DEPENDENCIES_INFO, KotlinNotebookBundle.message("kotlin.jupyter.session.initial.setup", new Object[0]), (Function1<? super Notification, Unit>)((Function1)KotlinNotebookNotifications::showAbsentInitialBaseDependenciesInfo$lambda$0));
    }

    public final void showKernelJDKInconsistentError(@NlsSafe @NotNull String loaderError) {
        Intrinsics.checkNotNullParameter((Object)loaderError, (String)"loaderError");
        this.notify(KotlinNotebookNotificationType.KERNEL_JDK_INCONSISTENT_ERROR, KotlinNotebookBundle.message("kotlin.jupyter.session.classloader.error", new Object[0]) + "\n" + loaderError, (Function1<? super Notification, Unit>)((Function1)arg_0 -> KotlinNotebookNotifications.showKernelJDKInconsistentError$lambda$0(this, arg_0)));
    }

    public static /* synthetic */ void showKernelJDKInconsistentError$default(KotlinNotebookNotifications kotlinNotebookNotifications, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        kotlinNotebookNotifications.showKernelJDKInconsistentError(string);
    }

    public final void showRerunActionNeeded() {
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.RERUN_ACTION_NEEDED, KotlinNotebookBundle.message("kotlin.jupyter.refactor.changed.definition.rerun", new Object[0]), null, 4, null);
    }

    public final void showBytecodeRefactoringWarning() {
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.BYTECODE_REFACTORING_WARNING, KotlinNotebookBundle.message("kotlin.jupyter.refactor.compiled.script", new Object[0]), null, 4, null);
    }

    public final void showRefactoringExistingUsagesMessage(int usagesCount) {
        Object[] objectArray = new Object[]{usagesCount};
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.REFACTORING_EXISTING_USAGES_MESSAGE, KotlinNotebookBundle.message("kotlin.jupyter.refactor.changed.definition", objectArray), null, 4, null);
    }

    public final void showKernelAndProjectModuleJdkAreNotAlignedWarning(@NotNull KernelJdkAlignmentCheckResult.MisalignedWithModule sdkCheckResult) {
        Intrinsics.checkNotNullParameter((Object)sdkCheckResult, (String)"sdkCheckResult");
        KotlinNotebookProjectOptionsProvider options2 = KotlinNotebookProjectOptionsProvider.Companion.getInstance(this.project);
        Sdk suggestedSdk = sdkCheckResult.getSuggestedSdk();
        Object object = options2.getJdk().getVersion(this.project);
        if (object == null && (object = options2.getJdkName$intellij_kotlin_jupyter_core()) == null) {
            return;
        }
        JavaSdkVersion currentSdkName = object;
        Object[] objectArray = new Object[]{currentSdkName, sdkCheckResult.getConflictingModule()};
        this.notify(KotlinNotebookNotificationType.KERNEL_JDK_INCONSISTENT_ERROR, KotlinNotebookBundle.message("kotlin.jupyter.session.jdk.inconsistent.error", objectArray), (Function1<? super Notification, Unit>)((Function1)arg_0 -> KotlinNotebookNotifications.showKernelAndProjectModuleJdkAreNotAlignedWarning$lambda$0(suggestedSdk, options2, this, arg_0)));
    }

    public final void showOutdatedKernelWarningIfNeeded() {
        KotlinKernelVersion kotlinKernelVersion = OptionsUtilKt.getSelectedKernelVersion(this.project);
        if (kotlinKernelVersion == null) {
            return;
        }
        KotlinKernelVersion selectedVersion = kotlinKernelVersion;
        KotlinKernelVersion buildVersion = RuntimePropertiesKt.getCurrentKernelVersion();
        if (selectedVersion.compareTo(buildVersion) >= 0) {
            return;
        }
        KotlinNotebookProjectOptionsProvider options2 = KotlinNotebookProjectOptionsProvider.Companion.getInstance(this.project);
        if (options2.getIgnoreOutdatedKernelVersion()) {
            return;
        }
        Object[] objectArray = new Object[]{selectedVersion, buildVersion};
        this.notify(KotlinNotebookNotificationType.OUTDATED_KERNEL_VERSION, KotlinNotebookBundle.message("kotlin.notebook.kernel.version.warning.content", objectArray), (Function1<? super Notification, Unit>)((Function1)arg_0 -> KotlinNotebookNotifications.showOutdatedKernelWarningIfNeeded$lambda$0(options2, buildVersion, arg_0)));
    }

    public final void showNoKernelToAttach() {
        KotlinNotebookNotifications.notify$default(this, KotlinNotebookNotificationType.NO_KERNEL_TO_ATTACH, KotlinNotebookBundle.message("kotlin.notebook.no.kernel.to.attach", new Object[0]), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void notify(KotlinNotebookNotificationType type2, String content, Function1<? super Notification, Unit> customizer) {
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = this.notificationSingletons;
        KotlinNotebookNotificationType key$iv = type2;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get((Object)key$iv);
        if (object == null) {
            boolean bl = false;
            SingletonNotificationManager default$iv = new SingletonNotificationManager("Kotlin Notebook session info", type2.getNotificationType());
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        SingletonNotificationManager notificationManager = (SingletonNotificationManager)object;
        notificationManager.clear();
        notificationManager.notify(NotificationsKt.access$getKotlinNotebookTitle(), content, this.project, arg_0 -> KotlinNotebookNotifications.notify$lambda$2(customizer, arg_0));
    }

    static /* synthetic */ void notify$default(KotlinNotebookNotifications kotlinNotebookNotifications, KotlinNotebookNotificationType kotlinNotebookNotificationType, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = KotlinNotebookNotifications::notify$lambda$0;
        }
        kotlinNotebookNotifications.notify(kotlinNotebookNotificationType, string, (Function1<? super Notification, Unit>)function1);
    }

    private static final Unit showAbsentInitialBaseDependenciesInfo$lambda$0(Notification $this$notify) {
        Intrinsics.checkNotNullParameter((Object)$this$notify, (String)"$this$notify");
        $this$notify.addAction(ActionManager.getInstance().getAction("RestartKotlinNotebookHighlighting"));
        return Unit.INSTANCE;
    }

    private static final Unit showKernelJDKInconsistentError$lambda$0(KotlinNotebookNotifications this$0, Notification $this$notify) {
        Intrinsics.checkNotNullParameter((Object)$this$notify, (String)"$this$notify");
        String string = KotlinNotebookBundle.message("kotlin.jupyter.settings.JDK.action.preview", new Object[0]);
        $this$notify.addAction((AnAction)new NotificationAction(this$0, string){
            final /* synthetic */ KotlinNotebookNotifications this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                ShowSettingsUtil.getInstance().showSettingsDialog(KotlinNotebookNotifications.access$getProject$p(this.this$0), KotlinNotebookConfigurable.class, arg_0 -> showKernelJDKInconsistentError.1.1.actionPerformed$lambda$1(showKernelJDKInconsistentError.1.1::actionPerformed$lambda$0, arg_0));
            }

            private static final Unit actionPerformed$lambda$0(KotlinNotebookConfigurable it) {
                it.focusOn(KotlinNotebookBundle.message("kotlin.jupyter.settings.JDK.path", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit showKernelAndProjectModuleJdkAreNotAlignedWarning$lambda$0(Sdk $suggestedSdk, KotlinNotebookProjectOptionsProvider $options, KotlinNotebookNotifications this$0, Notification $this$notify) {
        Intrinsics.checkNotNullParameter((Object)$this$notify, (String)"$this$notify");
        $this$notify.setSuggestionType(true);
        String string = KotlinNotebookBundle.message("kotlin.jupyter.session.jdk.inconsistent.fix.action", new Object[0]);
        $this$notify.addAction((AnAction)new NotificationAction($suggestedSdk, $options, this$0, string){
            final /* synthetic */ Sdk $suggestedSdk;
            final /* synthetic */ KotlinNotebookProjectOptionsProvider $options;
            final /* synthetic */ KotlinNotebookNotifications this$0;
            {
                this.$suggestedSdk = $suggestedSdk;
                this.$options = $options;
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                Sdk sdk = this.$suggestedSdk;
                if ((sdk != null ? sdk.getName() : null) != null) {
                    this.$options.setJdkName$intellij_kotlin_jupyter_core(this.$suggestedSdk.getName());
                } else {
                    ShowSettingsUtil.getInstance().showSettingsDialog(KotlinNotebookNotifications.access$getProject$p(this.this$0), KotlinNotebookConfigurable.class, arg_0 -> showKernelAndProjectModuleJdkAreNotAlignedWarning.1.1.actionPerformed$lambda$1(showKernelAndProjectModuleJdkAreNotAlignedWarning.1.1::actionPerformed$lambda$0, arg_0));
                }
                notification.expire();
            }

            private static final Unit actionPerformed$lambda$0(KotlinNotebookConfigurable it) {
                it.focusOn(KotlinNotebookBundle.message("kotlin.jupyter.settings.JDK.path", new Object[0]));
                return Unit.INSTANCE;
            }

            private static final void actionPerformed$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit showOutdatedKernelWarningIfNeeded$lambda$0(KotlinNotebookProjectOptionsProvider $options, KotlinKernelVersion $buildVersion, Notification $this$notify) {
        Intrinsics.checkNotNullParameter((Object)$this$notify, (String)"$this$notify");
        $this$notify.setSuggestionType(true);
        String string = KotlinNotebookBundle.message("kotlin.notebook.kernel.version.warning.action.fix.text", new Object[0]);
        $this$notify.addAction((AnAction)new NotificationAction($options, $buildVersion, string){
            final /* synthetic */ KotlinNotebookProjectOptionsProvider $options;
            final /* synthetic */ KotlinKernelVersion $buildVersion;
            {
                this.$options = $options;
                this.$buildVersion = $buildVersion;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                this.$options.setKernelVersion(this.$buildVersion.toMavenVersion());
                notification.expire();
            }
        });
        string = KotlinNotebookBundle.message("kotlin.notebook.kernel.version.warning.action.ignore.text", new Object[0]);
        $this$notify.addAction((AnAction)new NotificationAction($options, string){
            final /* synthetic */ KotlinNotebookProjectOptionsProvider $options;
            {
                this.$options = $options;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                this.$options.setIgnoreOutdatedKernelVersion$intellij_kotlin_jupyter_core(true);
                notification.expire();
            }
        });
        return Unit.INSTANCE;
    }

    private static final Unit notify$lambda$0(Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final void notify$lambda$2(Function1 $tmp0, Notification p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke((Object)p0);
    }

    public static final /* synthetic */ Project access$getProject$p(KotlinNotebookNotifications $this) {
        return $this.project;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nnotifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 notifications.kt\ncom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,224:1\n30#2,2:225\n*S KotlinDebug\n*F\n+ 1 notifications.kt\ncom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications$Companion\n*L\n220#1:225,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookNotifications getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinNotebookNotifications> serviceClass$iv = KotlinNotebookNotifications.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinNotebookNotifications)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kotlin/jupyter/core/notifications/KotlinNotebookNotifications$KotlinNotebookNotificationType;", "", "notificationType", "Lcom/intellij/notification/NotificationType;", "<init>", "(Ljava/lang/String;ILcom/intellij/notification/NotificationType;)V", "getNotificationType", "()Lcom/intellij/notification/NotificationType;", "OUTDATED_DEPENDENCIES", "OUTDATED_KERNEL_VERSION", "ABSENT_DEPENDENCIES", "ABSENT_INITIAL_BASE_DEPENDENCIES_INFO", "KERNEL_JDK_INCONSISTENT_ERROR", "KERNEL_RESTART", "NO_KERNEL_TO_ATTACH", "RERUN_ACTION_NEEDED", "BYTECODE_REFACTORING_WARNING", "REFACTORING_EXISTING_USAGES_MESSAGE", "intellij.kotlin.jupyter.core"})
    private static final class KotlinNotebookNotificationType
    extends Enum<KotlinNotebookNotificationType> {
        @NotNull
        private final NotificationType notificationType;
        public static final /* enum */ KotlinNotebookNotificationType OUTDATED_DEPENDENCIES = new KotlinNotebookNotificationType(NotificationType.WARNING);
        public static final /* enum */ KotlinNotebookNotificationType OUTDATED_KERNEL_VERSION = new KotlinNotebookNotificationType(NotificationType.WARNING);
        public static final /* enum */ KotlinNotebookNotificationType ABSENT_DEPENDENCIES = new KotlinNotebookNotificationType(NotificationType.WARNING);
        public static final /* enum */ KotlinNotebookNotificationType ABSENT_INITIAL_BASE_DEPENDENCIES_INFO = new KotlinNotebookNotificationType(NotificationType.INFORMATION);
        public static final /* enum */ KotlinNotebookNotificationType KERNEL_JDK_INCONSISTENT_ERROR = new KotlinNotebookNotificationType(NotificationType.WARNING);
        public static final /* enum */ KotlinNotebookNotificationType KERNEL_RESTART = new KotlinNotebookNotificationType(NotificationType.INFORMATION);
        public static final /* enum */ KotlinNotebookNotificationType NO_KERNEL_TO_ATTACH = new KotlinNotebookNotificationType(NotificationType.ERROR);
        public static final /* enum */ KotlinNotebookNotificationType RERUN_ACTION_NEEDED = new KotlinNotebookNotificationType(NotificationType.INFORMATION);
        public static final /* enum */ KotlinNotebookNotificationType BYTECODE_REFACTORING_WARNING = new KotlinNotebookNotificationType(NotificationType.WARNING);
        public static final /* enum */ KotlinNotebookNotificationType REFACTORING_EXISTING_USAGES_MESSAGE = new KotlinNotebookNotificationType(NotificationType.INFORMATION);
        private static final /* synthetic */ KotlinNotebookNotificationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KotlinNotebookNotificationType(NotificationType notificationType) {
            this.notificationType = notificationType;
        }

        @NotNull
        public final NotificationType getNotificationType() {
            return this.notificationType;
        }

        public static KotlinNotebookNotificationType[] values() {
            return (KotlinNotebookNotificationType[])$VALUES.clone();
        }

        public static KotlinNotebookNotificationType valueOf(String value) {
            return Enum.valueOf(KotlinNotebookNotificationType.class, value);
        }

        @NotNull
        public static EnumEntries<KotlinNotebookNotificationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kotlinNotebookNotificationTypeArray = new KotlinNotebookNotificationType[]{KotlinNotebookNotificationType.OUTDATED_DEPENDENCIES, KotlinNotebookNotificationType.OUTDATED_KERNEL_VERSION, KotlinNotebookNotificationType.ABSENT_DEPENDENCIES, KotlinNotebookNotificationType.ABSENT_INITIAL_BASE_DEPENDENCIES_INFO, KotlinNotebookNotificationType.KERNEL_JDK_INCONSISTENT_ERROR, KotlinNotebookNotificationType.KERNEL_RESTART, KotlinNotebookNotificationType.NO_KERNEL_TO_ATTACH, KotlinNotebookNotificationType.RERUN_ACTION_NEEDED, KotlinNotebookNotificationType.BYTECODE_REFACTORING_WARNING, KotlinNotebookNotificationType.REFACTORING_EXISTING_USAGES_MESSAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

