/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.settings.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.icons.AllIcons;
import com.intellij.kotlin.jupyter.core.resources.ArtifactDescription;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifacts;
import com.intellij.kotlin.jupyter.core.resources.RepositoriesKt;
import com.intellij.kotlin.jupyter.core.resources.i18n.KotlinNotebookBundle;
import com.intellij.kotlin.jupyter.core.settings.KernelOptionsKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinKernelVersionsKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptions;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookApplicationOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookAttachedModeOptions;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookJdkOptionKt;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookProjectOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunMode;
import com.intellij.kotlin.jupyter.core.settings.KotlinNotebookSessionRunModeKt;
import com.intellij.kotlin.jupyter.core.settings.SessionOptionsProvider;
import com.intellij.kotlin.jupyter.core.settings.extensions.KotlinNotebookSettingsPanelsBuilder;
import com.intellij.kotlin.jupyter.core.settings.ui.JvmTargetForSnippetsComboBoxKt;
import com.intellij.kotlin.jupyter.core.settings.ui.MavenVersionComboBox;
import com.intellij.kotlin.jupyter.core.settings.ui.MavenVersionComboBoxKt;
import com.intellij.kotlin.jupyter.core.util.ActionsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.ui.dsl.builder.TextFieldKt;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.PluginListenerDescriptor;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.ReplCompilerMode;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 >2\u00020\u0001:\u0002=>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u001b*\u00020\u0019H\u0002J\f\u0010\u001c\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010\u001d\u001a\u00020\u0018*\u00020\u0019H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0018*\u00020\u0019H\u0002J\f\u0010\u001f\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010 \u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010!\u001a\u00020\u0018*\u00020\u0019H\u0002J\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180#*\u00020\u0019H\u0002J\u0012\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00180#*\u00020\u0019H\u0002J\f\u0010%\u001a\u00020\u0018*\u00020\u0019H\u0002J\f\u0010&\u001a\u00020\u0018*\u00020\u0019H\u0002J$\u0010'\u001a\u00020(*\u00020\u00192\b\b\u0001\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J0\u0010'\u001a\u00020(*\u00020\u00192\b\b\u0001\u0010)\u001a\u00020*2\n\b\u0001\u0010.\u001a\u0004\u0018\u00010*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,H\u0002J<\u0010/\u001a\u00020\u0018*\u00020\u00192\u000b\u00100\u001a\u00070*\u00a2\u0006\u0002\b12\r\u00102\u001a\t\u0018\u00010*\u00a2\u0006\u0002\b32\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*040,H\u0002J\u0010\u00109\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010:\u001a\u00020(2\u0006\u0010;\u001a\u00020<H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00105\u001a\u0004\u0018\u00010**\u0002068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108\u00a8\u0006?"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "parentDisposable", "Lcom/intellij/openapi/util/CheckedDisposable;", "Lorg/jetbrains/annotations/NotNull;", "applicationOptions", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookApplicationOptionsProvider;", "sessionOptions", "Lcom/intellij/kotlin/jupyter/core/settings/SessionOptionsProvider;", "projectOptions", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookProjectOptionsProvider;", "attachedProcessOptions", "Lcom/intellij/kotlin/jupyter/core/settings/KotlinNotebookAttachedModeOptions;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "createPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "createKernelVersionSelector", "Lcom/intellij/ui/dsl/builder/Row;", "Lcom/intellij/ui/dsl/builder/Panel;", "createReplCompilerModeSelector", "Lcom/intellij/ui/dsl/builder/ButtonsGroup;", "createMaxHeapSizeSpinner", "createExtraJvmArgumentsField", "createCompilerExtraArgumentsField", "createEnvironmentVariablesField", "createJdkComboBox", "createJvmTargetForSnippetsComboBox", "createJvmOptionsFromPlugins", "", "createAdditionalPanelsFromPlugins", "createAttachedProcessKernelHostField", "createAttachedProcessPortSelector", "singleRowCheckBox", "", "checkBoxTitle", "", "property", "Lkotlin/reflect/KMutableProperty0;", "", "detailedDescription", "createParametersListField", "message", "Lorg/jetbrains/annotations/Nls;", "commentMessage", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "", "selectedSdkName", "Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;", "getSelectedSdkName", "(Lcom/intellij/openapi/roots/ui/configuration/SdkComboBox;)Ljava/lang/String;", "createMessageBus", "subscribeOnKernelVersionSelectionChange", "listener", "Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder$KernelVersionSelectionChangedListener;", "KernelVersionSelectionChangedListener", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKotlinNotebookSettingsPanelBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookSettingsPanelBuilder.kt\ncom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,369:1\n42#2,3:370\n31#3:373\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookSettingsPanelBuilder.kt\ncom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder\n*L\n65#1:370,3\n179#1:373\n*E\n"})
public final class KotlinNotebookSettingsPanelBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CheckedDisposable parentDisposable;
    @NotNull
    private final KotlinNotebookApplicationOptionsProvider applicationOptions;
    @NotNull
    private final SessionOptionsProvider sessionOptions;
    @NotNull
    private final KotlinNotebookProjectOptionsProvider projectOptions;
    @NotNull
    private final KotlinNotebookAttachedModeOptions attachedProcessOptions;
    @NotNull
    private final MessageBus messageBus;
    private static final int DEFAULT_COLUMNS_COUNT = 48;
    @NotNull
    public static final String BUILD_WIDTH_GROUP = "kotlin.notebook.build";

    public KotlinNotebookSettingsPanelBuilder(@NotNull Project project, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((Disposable)disposable);
        Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
        this.parentDisposable = checkedDisposable;
        this.applicationOptions = KotlinNotebookApplicationOptions.INSTANCE.get();
        boolean $i$f$service = false;
        Class<SessionOptionsProvider> serviceClass$iv = SessionOptionsProvider.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.sessionOptions = (SessionOptionsProvider)object;
        this.projectOptions = KotlinNotebookProjectOptionsProvider.Companion.getInstance(this.project);
        this.attachedProcessOptions = KotlinNotebookAttachedModeOptions.Companion.getInstance(this.project);
        this.messageBus = this.createMessageBus(this.parentDisposable);
    }

    @NotNull
    public final DialogPanel createPanel() {
        return BuilderKt.panel(arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0(this, arg_0));
    }

    private final Row createKernelVersionSelector(Panel $this$createKernelVersionSelector) {
        return $this$createKernelVersionSelector.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.kernel.version", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final ButtonsGroup createReplCompilerModeSelector(Panel $this$createReplCompilerModeSelector) {
        void $this$bind$iv;
        if (!KernelOptionsKt.getReplCompilerModeSelectorEnabled()) {
            return null;
        }
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$createReplCompilerModeSelector, null, (boolean)false, KotlinNotebookSettingsPanelBuilder::createReplCompilerModeSelector$lambda$0, (int)3, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getReplCompilerMode();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setReplCompilerMode((ReplCompilerMode)((Object)value));
            }
        };
        boolean $i$f$bind = false;
        return $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), ReplCompilerMode.class);
    }

    private final Row createMaxHeapSizeSpinner(Panel $this$createMaxHeapSizeSpinner) {
        return $this$createMaxHeapSizeSpinner.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.jvm.max.heap", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createMaxHeapSizeSpinner$lambda$0(this, arg_0));
    }

    private final Row createExtraJvmArgumentsField(Panel $this$createExtraJvmArgumentsField) {
        return this.createParametersListField($this$createExtraJvmArgumentsField, KotlinNotebookBundle.message("kotlin.jupyter.settings.jvm.extra.args", new Object[0]), KotlinNotebookBundle.message("kotlin.jupyter.settings.jvm.extra.args.comment", new Object[0]), (KMutableProperty0<List<String>>)((KMutableProperty0)new MutablePropertyReference0Impl(this.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getExtraJvmArguments();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setExtraJvmArguments$intellij_kotlin_jupyter_core((List)value);
            }
        }));
    }

    private final Row createCompilerExtraArgumentsField(Panel $this$createCompilerExtraArgumentsField) {
        if (!KernelOptionsKt.getProjectWideExtraCompilerArgumentsSelectionEnabled()) {
            return null;
        }
        return this.createParametersListField($this$createCompilerExtraArgumentsField, KotlinNotebookBundle.message("kotlin.jupyter.settings.compiler.extra.args", new Object[0]), null, (KMutableProperty0<List<String>>)((KMutableProperty0)new MutablePropertyReference0Impl(this.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getExtraCompilerArguments();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setExtraCompilerArguments$intellij_kotlin_jupyter_core((List)value);
            }
        }));
    }

    private final Row createEnvironmentVariablesField(Panel $this$createEnvironmentVariablesField) {
        return $this$createEnvironmentVariablesField.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.environment.variables", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createEnvironmentVariablesField$lambda$0(this, arg_0));
    }

    private final Row createJdkComboBox(Panel $this$createJdkComboBox) {
        return $this$createJdkComboBox.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.JDK.path", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createJdkComboBox$lambda$0(this, arg_0));
    }

    private final Row createJvmTargetForSnippetsComboBox(Panel $this$createJvmTargetForSnippetsComboBox) {
        return $this$createJvmTargetForSnippetsComboBox.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.jvm.target.for.snippets", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createJvmTargetForSnippetsComboBox$lambda$0(this, arg_0));
    }

    private final List<Row> createJvmOptionsFromPlugins(Panel $this$createJvmOptionsFromPlugins) {
        return KotlinNotebookSettingsPanelsBuilder.Companion.buildAdditionalJvmAndBuildOptions(this.project, $this$createJvmOptionsFromPlugins, (Disposable)this.parentDisposable);
    }

    private final List<Row> createAdditionalPanelsFromPlugins(Panel $this$createAdditionalPanelsFromPlugins) {
        return KotlinNotebookSettingsPanelsBuilder.Companion.buildAdditionalOptionPanels(this.project, $this$createAdditionalPanelsFromPlugins, (Disposable)this.parentDisposable);
    }

    private final Row createAttachedProcessKernelHostField(Panel $this$createAttachedProcessKernelHostField) {
        return $this$createAttachedProcessKernelHostField.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.session.attached.host", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createAttachedProcessKernelHostField$lambda$0(this, arg_0));
    }

    private final Row createAttachedProcessPortSelector(Panel $this$createAttachedProcessPortSelector) {
        return $this$createAttachedProcessPortSelector.row(KotlinNotebookBundle.message("kotlin.jupyter.settings.session.attached.ports", new Object[0]), arg_0 -> KotlinNotebookSettingsPanelBuilder.createAttachedProcessPortSelector$lambda$0(this, arg_0));
    }

    private final void singleRowCheckBox(Panel $this$singleRowCheckBox, @NlsContexts.Checkbox String checkBoxTitle, KMutableProperty0<Boolean> property2) {
        this.singleRowCheckBox($this$singleRowCheckBox, checkBoxTitle, null, property2);
    }

    private final void singleRowCheckBox(Panel $this$singleRowCheckBox, @NlsContexts.Checkbox String checkBoxTitle, @NlsContexts.DetailedDescription String detailedDescription, KMutableProperty0<Boolean> property2) {
        $this$singleRowCheckBox.row(null, arg_0 -> KotlinNotebookSettingsPanelBuilder.singleRowCheckBox$lambda$0(checkBoxTitle, property2, detailedDescription, arg_0));
    }

    private final Row createParametersListField(Panel $this$createParametersListField, String message, String commentMessage, KMutableProperty0<List<String>> property2) {
        return $this$createParametersListField.row(message, arg_0 -> KotlinNotebookSettingsPanelBuilder.createParametersListField$lambda$0(commentMessage, property2, arg_0));
    }

    private final String getSelectedSdkName(SdkComboBox $this$selectedSdkName) {
        if ($this$selectedSdkName.getSelectedItem() instanceof SdkListItem.ProjectSdkItem) {
            return null;
        }
        Sdk sdk = $this$selectedSdkName.getSelectedSdk();
        return sdk != null ? sdk.getName() : null;
    }

    private final MessageBus createMessageBus(CheckedDisposable parentDisposable) {
        MessageBus messageBus = MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(parentDisposable){
            final /* synthetic */ CheckedDisposable $parentDisposable;
            {
                this.$parentDisposable = $parentDisposable;
            }

            public Object createListener(PluginListenerDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                throw new UnsupportedOperationException();
            }

            public boolean isDisposed() {
                return this.$parentDisposable.isDisposed();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"newMessageBus(...)");
        return messageBus;
    }

    private final void subscribeOnKernelVersionSelectionChange(KernelVersionSelectionChangedListener listener2) {
        this.messageBus.connect((Disposable)this.parentDisposable).subscribe(KernelVersionSelectionChangedListener.Companion.getTOPIC(), (Object)listener2);
    }

    private static final Unit createPanel$lambda$0$0(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.createKernelVersionSelector($this$group);
        this$0.createReplCompilerModeSelector($this$group);
        this$0.createJdkComboBox($this$group);
        this$0.createJvmTargetForSnippetsComboBox($this$group);
        this$0.createMaxHeapSizeSpinner($this$group);
        this$0.createExtraJvmArgumentsField($this$group);
        this$0.createCompilerExtraArgumentsField($this$group);
        this$0.createEnvironmentVariablesField($this$group);
        this$0.createJvmOptionsFromPlugins($this$group);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$1(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.createAttachedProcessKernelHostField($this$group);
        this$0.createAttachedProcessPortSelector($this$group);
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$2(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("checkbox.should.stop.execution.on.failure", new Object[0]), KotlinNotebookBundle.message("checkbox.should.stop.execution.on.failure.detailed", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getShouldStopExecutionOnFailure();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setShouldStopExecutionOnFailure((Boolean)value);
            }
        }));
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("checkbox.resolve.sources", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.sessionOptions){

            public Object get() {
                return ((SessionOptionsProvider)this.receiver).getResolveSources();
            }

            public void set(Object value) {
                ((SessionOptionsProvider)this.receiver).setResolveSources((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$3(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("kotlin.jupyter.settings.outputs.swing.letsPlot", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getShowLetsPlotAsSwing();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setShowLetsPlotAsSwing((Boolean)value);
            }
        }));
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("kotlin.jupyter.settings.outputs.swing.dataframe", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getShowDataFrameAsSwing();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setShowDataFrameAsSwing((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$4(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("checkbox.should.typehint.only.active.cell", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getShouldLimitTypeHintsByActiveCell();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setShouldLimitTypeHintsByActiveCell$intellij_kotlin_jupyter_core((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0$5(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("checkbox.should.show.execution.count", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getShouldShowExecutionCount();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setShouldShowExecutionCount((Boolean)value);
            }
        }));
        this$0.singleRowCheckBox($this$group, KotlinNotebookBundle.message("checkbox.should.show.foldable.regions", new Object[0]), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.applicationOptions){

            public Object get() {
                return ((KotlinNotebookApplicationOptionsProvider)this.receiver).getShouldShowFoldings();
            }

            public void set(Object value) {
                ((KotlinNotebookApplicationOptionsProvider)this.receiver).setShouldShowFoldings((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    private static final Unit createPanel$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.build", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$0(this$0, arg_0), (int)2, null);
        if (KotlinNotebookSessionRunModeKt.isAvailable(KotlinNotebookSessionRunMode.ATTACHED_PROCESS)) {
            Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.attached.process.mode.settings.group", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$1(this$0, arg_0), (int)2, null);
        }
        this$0.createAdditionalPanelsFromPlugins($this$panel);
        Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.session", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$2(this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.outputs", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$3(this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.typeHints", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$4(this$0, arg_0), (int)2, null);
        Panel.group$default((Panel)$this$panel, (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.appearance", new Object[0]), (boolean)false, arg_0 -> KotlinNotebookSettingsPanelBuilder.createPanel$lambda$0$5(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final void createKernelVersionSelector$lambda$0$3$0(ActionButton $button, String $defaultVersion, KotlinKernelVersion newVersion) {
        KotlinKernelVersion kotlinKernelVersion = newVersion;
        $button.setEnabled(!Intrinsics.areEqual((Object)(kotlinKernelVersion != null ? kotlinKernelVersion.toMavenVersion() : null), (Object)$defaultVersion));
    }

    private static final Unit createKernelVersionSelector$lambda$0$0(KotlinNotebookSettingsPanelBuilder this$0, MavenVersionComboBox comboBox) {
        Intrinsics.checkNotNullParameter((Object)((Object)comboBox), (String)"comboBox");
        ((KernelVersionSelectionChangedListener)this$0.messageBus.syncPublisher(KernelVersionSelectionChangedListener.Companion.getTOPIC())).onKernelVersionSelectionChanged(KotlinKernelVersionsKt.getSelectedKernelVersion(comboBox));
        return Unit.INSTANCE;
    }

    private static final Unit createKernelVersionSelector$lambda$0$1(Cell $comboBoxCell, String $defaultVersion, AnActionEvent it) {
        ((MavenVersionComboBox)((Object)$comboBoxCell.getComponent())).setVersion($defaultVersion);
        return Unit.INSTANCE;
    }

    private static final void createKernelVersionSelector$lambda$0$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createKernelVersionSelector$lambda$0$3(KotlinNotebookSettingsPanelBuilder this$0, String $defaultVersion, ActionButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        ActionButton button2 = $this$applyToComponent;
        this$0.subscribeOnKernelVersionSelectionChange(arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$3$0(button2, $defaultVersion, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createKernelVersionSelector$lambda$0$4(KotlinNotebookSettingsPanelBuilder this$0, AnActionEvent it) {
        ActionsKt.revealKotlinNotebookLocalKernelsFolder(this$0.project);
        return Unit.INSTANCE;
    }

    private static final void createKernelVersionSelector$lambda$0$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit createKernelVersionSelector$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String defaultVersion = RuntimePropertiesKt.getCurrentKernelVersion().toMavenVersion();
        Project project = this$0.project;
        ArtifactDescription artifactDescription = KotlinNotebookMavenArtifacts.INSTANCE.getKERNEL_SHADOWED();
        KMutableProperty0 kMutableProperty0 = (KMutableProperty0)new MutablePropertyReference0Impl(this$0.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getKernelVersion();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setKernelVersion((String)value);
            }
        };
        Comparator<String> comparator = KotlinKernelVersion.Companion.getSTRING_VERSION_COMPARATOR().reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        Cell comboBoxCell2 = Cell.comment$default((Cell)MavenVersionComboBoxKt.mavenVersionComboBox($this$row, project, artifactDescription, defaultVersion, (KMutableProperty0<String>)kMutableProperty0, comparator, RepositoriesKt.getDefaultRemoteArtifactsRepositories()).onChanged(arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$0(this$0, arg_0)), (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.kernel.version.description", new Object[0]), (int)0, null, (int)6, null);
        DumbAwareAction dumbAwareAction = DumbAwareAction.create((String)KotlinNotebookBundle.message("kotlin.jupyter.settings.kernel.restore.default.version", new Object[0]), (Icon)AllIcons.General.Reset, arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$2(arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$1(comboBoxCell2, defaultVersion, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)dumbAwareAction), null, (int)2, null).applyToComponent(arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$3(this$0, defaultVersion, arg_0));
        dumbAwareAction = DumbAwareAction.create((String)KotlinNotebookBundle.message("kotlin.jupyter.settings.kernel.explore.button.name", new Object[0]), (Icon)AllIcons.General.OpenDisk, arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$5(arg_0 -> KotlinNotebookSettingsPanelBuilder.createKernelVersionSelector$lambda$0$4(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dumbAwareAction, (String)"create(...)");
        ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)dumbAwareAction), null, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createReplCompilerModeSelector$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton(KotlinNotebookBundle.message("checkbox.replCompilerMode.k1Mode", new Object[0]), (Object)ReplCompilerMode.K1);
        $this$row.radioButton(KotlinNotebookBundle.message("checkbox.replCompilerMode.k2Mode", new Object[0]), (Object)ReplCompilerMode.K2);
        return Unit.INSTANCE;
    }

    private static final Unit createReplCompilerModeSelector$lambda$0(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        $this$buttonsGroup.row("", KotlinNotebookSettingsPanelBuilder::createReplCompilerModeSelector$lambda$0$0);
        return Unit.INSTANCE;
    }

    private static final Unit createMaxHeapSizeSpinner$lambda$0$0$0$0(Function0 $callback, JBIntSpinner it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $callback.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit createMaxHeapSizeSpinner$lambda$0$0$0(Cell $it, Function0 callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        $it.onChanged(arg_0 -> KotlinNotebookSettingsPanelBuilder.createMaxHeapSizeSpinner$lambda$0$0$0$0(callback, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createMaxHeapSizeSpinner$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell it = cell = SpinnerKt.bindIntValue((Cell)$this$row.spinner(new IntRange(0, 99999), 100), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getHeapMaxLimitInMib();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setHeapMaxLimitInMib$intellij_kotlin_jupyter_core(((Number)value).intValue());
            }
        }));
        boolean bl = false;
        it.validationRequestor(arg_0 -> KotlinNotebookSettingsPanelBuilder.createMaxHeapSizeSpinner$lambda$0$0$0(it, arg_0));
        $this$row.label(KotlinNotebookBundle.message("kotlin.jupyter.settings.jvm.max.heap.units", new Object[0]));
        return Unit.INSTANCE;
    }

    private static final Map createEnvironmentVariablesField$lambda$0$0(EnvironmentVariablesTextFieldWithBrowseButton component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Map map = component.getEnvs();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvs(...)");
        return map;
    }

    private static final Unit createEnvironmentVariablesField$lambda$0$1(EnvironmentVariablesTextFieldWithBrowseButton component, Map value) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        component.setEnvs(value);
        return Unit.INSTANCE;
    }

    private static final Unit createEnvironmentVariablesField$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell.comment$default((Cell)$this$row.cell((JComponent)new EnvironmentVariablesTextFieldWithBrowseButton()).widthGroup(BUILD_WIDTH_GROUP), (String)ExecutionBundle.message((String)"environment.variables.fragment.hint", (Object[])new Object[0]), (int)0, null, (int)6, null).bind(KotlinNotebookSettingsPanelBuilder::createEnvironmentVariablesField$lambda$0$0, KotlinNotebookSettingsPanelBuilder::createEnvironmentVariablesField$lambda$0$1, MutablePropertyKt.toMutableProperty((KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getExtraEnvironmentVariables();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setExtraEnvironmentVariables$intellij_kotlin_jupyter_core((Map)value);
            }
        })));
        return Unit.INSTANCE;
    }

    private static final Unit createJdkComboBox$lambda$0$0(KotlinNotebookSettingsPanelBuilder this$0, SdkComboBox $sdkComboBox) {
        String jdkName2 = this$0.projectOptions.getJdkName$intellij_kotlin_jupyter_core();
        if (jdkName2 != null) {
            $sdkComboBox.setSelectedSdk(jdkName2);
        } else {
            $sdkComboBox.setSelectedItem((Object)new SdkListItem.ProjectSdkItem());
        }
        return Unit.INSTANCE;
    }

    private static final boolean createJdkComboBox$lambda$0$1(ProjectSdksModel $sdkModel, KotlinNotebookSettingsPanelBuilder this$0, SdkComboBox $sdkComboBox) {
        return $sdkModel.isModified() || !Intrinsics.areEqual((Object)this$0.projectOptions.getJdkName$intellij_kotlin_jupyter_core(), (Object)this$0.getSelectedSdkName($sdkComboBox));
    }

    private static final Unit createJdkComboBox$lambda$0$2(ProjectSdksModel $sdkModel, KotlinNotebookSettingsPanelBuilder this$0, SdkComboBox $sdkComboBox) {
        if ($sdkModel.isModified()) {
            $sdkModel.apply();
        }
        this$0.projectOptions.setJdkName$intellij_kotlin_jupyter_core(this$0.getSelectedSdkName($sdkComboBox));
        return Unit.INSTANCE;
    }

    private static final Unit createJdkComboBox$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        SdkComboBox sdkComboBox = new SdkComboBox(SdkComboBoxModel.Companion.createProjectJdkComboBoxModel$default((SdkComboBoxModel.Companion)SdkComboBoxModel.Companion, (Project)this$0.project, (Disposable)((Disposable)this$0.parentDisposable), null, null, KotlinNotebookJdkOptionKt::isSuitableForStartingKernel, (int)12, null));
        ProjectSdksModel sdkModel = sdkComboBox.getModel().getSdksModel();
        Object[] objectArray = new Object[]{KotlinNotebookJdkOptionKt.getMinJdkVersion().getDescription()};
        Cell.comment$default((Cell)$this$row.cell((JComponent)sdkComboBox).widthGroup(BUILD_WIDTH_GROUP), (String)KotlinNotebookBundle.message("kotlin.jupyter.settings.JDK.comment", objectArray), (int)0, null, (int)6, null).onReset(() -> KotlinNotebookSettingsPanelBuilder.createJdkComboBox$lambda$0$0(this$0, sdkComboBox)).onIsModified(() -> KotlinNotebookSettingsPanelBuilder.createJdkComboBox$lambda$0$1(sdkModel, this$0, sdkComboBox)).onApply(() -> KotlinNotebookSettingsPanelBuilder.createJdkComboBox$lambda$0$2(sdkModel, this$0, sdkComboBox));
        return Unit.INSTANCE;
    }

    private static final Unit createJvmTargetForSnippetsComboBox$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        JvmTargetForSnippetsComboBoxKt.snippetsLanguageLevelComboBox($this$row, (KMutableProperty0<LanguageLevel>)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.projectOptions){

            public Object get() {
                return ((KotlinNotebookProjectOptionsProvider)this.receiver).getJvmTargetForSnippets();
            }

            public void set(Object value) {
                ((KotlinNotebookProjectOptionsProvider)this.receiver).setJvmTargetForSnippets((LanguageLevel)value);
            }
        })).widthGroup(BUILD_WIDTH_GROUP);
        return Unit.INSTANCE;
    }

    private static final Unit createAttachedProcessKernelHostField$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.attachedProcessOptions){

            public Object get() {
                return ((KotlinNotebookAttachedModeOptions)this.receiver).getHost();
            }

            public void set(Object value) {
                ((KotlinNotebookAttachedModeOptions)this.receiver).setHost((String)value);
            }
        })).widthGroup(BUILD_WIDTH_GROUP);
        return Unit.INSTANCE;
    }

    private static final Unit createAttachedProcessPortSelector$lambda$0(KotlinNotebookSettingsPanelBuilder this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        TextFieldKt.bindIntText((Cell)$this$row.textField(), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.attachedProcessOptions){

            public Object get() {
                return ((KotlinNotebookAttachedModeOptions)this.receiver).getWebSocketPort();
            }

            public void set(Object value) {
                ((KotlinNotebookAttachedModeOptions)this.receiver).setWebSocketPort(((Number)value).intValue());
            }
        })).widthGroup(BUILD_WIDTH_GROUP);
        return Unit.INSTANCE;
    }

    private static final Unit singleRowCheckBox$lambda$0(String $checkBoxTitle, KMutableProperty0 $property, String $detailedDescription, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$singleRowCheckBox_u24lambda_u240_u240 = cell = $this$row.checkBox($checkBoxTitle);
        boolean bl = false;
        String string = $detailedDescription;
        if (string != null) {
            String commentMessage = string;
            Cell.comment$default((Cell)$this$singleRowCheckBox_u24lambda_u240_u240, (String)commentMessage, (int)0, null, (int)6, null);
        }
        ButtonKt.bindSelected((Cell)cell, (KMutableProperty0)$property);
        return Unit.INSTANCE;
    }

    private static final Unit createParametersListField$lambda$0$1(ExpandableTextField $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setMonospaced(true);
        return Unit.INSTANCE;
    }

    private static final String createParametersListField$lambda$0$2(KMutableProperty0 $property) {
        Object object = ParametersListUtil.DEFAULT_LINE_JOINER.fun($property.get());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fun(...)");
        return (String)object;
    }

    private static final Unit createParametersListField$lambda$0$3(KMutableProperty0 $property, String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List list = ParametersListUtil.parse((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
        $property.set((Object)list);
        return Unit.INSTANCE;
    }

    private static final Unit createParametersListField$lambda$0(String $commentMessage, KMutableProperty0 $property, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell $this$createParametersListField_u24lambda_u240_u240 = cell = Row.expandableTextField$default((Row)$this$row, null, null, (int)3, null);
        boolean bl = false;
        if ($commentMessage != null) {
            Cell.comment$default((Cell)$this$createParametersListField_u24lambda_u240_u240, (String)$commentMessage, (int)0, null, (int)6, null);
        }
        TextFieldKt.bindText((Cell)TextFieldKt.columns((Cell)cell, (int)48).widthGroup(BUILD_WIDTH_GROUP).applyToComponent(KotlinNotebookSettingsPanelBuilder::createParametersListField$lambda$0$1), () -> KotlinNotebookSettingsPanelBuilder.createParametersListField$lambda$0$2($property), arg_0 -> KotlinNotebookSettingsPanelBuilder.createParametersListField$lambda$0$3($property, arg_0));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder$Companion;", "", "<init>", "()V", "DEFAULT_COLUMNS_COUNT", "", "BUILD_WIDTH_GROUP", "", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e6\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder$KernelVersionSelectionChangedListener;", "", "onKernelVersionSelectionChanged", "", "newVersion", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelVersion;", "Companion", "intellij.kotlin.jupyter.core"})
    public static interface KernelVersionSelectionChangedListener {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public void onKernelVersionSelectionChanged(@Nullable KotlinKernelVersion var1);

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder$KernelVersionSelectionChangedListener$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/kotlin/jupyter/core/settings/ui/KotlinNotebookSettingsPanelBuilder$KernelVersionSelectionChangedListener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.kotlin.jupyter.core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @Topic.ProjectLevel
            @NotNull
            private static final Topic<KernelVersionSelectionChangedListener> TOPIC;

            private Companion() {
            }

            @NotNull
            public final Topic<KernelVersionSelectionChangedListener> getTOPIC() {
                return TOPIC;
            }

            static {
                $$INSTANCE = new Companion();
                TOPIC = new Topic(KernelVersionSelectionChangedListener.class, Topic.BroadcastDirection.NONE);
            }
        }
    }
}

