/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.libraries;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryDefinition;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryReference;
import org.jetbrains.kotlinx.jupyter.api.libraries.LibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.api.libraries.Variable;
import org.jetbrains.kotlinx.jupyter.common.LibraryDescriptorsManager;
import org.jetbrains.kotlinx.jupyter.libraries.AbstractLibraryResolutionInfo;
import org.jetbrains.kotlinx.jupyter.libraries.ChainedLibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultLibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.DescriptorOptionsParsingKt;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptor;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryDescriptorGlobalOptions;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryResolver;
import org.jetbrains.kotlinx.jupyter.libraries.ParsingKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlinx/jupyter/libraries/ResourcesLibraryResolver;", "Lorg/jetbrains/kotlinx/jupyter/libraries/ChainedLibraryResolver;", "parent", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;", "libraryDescriptorsManager", "Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;", "classLoader", "Ljava/lang/ClassLoader;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryResolver;Lorg/jetbrains/kotlinx/jupyter/common/LibraryDescriptorsManager;Ljava/lang/ClassLoader;)V", "tryResolve", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryDefinition;", "reference", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/LibraryReference;", "arguments", "", "Lorg/jetbrains/kotlinx/jupyter/api/libraries/Variable;", "resolveDescriptorFromResources", "", "libraryName", "resolveDescriptorOptionsFromResources", "Lorg/jetbrains/kotlinx/jupyter/libraries/LibraryDescriptorGlobalOptions;", "shouldResolve", "", "shared-compiler"})
public class ResourcesLibraryResolver
extends ChainedLibraryResolver {
    @NotNull
    private final LibraryDescriptorsManager libraryDescriptorsManager;
    @NotNull
    private final ClassLoader classLoader;

    public ResourcesLibraryResolver(@Nullable LibraryResolver parent, @NotNull LibraryDescriptorsManager libraryDescriptorsManager, @NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)libraryDescriptorsManager, (String)"libraryDescriptorsManager");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        super(parent);
        this.libraryDescriptorsManager = libraryDescriptorsManager;
        this.classLoader = classLoader;
    }

    @Override
    @Nullable
    protected LibraryDefinition tryResolve(@NotNull LibraryReference reference, @NotNull List<Variable> arguments) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        String string = this.resolveDescriptorFromResources(reference.getName());
        if (string == null) {
            return null;
        }
        String text = string;
        return LibraryDescriptor.convertToDefinition$default(ParsingKt.parseLibraryDescriptor(text), arguments, null, 2, null);
    }

    @Nullable
    public final String resolveDescriptorFromResources(@Nullable String libraryName) {
        URL url;
        if (libraryName == null) {
            return null;
        }
        URL uRL = this.classLoader.getResource(this.libraryDescriptorsManager.resourceLibraryPath(libraryName));
        if (uRL == null) {
            return null;
        }
        URL uRL2 = url = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        return new String(byArray, charset);
    }

    @NotNull
    public final LibraryDescriptorGlobalOptions resolveDescriptorOptionsFromResources() {
        URL url;
        URL uRL = this.classLoader.getResource(this.libraryDescriptorsManager.resourceOptionsPath());
        if (uRL == null) {
            return DefaultLibraryDescriptorGlobalOptions.INSTANCE;
        }
        URL uRL2 = url = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
        return DescriptorOptionsParsingKt.parseLibraryDescriptorGlobalOptions(new String(byArray, charset));
    }

    @Override
    protected boolean shouldResolve(@NotNull LibraryReference reference) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        LibraryResolutionInfo libraryResolutionInfo = reference.getInfo();
        return libraryResolutionInfo instanceof AbstractLibraryResolutionInfo.Default ? true : libraryResolutionInfo instanceof AbstractLibraryResolutionInfo.ByClasspath;
    }
}

