/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.io.Closeable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterCallbackBasedSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSendReceiveSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSendSocket;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterServerImplSockets;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterSocketKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.startup.KernelJupyterParams;
import org.jetbrains.kotlinx.jupyter.protocol.startup.KernelPorts;
import org.jetbrains.kotlinx.jupyter.startup.JupyterServerRunner;
import org.jetbrains.kotlinx.jupyter.ws.JupyterWsServer;
import org.jetbrains.kotlinx.jupyter.ws.WsCallbackBasedSocketQueued;
import org.jetbrains.kotlinx.jupyter.ws.WsKernelPorts;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f0\u0012H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/JupyterWsServerRunner;", "Lorg/jetbrains/kotlinx/jupyter/startup/JupyterServerRunner;", "<init>", "()V", "tryDeserializePorts", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/KernelPorts;", "json", "Lkotlinx/serialization/json/JsonObject;", "canRun", "", "ports", "start", "", "jupyterParams", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/KernelJupyterParams;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "setup", "Lkotlin/Function1;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterServerImplSockets;", "registerCloseable", "Ljava/io/Closeable;", "JupyterWsSocketHolder", "ws-server"})
@SourceDebugExtension(value={"SMAP\nJupyterWsServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterWsServer.kt\norg/jetbrains/kotlinx/jupyter/ws/JupyterWsServerRunner\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,213:1\n335#2:214\n1#3:215\n1#3:227\n1642#4,10:216\n1915#4:226\n1916#4:228\n1652#4:229\n1915#4,2:230\n1915#4,2:232\n*S KotlinDebug\n*F\n+ 1 JupyterWsServer.kt\norg/jetbrains/kotlinx/jupyter/ws/JupyterWsServerRunner\n*L\n45#1:214\n110#1:227\n110#1:216,10\n110#1:226\n110#1:228\n110#1:229\n118#1:230,2\n122#1:232,2\n*E\n"})
public final class JupyterWsServerRunner
implements JupyterServerRunner {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KernelPorts tryDeserializePorts(@NotNull JsonObject json) {
        void $this$decodeFromJsonElement$iv;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Json json2 = (Json)Json.Default;
        JsonElement jsonElement = (JsonElement)json.get((Object)"ws_port");
        if (jsonElement == null) {
            return null;
        }
        JsonElement json$iv = jsonElement;
        boolean $i$f$decodeFromJsonElement = false;
        SerializersModule serializersModule = $this$decodeFromJsonElement$iv.getSerializersModule();
        KType kType = Reflection.typeOf(Integer.TYPE);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        return new WsKernelPorts(((Number)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), json$iv)).intValue());
    }

    @Override
    public boolean canRun(@NotNull KernelPorts ports) {
        Intrinsics.checkNotNullParameter((Object)ports, (String)"ports");
        return ports instanceof WsKernelPorts;
    }

    @Override
    public void start(@NotNull KernelJupyterParams jupyterParams, @NotNull KernelLoggerFactory loggerFactory, @NotNull Function1<? super JupyterServerImplSockets, Unit> setup, @NotNull Function1<? super Closeable, Unit> registerCloseable) {
        Iterator $this$mapNotNullTo$iv$iv;
        JupyterWsServer $i$a$-require-JupyterWsServerRunner$start$wsServer$1$222;
        Intrinsics.checkNotNullParameter((Object)jupyterParams, (String)"jupyterParams");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(setup, (String)"setup");
        Intrinsics.checkNotNullParameter(registerCloseable, (String)"registerCloseable");
        EnumMap<JupyterSocketType, JupyterWsSocketHolder> socketsMap = new EnumMap<JupyterSocketType, JupyterWsSocketHolder>(JupyterSocketType.class);
        JupyterWsServerRunner $this$start_u24lambda_u240 = this;
        boolean bl = false;
        KernelPorts ports = jupyterParams.getPorts();
        if (!(ports instanceof WsKernelPorts)) {
            boolean $i$a$-require-JupyterWsServerRunner$start$wsServer$1$222 = false;
            String $i$a$-require-JupyterWsServerRunner$start$wsServer$1$222 = "Wrong KernelPorts type: " + ports;
            throw new IllegalArgumentException($i$a$-require-JupyterWsServerRunner$start$wsServer$1$222.toString());
        }
        Object address = Intrinsics.areEqual((Object)jupyterParams.getHost(), (Object)"*") ? new InetSocketAddress(((WsKernelPorts)ports).getPort()) : new InetSocketAddress(jupyterParams.getHost(), ((WsKernelPorts)ports).getPort());
        JupyterWsServer $this$start_u24lambda_u240_u242 = $i$a$-require-JupyterWsServerRunner$start$wsServer$1$222 = new JupyterWsServer((InetSocketAddress)address, loggerFactory, (Function2<? super JupyterSocketType, ? super RawMessage, Unit>)((Function2)(arg_0, arg_1) -> JupyterWsServerRunner.start$lambda$0$1(socketsMap, arg_0, arg_1)));
        boolean bl2 = false;
        $this$start_u24lambda_u240_u242.setReuseAddr(true);
        JupyterWsServer wsServer = $i$a$-require-JupyterWsServerRunner$start$wsServer$1$222;
        JupyterServerImplSockets sockets2 = new JupyterServerImplSockets(loggerFactory, wsServer, registerCloseable, socketsMap){
            private final JupyterCallbackBasedSocket shell;
            private final JupyterCallbackBasedSocket control;
            private final JupyterSendSocket iopub;
            private final JupyterSendReceiveSocket stdin;
            {
                JupyterCallbackBasedSocket jupyterCallbackBasedSocket;
                this.shell = JupyterWsServerRunner.access$start$createCallbackBasedSocketWrapper($loggerFactory, $wsServer, $registerCloseable, $socketsMap, JupyterSocketType.SHELL);
                this.control = JupyterWsServerRunner.access$start$createCallbackBasedSocketWrapper($loggerFactory, $wsServer, $registerCloseable, $socketsMap, JupyterSocketType.CONTROL);
                this.iopub = JupyterWsServerRunner.access$start$createSendSocketWrapper($loggerFactory, $wsServer, $registerCloseable, $socketsMap, JupyterSocketType.IOPUB);
                this.stdin = JupyterSocketKt.sendReceive$default((JupyterCallbackBasedSocket)JupyterWsServerRunner.access$start$createCallbackBasedSocketWrapper($loggerFactory, $wsServer, $registerCloseable, $socketsMap, JupyterSocketType.STDIN), (int)0, (int)1, null);
                JupyterCallbackBasedSocket socket = jupyterCallbackBasedSocket = JupyterWsServerRunner.access$start$createCallbackBasedSocketWrapper($loggerFactory, $wsServer, $registerCloseable, $socketsMap, JupyterSocketType.HB);
                boolean bl = false;
                socket.onRawMessage((Function1)new Function1<RawMessage, Unit>((Object)socket){

                    public final void invoke(RawMessage p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((JupyterCallbackBasedSocket)this.receiver).sendRawMessage(p0);
                    }
                });
            }

            public JupyterCallbackBasedSocket getShell() {
                return this.shell;
            }

            public JupyterCallbackBasedSocket getControl() {
                return this.control;
            }

            public JupyterSendSocket getIopub() {
                return this.iopub;
            }

            public JupyterSendReceiveSocket getStdin() {
                return this.stdin;
            }
        };
        setup.invoke((Object)sockets2);
        Thread mainThread = Thread.currentThread();
        Collection<JupyterWsSocketHolder> collection = socketsMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        address = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Thread thread;
            JupyterWsSocketHolder jupyterWsSocketHolder;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl3 = false;
            JupyterWsSocketHolder it = (JupyterWsSocketHolder)element$iv$iv;
            boolean bl4 = false;
            Object object = it;
            JupyterWsSocketHolder p0 = object;
            boolean bl5 = false;
            JupyterWsSocketHolder jupyterWsSocketHolder2 = jupyterWsSocketHolder = p0.getProcessIncomingMessages() ? object : null;
            if (jupyterWsSocketHolder != null && (object = jupyterWsSocketHolder.getSocket()) != null) {
                Intrinsics.checkNotNull((Object)mainThread);
                thread = ((WsCallbackBasedSocketQueued)object).startListening(mainThread);
            } else {
                thread = null;
            }
            if (thread == null) continue;
            Thread it$iv$iv = thread;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List socketListenerThreads = (List)destination$iv$iv;
        wsServer.run();
        try {
            Iterable $this$forEach$iv = socketListenerThreads;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl7 = false;
                it.join();
            }
        }
        catch (InterruptedException interruptedException) {
            Iterable $this$forEach$iv = socketListenerThreads;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv) {
                Thread it = (Thread)element$iv;
                boolean bl8 = false;
                it.interrupt();
            }
        }
        registerCloseable.invoke(() -> JupyterWsServerRunner.start$lambda$6(wsServer));
    }

    private static final Unit start$lambda$0$1(EnumMap $socketsMap, JupyterSocketType type2, RawMessage message) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = (JupyterWsSocketHolder)$socketsMap.get(type2);
        if (object == null || (object = ((JupyterWsSocketHolder)object).getSocket()) == null) {
            throw new RuntimeException("Unknown socket type: " + type2);
        }
        ((WsCallbackBasedSocketQueued)object).messageReceived(message);
        return Unit.INSTANCE;
    }

    private static final JupyterCallbackBasedSocket start$createCallbackBasedSocketWrapper(KernelLoggerFactory $loggerFactory, JupyterWsServer wsServer, Function1<? super Closeable, Unit> $registerCloseable, EnumMap<JupyterSocketType, JupyterWsSocketHolder> socketsMap, JupyterSocketType type2) {
        WsCallbackBasedSocketQueued wsCallbackBasedSocketQueued;
        WsCallbackBasedSocketQueued it = wsCallbackBasedSocketQueued = new WsCallbackBasedSocketQueued($loggerFactory, (Function0<? extends Iterable<? extends WebSocket>>)((Function0)new PropertyReference0Impl((Object)wsServer){

            public Object get() {
                return ((JupyterWsServer)((Object)this.receiver)).getCurrentWebSockets();
            }
        }), type2);
        boolean bl = false;
        $registerCloseable.invoke((Object)it);
        ((Map)socketsMap).put(type2, new JupyterWsSocketHolder(it, true));
        return wsCallbackBasedSocketQueued;
    }

    private static final JupyterSendSocket start$createSendSocketWrapper(KernelLoggerFactory $loggerFactory, JupyterWsServer wsServer, Function1<? super Closeable, Unit> $registerCloseable, EnumMap<JupyterSocketType, JupyterWsSocketHolder> socketsMap, JupyterSocketType type2) {
        WsCallbackBasedSocketQueued wsCallbackBasedSocketQueued;
        WsCallbackBasedSocketQueued it = wsCallbackBasedSocketQueued = new WsCallbackBasedSocketQueued($loggerFactory, (Function0<? extends Iterable<? extends WebSocket>>)((Function0)new PropertyReference0Impl((Object)wsServer){

            public Object get() {
                return ((JupyterWsServer)((Object)this.receiver)).getCurrentWebSockets();
            }
        }), type2);
        boolean bl = false;
        $registerCloseable.invoke((Object)it);
        ((Map)socketsMap).put(type2, new JupyterWsSocketHolder(it, false));
        return (JupyterSendSocket)wsCallbackBasedSocketQueued;
    }

    private static final void start$lambda$6(JupyterWsServer $wsServer) {
        $wsServer.stop();
    }

    public static final /* synthetic */ JupyterCallbackBasedSocket access$start$createCallbackBasedSocketWrapper(KernelLoggerFactory $loggerFactory, JupyterWsServer wsServer, Function1 $registerCloseable, EnumMap socketsMap, JupyterSocketType type2) {
        return JupyterWsServerRunner.start$createCallbackBasedSocketWrapper($loggerFactory, wsServer, (Function1<? super Closeable, Unit>)$registerCloseable, socketsMap, type2);
    }

    public static final /* synthetic */ JupyterSendSocket access$start$createSendSocketWrapper(KernelLoggerFactory $loggerFactory, JupyterWsServer wsServer, Function1 $registerCloseable, EnumMap socketsMap, JupyterSocketType type2) {
        return JupyterWsServerRunner.start$createSendSocketWrapper($loggerFactory, wsServer, (Function1<? super Closeable, Unit>)$registerCloseable, socketsMap, type2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/JupyterWsServerRunner$JupyterWsSocketHolder;", "", "socket", "Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocketQueued;", "processIncomingMessages", "", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocketQueued;Z)V", "getSocket", "()Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocketQueued;", "getProcessIncomingMessages", "()Z", "ws-server"})
    private static final class JupyterWsSocketHolder {
        @NotNull
        private final WsCallbackBasedSocketQueued socket;
        private final boolean processIncomingMessages;

        public JupyterWsSocketHolder(@NotNull WsCallbackBasedSocketQueued socket, boolean processIncomingMessages) {
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            this.socket = socket;
            this.processIncomingMessages = processIncomingMessages;
        }

        @NotNull
        public final WsCallbackBasedSocketQueued getSocket() {
            return this.socket;
        }

        public final boolean getProcessIncomingMessages() {
            return this.processIncomingMessages;
        }
    }
}

