/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split;

import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.task.ExternalSystemTaskManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.platform.execution.frontend.split.BuildModelUtilsKt;
import com.intellij.platform.execution.frontend.split.ExternalSystemModelUtilsKt;
import com.intellij.platform.execution.frontend.split.ThinClientExternalProjectSettings;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemExecutionSettings;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemHost;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemLocalSettings;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemSettings;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemSettingsListener;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rd.ide.model.OnEndArgs;
import com.jetbrains.rd.ide.model.OnFailureArgs;
import com.jetbrains.rd.ide.model.OnStatusChangeArgs;
import com.jetbrains.rd.ide.model.OnStatusChangeArgs2;
import com.jetbrains.rd.ide.model.OnTaskOutputArgs;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ide.model.ThinClientBuildModel;
import com.jetbrains.rd.ide.model.ThinClientBuildModel_GeneratedKt;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2 \u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0001:\u0003\u001d\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00040\u0010H\u0016J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J \u0010\u0013\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0004\u0012\u00020\u00060\u0010H\u0016J\u0016\u0010\u0016\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00060\u00180\u0017H\u0016J\u0016\u0010\u0019\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00060\u001a0\u0017H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager;", "Lcom/intellij/openapi/externalSystem/ExternalSystemManager;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalProjectSettings;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemSettingsListener;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemSettings;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemLocalSettings;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemExecutionSettings;", "<init>", "()V", "enhanceRemoteProcessing", "", "parameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSettingsProvider", "Lcom/intellij/util/Function;", "Lcom/intellij/openapi/project/Project;", "getLocalSettingsProvider", "getExecutionSettingsProvider", "Lcom/intellij/openapi/util/Pair;", "", "getProjectResolverClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemProjectResolver;", "getTaskManagerClass", "Lcom/intellij/openapi/externalSystem/task/ExternalSystemTaskManager;", "getExternalProjectDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "Companion", "ThinClientExternalSystemProjectResolver", "ThinClientExternalSystemTaskManager", "intellij.platform.execution.frontend.split"})
public final class ThinClientExternalSystemManager
implements ExternalSystemManager<ThinClientExternalProjectSettings, ThinClientExternalSystemSettingsListener, ThinClientExternalSystemSettings, ThinClientExternalSystemLocalSettings, ThinClientExternalSystemExecutionSettings> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ProjectSystemId SYSTEM_ID = new ProjectSystemId("THIN_CLIENT_EXTERNAL_SYSTEM");

    public ThinClientExternalSystemManager() {
        RegistryValue value = Registry.Companion.get(SYSTEM_ID.getId() + ".system.in.process");
        value.setValue(true);
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
    }

    @NotNull
    public ProjectSystemId getSystemId() {
        return SYSTEM_ID;
    }

    @NotNull
    public Function<Project, ThinClientExternalSystemSettings> getSettingsProvider() {
        return ThinClientExternalSystemManager::getSettingsProvider$lambda$0;
    }

    @NotNull
    public Function<Project, ThinClientExternalSystemLocalSettings> getLocalSettingsProvider() {
        return ThinClientExternalSystemManager::getLocalSettingsProvider$lambda$0;
    }

    @NotNull
    public Function<Pair<Project, String>, ThinClientExternalSystemExecutionSettings> getExecutionSettingsProvider() {
        return ThinClientExternalSystemManager::getExecutionSettingsProvider$lambda$0;
    }

    @NotNull
    public Class<? extends ExternalSystemProjectResolver<ThinClientExternalSystemExecutionSettings>> getProjectResolverClass() {
        return ThinClientExternalSystemProjectResolver.class;
    }

    @NotNull
    public Class<? extends ExternalSystemTaskManager<ThinClientExternalSystemExecutionSettings>> getTaskManagerClass() {
        return ThinClientExternalSystemTaskManager.class;
    }

    @NotNull
    public FileChooserDescriptor getExternalProjectDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"createSingleFileDescriptor(...)");
        return fileChooserDescriptor;
    }

    private static final ThinClientExternalSystemSettings getSettingsProvider$lambda$0(Project project) {
        Intrinsics.checkNotNull((Object)project);
        return new ThinClientExternalSystemSettings(project);
    }

    private static final ThinClientExternalSystemLocalSettings getLocalSettingsProvider$lambda$0(Project project) {
        Intrinsics.checkNotNull((Object)project);
        return new ThinClientExternalSystemLocalSettings(project);
    }

    private static final ThinClientExternalSystemExecutionSettings getExecutionSettingsProvider$lambda$0(Pair it) {
        return new ThinClientExternalSystemExecutionSettings();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager$Companion;", "", "<init>", "()V", "SYSTEM_ID", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSYSTEM_ID", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "intellij.platform.execution.frontend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProjectSystemId getSYSTEM_ID() {
            return SYSTEM_ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager$ThinClientExternalSystemProjectResolver;", "Lcom/intellij/openapi/externalSystem/service/project/ExternalSystemProjectResolver;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemExecutionSettings;", "<init>", "()V", "cancelTask", "", "taskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "intellij.platform.execution.frontend.split"})
    public static final class ThinClientExternalSystemProjectResolver
    implements ExternalSystemProjectResolver<ThinClientExternalSystemExecutionSettings> {
        public boolean cancelTask(@NotNull ExternalSystemTaskId taskId, @NotNull ExternalSystemTaskNotificationListener listener2) {
            Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R3\u0010\u0005\u001a'\u0012\u000e\u0012\f0\u0007\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t\u0012\u000e\u0012\f0\n\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\b\t0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager$ThinClientExternalSystemTaskManager;", "Lcom/intellij/openapi/externalSystem/task/ExternalSystemTaskManager;", "Lcom/intellij/platform/execution/frontend/split/ThinClientExternalSystemExecutionSettings;", "<init>", "()V", "originalIdMap", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "cancelTask", "", "id", "listener", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskNotificationListener;", "executeTasks", "", "projectPath", "", "settings", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientExternalSystemManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientExternalSystemManager.kt\ncom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager$ThinClientExternalSystemTaskManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n*L\n1#1,180:1\n30#2,2:181\n30#2,2:183\n14#3,7:185\n*S KotlinDebug\n*F\n+ 1 ThinClientExternalSystemManager.kt\ncom/intellij/platform/execution/frontend/split/ThinClientExternalSystemManager$ThinClientExternalSystemTaskManager\n*L\n97#1:181,2\n109#1:183,2\n137#1:185,7\n*E\n"})
    public static final class ThinClientExternalSystemTaskManager
    implements ExternalSystemTaskManager<ThinClientExternalSystemExecutionSettings> {
        @NotNull
        private final ConcurrentMap<ExternalSystemTaskId, Long> originalIdMap;

        public ThinClientExternalSystemTaskManager() {
            ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
            this.originalIdMap = concurrentMap;
        }

        public boolean cancelTask(@NotNull ExternalSystemTaskId id, @NotNull ExternalSystemTaskNotificationListener listener2) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Long l = (Long)this.originalIdMap.get(id);
            if (l == null) {
                return false;
            }
            long originalId = l;
            Project project = id.findProject();
            if (project == null) {
                return false;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ThinClientExternalSystemHost> serviceClass$iv = ThinClientExternalSystemHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ThinClientExternalSystemHost host = (ThinClientExternalSystemHost)((Object)object);
            host.cancelTask(originalId);
            return true;
        }

        public void executeTasks(@NotNull String projectPath, @NotNull ExternalSystemTaskId id, @NotNull ThinClientExternalSystemExecutionSettings settings, @NotNull ExternalSystemTaskNotificationListener listener2) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            Project project = id.findProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<ThinClientExternalSystemHost> serviceClass$iv = ThinClientExternalSystemHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ThinClientExternalSystemHost host = (ThinClientExternalSystemHost)((Object)object);
            Long l = (Long)settings.getUserData(ThinClientExternalSystemHost.Companion.getMODEL_ID_KEY());
            if (l == null) {
                return;
            }
            long originalId = l;
            ((Map)this.originalIdMap).put(id, originalId);
            AtomicReference<Object> exception = new AtomicReference<Object>(null);
            AtomicBoolean isFinished = new AtomicBoolean(false);
            LifetimeDefinition lifetimeDefinition = new LifetimeDefinition();
            host.getOnTaskOutput().adviseWithId(lifetimeDefinition.getLifetime(), originalId, (Function1<OnTaskOutputArgs, Unit>)((Function1)arg_0 -> ThinClientExternalSystemTaskManager.executeTasks$lambda$0(listener2, id, arg_0)));
            host.getOnStatusChange().adviseWithId(lifetimeDefinition.getLifetime(), originalId, (Function1<OnStatusChangeArgs, Unit>)((Function1)arg_0 -> ThinClientExternalSystemTaskManager.executeTasks$lambda$1(listener2, id, arg_0)));
            host.getOnStatusChangeBuild().adviseWithId(lifetimeDefinition.getLifetime(), originalId, (Function1<OnStatusChangeArgs2, Unit>)((Function1)arg_0 -> ThinClientExternalSystemTaskManager.executeTasks$lambda$2(project2, listener2, id, arg_0)));
            host.getOnFailure().adviseWithId(lifetimeDefinition.getLifetime(), originalId, (Function1<OnFailureArgs, Unit>)((Function1)arg_0 -> ThinClientExternalSystemTaskManager.executeTasks$lambda$3(exception, arg_0)));
            host.getOnEnd().adviseWithId(lifetimeDefinition.getLifetime(), originalId, (Function1<OnEndArgs, Unit>)((Function1)arg_0 -> ThinClientExternalSystemTaskManager.executeTasks$lambda$4(isFinished, arg_0)));
            SpinWait.Companion this_$iv = SpinWait.Companion;
            boolean $i$f$spinUntil = false;
            long spins$iv = 0L;
            while (true) {
                boolean bl = false;
                if (isFinished.get()) break;
                long l2 = spins$iv;
                spins$iv = l2 + 1L;
                if (l2 < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv / (long)100);
            }
            LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
            Exception thrownException = exception.get();
            if (thrownException != null) {
                throw thrownException;
            }
        }

        private static final Unit executeTasks$lambda$0(ExternalSystemTaskNotificationListener $listener, ExternalSystemTaskId $id, OnTaskOutputArgs model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            $listener.onTaskOutput($id, model.getText(), model.getStdOut() ? ProcessOutputType.STDOUT : ProcessOutputType.STDERR);
            return Unit.INSTANCE;
        }

        private static final Unit executeTasks$lambda$1(ExternalSystemTaskNotificationListener $listener, ExternalSystemTaskId $id, OnStatusChangeArgs model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            $listener.onStatusChange((ExternalSystemTaskNotificationEvent)ExternalSystemModelUtilsKt.fromModel(model.getEvent(), $id));
            return Unit.INSTANCE;
        }

        private static final Unit executeTasks$lambda$2(Project $project, ExternalSystemTaskNotificationListener $listener, ExternalSystemTaskId $id, OnStatusChangeArgs2 model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ThinClientBuildModel buildModel = ThinClientBuildModel_GeneratedKt.getThinClientBuildModel((Solution)FrontendSessionsUtilKt.getProtocolModel((ClientProjectSession)FrontendSessionsUtilKt.getFrontendProjectSession((Project)$project)));
            $listener.onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent($id, BuildModelUtilsKt.fromProtocolModel(model.getBuildEvent(), $project, buildModel)));
            return Unit.INSTANCE;
        }

        private static final Unit executeTasks$lambda$3(AtomicReference $exception, OnFailureArgs model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            $exception.set(new ExternalSystemException(model.getMessage()));
            return Unit.INSTANCE;
        }

        private static final Unit executeTasks$lambda$4(AtomicBoolean $isFinished, OnEndArgs model) {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            $isFinished.set(true);
            return Unit.INSTANCE;
        }
    }
}

