/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split;

import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemHost;
import com.intellij.platform.execution.frontend.split.ThinClientExternalSystemManager;
import com.intellij.platform.execution.frontend.split.ThinClientTestsExecutionConsole;
import com.intellij.platform.execution.frontend.split.tests.ThinClientTestConsoleProperties;
import com.jetbrains.codeWithMe.model.BackendRunProcessModel;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0016J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0019H\u0016\u00a8\u0006 "}, d2={"Lcom/intellij/platform/execution/frontend/split/ThinClientTestsExecutionConsoleManager;", "Lcom/intellij/openapi/externalSystem/execution/ExternalSystemExecutionConsoleManager;", "Lcom/intellij/execution/ui/ExecutionConsole;", "Lcom/intellij/execution/process/ProcessHandler;", "Lcom/intellij/build/BuildViewSettingsProvider;", "<init>", "()V", "getExternalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "attachExecutionConsole", "project", "Lcom/intellij/openapi/project/Project;", "task", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTask;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processHandler", "onOutput", "", "executionConsole", "text", "", "processOutputType", "Lcom/intellij/openapi/util/Key;", "isApplicableFor", "", "getRestartActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "consoleView", "(Lcom/intellij/execution/ui/ExecutionConsole;)[Lcom/intellij/openapi/actionSystem/AnAction;", "isExecutionViewHidden", "intellij.platform.execution.frontend.split"})
public final class ThinClientTestsExecutionConsoleManager
implements ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler>,
BuildViewSettingsProvider {
    @NotNull
    public ProjectSystemId getExternalSystemId() {
        return ThinClientExternalSystemManager.Companion.getSYSTEM_ID();
    }

    @Nullable
    public ExecutionConsole attachExecutionConsole(@NotNull Project project, @NotNull ExternalSystemTask task, @Nullable ExecutionEnvironment env, @Nullable ProcessHandler processHandler) {
        RunProfile runProfile;
        CharSequence charSequence;
        String testFramework;
        BackendRunProcessModel processModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(task instanceof UserDataHolder) || env == null || processHandler == null) {
            return null;
        }
        BackendRunProcessModel backendRunProcessModel = processModel = (BackendRunProcessModel)((UserDataHolder)task).getUserData(ThinClientExternalSystemHost.Companion.getPROCESS_MODEL());
        String string = testFramework = backendRunProcessModel != null ? backendRunProcessModel.getTestFramework() : null;
        if (processModel == null || (charSequence = (CharSequence)testFramework) == null || charSequence.length() == 0) {
            return null;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        if ((runnerAndConfigurationSettings == null || (runnerAndConfigurationSettings = runnerAndConfigurationSettings.getConfiguration()) == null) && (runnerAndConfigurationSettings = (runProfile = env.getRunProfile()) instanceof RunConfiguration ? (RunConfiguration)runProfile : null) == null) {
            return null;
        }
        RunnerAndConfigurationSettings runConfiguration = runnerAndConfigurationSettings;
        LifetimeDefinition lifetimeDefinition = new LifetimeDefinition();
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(lifetimeDefinition){
            final /* synthetic */ LifetimeDefinition $lifetimeDefinition;
            {
                this.$lifetimeDefinition = $lifetimeDefinition;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$lifetimeDefinition, (boolean)false, (int)1, null);
            }
        });
        Executor executor = env.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        ThinClientTestConsoleProperties consoleProperties = new ThinClientTestConsoleProperties((RunConfiguration)runConfiguration, executor, env.getExecutionId(), testFramework, processModel.getConsoleTextControlId());
        consoleProperties.setIdBasedTestTree(processModel.getIdBased());
        String string2 = SMTestRunnerConnectionUtil.getSplitterPropertyName((String)testFramework);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSplitterPropertyName(...)");
        String splitterProperty = string2;
        ThinClientTestsExecutionConsole consoleView2 = new ThinClientTestsExecutionConsole((TestConsoleProperties)consoleProperties, splitterProperty);
        SMTestRunnerConnectionUtil.initConsoleView((SMTRunnerConsoleView)consoleView2, (String)testFramework);
        consoleView2.attachToProcess(processHandler);
        return (ExecutionConsole)consoleView2;
    }

    public void onOutput(@NotNull ExecutionConsole executionConsole, @NotNull ProcessHandler processHandler, @NotNull String text, @NotNull Key<?> processOutputType) {
        Intrinsics.checkNotNullParameter((Object)executionConsole, (String)"executionConsole");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(processOutputType, (String)"processOutputType");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isApplicableFor(@NotNull ExternalSystemTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        if (!(task instanceof UserDataHolder)) return false;
        BackendRunProcessModel backendRunProcessModel = (BackendRunProcessModel)((UserDataHolder)task).getUserData(ThinClientExternalSystemHost.Companion.getPROCESS_MODEL());
        CharSequence charSequence = backendRunProcessModel != null ? backendRunProcessModel.getTestFramework() : null;
        if (charSequence == null) return false;
        if (charSequence.length() != 0) return true;
        return false;
    }

    @NotNull
    public AnAction[] getRestartActions(@NotNull ExecutionConsole consoleView2) {
        Intrinsics.checkNotNullParameter((Object)consoleView2, (String)"consoleView");
        AnAction[] anActionArray = new AnAction[1];
        Intrinsics.checkNotNullExpressionValue((Object)ActionManager.getInstance().getAction("RerunFailedTests"), (String)"getAction(...)");
        return anActionArray;
    }

    public boolean isExecutionViewHidden() {
        return true;
    }
}

