/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.frontend.split.configurations;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.jetbrains.codeWithMe.model.TestsModel;
import com.jetbrains.codeWithMe.model.TestsRunContentModel;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\n\u001aB\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e \r* \u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f\u0012\f\u0012\n \r*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u000f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "events", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$ScopedEventsQueue;", "", "getEventsQueue", "executionId", "forget", "", "runModelExecutionId", "Listener", "ScopedEventsQueue", "Companion", "intellij.platform.execution.frontend.split"})
@SourceDebugExtension(value={"SMAP\nThinClientTestRunContentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientTestRunContentHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n13#2:52\n13#3:53\n*S KotlinDebug\n*F\n+ 1 ThinClientTestRunContentHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost\n*L\n49#1:52\n49#1:53\n*E\n"})
public final class ThinClientTestRunContentHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    private final Map<Long, ScopedEventsQueue> events;
    @NotNull
    private static final Logger logger;

    public ThinClientTestRunContentHost(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.events = Collections.synchronizedMap(new HashMap());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ScopedEventsQueue getEventsQueue(long executionId) {
        ScopedEventsQueue scopedEventsQueue = this.events.computeIfAbsent(executionId, arg_0 -> ThinClientTestRunContentHost.getEventsQueue$lambda$1(arg_0 -> ThinClientTestRunContentHost.getEventsQueue$lambda$0(this, executionId, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)scopedEventsQueue, (String)"computeIfAbsent(...)");
        return scopedEventsQueue;
    }

    public final void forget(long runModelExecutionId) {
        block0: {
            ScopedEventsQueue removedEventsQueue = this.events.remove(runModelExecutionId);
            ScopedEventsQueue scopedEventsQueue = removedEventsQueue;
            if (scopedEventsQueue == null || (scopedEventsQueue = scopedEventsQueue.getCoroutineScope()) == null) break block0;
            kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)scopedEventsQueue, null, (int)1, null);
        }
    }

    private static final ScopedEventsQueue getEventsQueue$lambda$0(ThinClientTestRunContentHost this$0, long $executionId, Long it) {
        return new ScopedEventsQueue(CoroutineScopeKt.childScope$default((CoroutineScope)this$0.cs, (String)("TestRunContentHistEvents" + $executionId), null, (boolean)false, (int)6, null), (MutableSharedFlow<TestsModel>)SharedFlowKt.MutableSharedFlow$default((int)1000, (int)0, null, (int)6, null));
    }

    private static final ScopedEventsQueue getEventsQueue$lambda$1(Function1 $tmp0, Object p0) {
        return (ScopedEventsQueue)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ThinClientTestRunContentHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ThinClientTestRunContentHost.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.execution.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nThinClientTestRunContentHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThinClientTestRunContentHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,51:1\n30#2,2:52\n*S KotlinDebug\n*F\n+ 1 ThinClientTestRunContentHost.kt\ncom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$Companion\n*L\n47#1:52,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThinClientTestRunContentHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ThinClientTestRunContentHost> serviceClass$iv = ThinClientTestRunContentHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (ThinClientTestRunContentHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/codeWithMe/model/TestsRunContentModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.platform.execution.frontend.split"})
    public static final class Listener
    implements SolutionExtListener<TestsRunContentModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull TestsRunContentModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            ThinClientTestRunContentHost host = Companion.getInstance(session.getProject());
            model.getTestEvent().advise(lifetime, arg_0 -> Listener.extensionCreated$lambda$0(host, arg_0));
        }

        private static final Unit extensionCreated$lambda$0(ThinClientTestRunContentHost $host, TestsModel testsModel) {
            Intrinsics.checkNotNullParameter((Object)testsModel, (String)"testsModel");
            $host.getEventsQueue(testsModel.getExecutionId()).getEvents().tryEmit((Object)testsModel);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/execution/frontend/split/configurations/ThinClientTestRunContentHost$ScopedEventsQueue;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "events", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/jetbrains/codeWithMe/model/TestsModel;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/MutableSharedFlow;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getEvents", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "intellij.platform.execution.frontend.split"})
    public static final class ScopedEventsQueue {
        @NotNull
        private final CoroutineScope coroutineScope;
        @NotNull
        private final MutableSharedFlow<TestsModel> events;

        public ScopedEventsQueue(@NotNull CoroutineScope coroutineScope, @NotNull MutableSharedFlow<TestsModel> events) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter(events, (String)"events");
            this.coroutineScope = coroutineScope;
            this.events = events;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }

        @NotNull
        public final MutableSharedFlow<TestsModel> getEvents() {
            return this.events;
        }
    }
}

