/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.remotedriver.webservice.routing;

import com.jetbrains.performancePlugin.remotedriver.webservice.routing.Handler;
import com.jetbrains.performancePlugin.remotedriver.webservice.routing.StaticFile;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/StaticHandler;", "Lcom/jetbrains/performancePlugin/remotedriver/webservice/routing/Handler;", "urlPrefix", "", "<init>", "(Ljava/lang/String;)V", "path", "files", "", "Ljava/net/URL;", "match", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "execute", "", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "intellij.performanceTesting.remoteDriver"})
@SourceDebugExtension(value={"SMAP\nHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Handler.kt\ncom/jetbrains/performancePlugin/remotedriver/webservice/routing/StaticHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1205#2,2:37\n1282#2,4:39\n1807#2,3:43\n296#2,2:46\n*S KotlinDebug\n*F\n+ 1 Handler.kt\ncom/jetbrains/performancePlugin/remotedriver/webservice/routing/StaticHandler\n*L\n18#1:37,2\n18#1:39,4\n21#1:43,3\n25#1:46,2\n*E\n"})
public final class StaticHandler
implements Handler {
    @NotNull
    private final String path;
    @NotNull
    private final Map<String, URL> files;

    /*
     * WARNING - void declaration
     */
    public StaticHandler(@NotNull String urlPrefix) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)urlPrefix, (String)"urlPrefix");
        this.path = "/static";
        Object object = new String[]{"scripts.js", "styles.css", "updateButton.js", "xpathEditor.js", "img/locator.png", "img/show.png"};
        object = CollectionsKt.listOf((Object[])object);
        StaticHandler staticHandler = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)(urlPrefix + "/" + it), (Object)this.getClass().getResource(this.path + "/" + it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        staticHandler.files = destination$iv$iv;
    }

    @Override
    public boolean match(@NotNull FullHttpRequest request) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Iterable $this$any$iv = this.files.keySet();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = request.uri();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
                    if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Object execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Iterable $this$firstOrNull$iv = this.files.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string = request.uri();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri(...)");
                if (!StringsKt.endsWith$default((String)string, (String)it, (boolean)false, (int)2, null)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        String string = v1;
        if (string == null) {
            throw new IllegalArgumentException("wrong file requested " + request.uri());
        }
        String fileName = string;
        String fileType = StringsKt.endsWith$default((String)fileName, (String)".css", (boolean)false, (int)2, null) ? "text/css" : (StringsKt.endsWith$default((String)fileName, (String)".js", (boolean)false, (int)2, null) ? "text/javascript" : null);
        URL uRL = this.files.get(fileName);
        Intrinsics.checkNotNull((Object)uRL);
        return new StaticFile(fileType, TextStreamsKt.readBytes((URL)uRL));
    }
}

