/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.mvc.config.viewresolver;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateAvailabilityProvider {
    public static final ExtensionPointName<TemplateAvailabilityProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.mvc.templateAvailabilityProvider");

    public abstract boolean isTemplateAvailable(ConditionalOnEvaluationContext var1, String var2);

    protected static boolean isResourceAvailable(ConditionalOnEvaluationContext context, String fullPath) {
        if (TemplateAvailabilityProvider.isClasspathPrefix(fullPath)) {
            return TemplateAvailabilityProvider.resolveViewForClasspath(context, fullPath);
        }
        for (WebFacet webFacet : WebFacet.getInstances((Module)context.getModule())) {
            if (WebUtil.getWebUtil().findWebDirectoryElement(fullPath, webFacet) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isClasspathPrefix(String fullPath) {
        return StringUtil.startsWith((CharSequence)fullPath, (CharSequence)"classpath:");
    }

    private static boolean resolveViewForClasspath(@NotNull ConditionalOnEvaluationContext context, String fullPath) {
        if (context == null) {
            TemplateAvailabilityProvider.$$$reportNull$$$0(0);
        }
        SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)context.getAutoConfigClass(), (String)fullPath, (int)0).modules(new Module[]{context.getModule()});
        PsiReference[] references = SpringResourcesUtil.getInstance().getReferences(builder);
        Collection items = SpringResourcesUtil.getInstance().getResourceItems(references, Conditions.alwaysTrue());
        return ContainerUtil.getFirstItem((Collection)items) != null;
    }

    @Nullable
    protected static String getConfigurationOrDefaultValue(ConditionalOnEvaluationContext context, String key) {
        MetaConfigKey metaConfigKey = TemplateAvailabilityProvider.findConfigurationKey(context, key);
        if (metaConfigKey == null) {
            return null;
        }
        String value = TemplateAvailabilityProvider.getConfigurationValue(context, metaConfigKey);
        if (value != null) {
            return value;
        }
        return metaConfigKey.getDefaultValue();
    }

    @Nullable
    protected static MetaConfigKey findConfigurationKey(ConditionalOnEvaluationContext context, String key) {
        return SpringBootApplicationMetaConfigKeyManager.getInstance().findCanonicalApplicationMetaConfigKey(context.getModule(), key);
    }

    @Nullable
    protected static String getConfigurationValue(ConditionalOnEvaluationContext context, String key) {
        MetaConfigKey metaConfigKey = TemplateAvailabilityProvider.findConfigurationKey(context, key);
        if (metaConfigKey == null) {
            return null;
        }
        return TemplateAvailabilityProvider.getConfigurationValue(context, metaConfigKey);
    }

    @Nullable
    protected static String getConfigurationValue(ConditionalOnEvaluationContext context, @NotNull MetaConfigKey key) {
        if (key == null) {
            TemplateAvailabilityProvider.$$$reportNull$$$0(1);
        }
        Ref value = Ref.create();
        Processor findProcessor = results -> {
            ConfigurationValueResult item = (ConfigurationValueResult)ContainerUtil.getFirstItem((List)results);
            if (item != null) {
                value.set((Object)item.getValueText());
            }
            return false;
        };
        context.processConfigurationValues(findProcessor, true, key);
        return (String)value.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/mvc/config/viewresolver/TemplateAvailabilityProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveViewForClasspath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfigurationValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

