/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptConsumer;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilderBase;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.script.generator.ScriptingTaskKt;
import com.intellij.database.util.Version;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+J\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020)2\u0006\u00103\u001a\u000204J\b\u00105\u001a\u000206H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R(\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010!\u001a\u0004\u0018\u00010\"@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u0082\u0001\u000278\u00a8\u00069"}, d2={"Lcom/intellij/database/script/generator/ScriptingTaskBuilder;", "", "model", "Lcom/intellij/database/model/basic/BasicModel;", "<init>", "(Lcom/intellij/database/model/basic/BasicModel;)V", "getModel", "()Lcom/intellij/database/model/basic/BasicModel;", "options", "Lcom/intellij/database/script/generator/ScriptingOptions;", "getOptions", "()Lcom/intellij/database/script/generator/ScriptingOptions;", "setOptions", "(Lcom/intellij/database/script/generator/ScriptingOptions;)V", "version", "Lcom/intellij/database/util/Version;", "getVersion", "()Lcom/intellij/database/util/Version;", "setVersion", "(Lcom/intellij/database/util/Version;)V", "consumer", "Lcom/intellij/database/script/generator/ScriptConsumer;", "getConsumer", "()Lcom/intellij/database/script/generator/ScriptConsumer;", "setConsumer", "(Lcom/intellij/database/script/generator/ScriptConsumer;)V", "db", "Lcom/intellij/database/model/basic/BasicDatabase;", "currentDatabase", "getCurrentDatabase", "()Lcom/intellij/database/model/basic/BasicDatabase;", "setCurrentDatabase", "(Lcom/intellij/database/model/basic/BasicDatabase;)V", "s", "Lcom/intellij/database/model/basic/BasicSchema;", "currentSchema", "getCurrentSchema", "()Lcom/intellij/database/model/basic/BasicSchema;", "setCurrentSchema", "(Lcom/intellij/database/model/basic/BasicSchema;)V", "setCurrentNamespace", "", "nsp", "Lcom/intellij/database/model/basic/BasicNamespace;", "setCodeStyleFrom", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "setCodeStyle", "codeStyleSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "setReformat", "fmt", "", "build", "Lcom/intellij/database/script/generator/ScriptingTask;", "Lcom/intellij/database/script/generator/ScriptingAlterTaskBuilder;", "Lcom/intellij/database/script/generator/ScriptingSingleModelTaskBuilderBase;", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nScriptingTaskBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptingTaskBuilder.kt\ncom/intellij/database/script/generator/ScriptingTaskBuilder\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,129:1\n18#2:130\n18#2:131\n*S KotlinDebug\n*F\n+ 1 ScriptingTaskBuilder.kt\ncom/intellij/database/script/generator/ScriptingTaskBuilder\n*L\n64#1:130\n70#1:131\n*E\n"})
public abstract sealed class ScriptingTaskBuilder
permits ScriptingAlterTaskBuilder, ScriptingSingleModelTaskBuilderBase {
    @NotNull
    private final BasicModel model;
    @NotNull
    private ScriptingOptions options;
    @NotNull
    private Version version;
    @Nullable
    private ScriptConsumer<?> consumer;
    @Nullable
    private BasicDatabase currentDatabase;
    @Nullable
    private BasicSchema currentSchema;

    private ScriptingTaskBuilder(BasicModel model) {
        this.model = model;
        this.options = ScriptingTaskKt.defaultScriptingOptions(this.model);
        Version version = this.model.getRoot().getServerVersion();
        if (version == null) {
            Version version2 = Version.ZERO;
            version = version2;
            Intrinsics.checkNotNullExpressionValue((Object)version2, (String)"ZERO");
        }
        this.version = version;
        BasicDatabase basicDatabase = this.currentDatabase = this.model.getRoot().getCurrentDatabase();
        this.currentSchema = basicDatabase != null ? ModelFun.getCurrentSchema(basicDatabase) : null;
    }

    @NotNull
    public final BasicModel getModel() {
        return this.model;
    }

    @NotNull
    public final ScriptingOptions getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull ScriptingOptions scriptingOptions) {
        Intrinsics.checkNotNullParameter((Object)scriptingOptions, (String)"<set-?>");
        this.options = scriptingOptions;
    }

    @NotNull
    public final Version getVersion() {
        return this.version;
    }

    public final void setVersion(@NotNull Version version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"<set-?>");
        this.version = version;
    }

    @Nullable
    public final ScriptConsumer<?> getConsumer() {
        return this.consumer;
    }

    public final void setConsumer(@Nullable ScriptConsumer<?> scriptConsumer) {
        this.consumer = scriptConsumer;
    }

    @Nullable
    public final BasicDatabase getCurrentDatabase() {
        return this.currentDatabase;
    }

    public final void setCurrentDatabase(@Nullable BasicDatabase db) {
        if (db != null) {
            boolean bl = this.model.contains(db);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (!Intrinsics.areEqual((Object)this.currentDatabase, (Object)db)) {
                this.setCurrentSchema(null);
                this.currentDatabase = db;
            }
        } else {
            this.setCurrentSchema(null);
            this.currentDatabase = null;
        }
    }

    @Nullable
    public final BasicSchema getCurrentSchema() {
        return this.currentSchema;
    }

    public final void setCurrentSchema(@Nullable BasicSchema s) {
        if (s != null) {
            boolean bl = this.model.contains(s);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            this.setCurrentDatabase(s.getDatabase());
            this.currentSchema = s;
        } else {
            this.currentSchema = null;
        }
    }

    public final void setCurrentNamespace(@Nullable BasicNamespace nsp) {
        BasicNamespace basicNamespace = nsp;
        if (basicNamespace instanceof BasicSchema) {
            this.setCurrentSchema((BasicSchema)nsp);
        } else if (basicNamespace instanceof BasicDatabase) {
            this.setCurrentDatabase((BasicDatabase)nsp);
        } else {
            this.setCurrentSchema(null);
        }
    }

    public final void setCodeStyleFrom(@NotNull LocalDataSource ds) {
        Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
        this.setCodeStyle(ScriptingTaskBuilderKt.getCodeStyle((DasDataSource)ds));
    }

    public final void setCodeStyle(@NotNull CodeStyleSettings codeStyleSettings) {
        DelegateScriptingOptions delegateScriptingOptions;
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        ScriptingOptions $this$asSafely$iv = this.options;
        boolean $i$f$asSafely = false;
        ScriptingOptions scriptingOptions = $this$asSafely$iv;
        if (!(scriptingOptions instanceof DelegateScriptingOptions)) {
            scriptingOptions = null;
        }
        if ((delegateScriptingOptions = (DelegateScriptingOptions)scriptingOptions) == null) {
            delegateScriptingOptions = new DelegateScriptingOptions(this.options);
        }
        DelegateScriptingOptions newOptions = delegateScriptingOptions;
        newOptions.set(ScriptingOptionStatic.CODE_STYLE, codeStyleSettings);
        this.options = newOptions;
    }

    public final void setReformat(boolean fmt) {
        DelegateScriptingOptions delegateScriptingOptions;
        ScriptingOptions $this$asSafely$iv = this.options;
        boolean $i$f$asSafely = false;
        ScriptingOptions scriptingOptions = $this$asSafely$iv;
        if (!(scriptingOptions instanceof DelegateScriptingOptions)) {
            scriptingOptions = null;
        }
        if ((delegateScriptingOptions = (DelegateScriptingOptions)scriptingOptions) == null) {
            delegateScriptingOptions = new DelegateScriptingOptions(this.options);
        }
        DelegateScriptingOptions newOptions = delegateScriptingOptions;
        newOptions.set(ScriptingOptionStatic.REFORMAT, fmt);
        this.options = newOptions;
    }

    @NotNull
    public abstract ScriptingTask build();

    public /* synthetic */ ScriptingTaskBuilder(BasicModel model, DefaultConstructorMarker $constructor_marker) {
        this(model);
    }
}

