/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.completion.cloud.inline.debounce;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0003\u0010\u0011\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage;", "", "<init>", "()V", "previousCompletions", "Ljava/util/ArrayDeque;", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$FinishedCompletion;", "record", "", "result", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;", "getRecentCompletions", "", "cleanupExpired", "now", "", "Result", "FinishedCompletion", "Companion", "intellij.ml.llm.completion"})
@ApiStatus.Internal
public final class CloudInlineCompletionFinishedCompletionsStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayDeque<FinishedCompletion> previousCompletions = new ArrayDeque();
    private static final int MAX_SIZE = 100;
    private static final long EXPIRATION_MS = 600000L;

    public final void record(@NotNull Result result2) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        long now = System.currentTimeMillis();
        this.cleanupExpired(now);
        if (this.previousCompletions.size() == 100) {
            this.previousCompletions.removeFirst();
        }
        this.previousCompletions.addLast(new FinishedCompletion(result2, now));
    }

    @NotNull
    public final List<FinishedCompletion> getRecentCompletions() {
        this.cleanupExpired(System.currentTimeMillis());
        return new ArrayList(this.previousCompletions);
    }

    private final void cleanupExpired(long now) {
        FinishedCompletion first;
        long threshold2 = now - 600000L;
        while (this.previousCompletions.peekFirst() != null && first.getFinishTime() < threshold2) {
            this.previousCompletions.removeFirst();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Companion;", "", "<init>", "()V", "MAX_SIZE", "", "EXPIRATION_MS", "", "getInstance", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.completion"})
    @SourceDebugExtension(value={"SMAP\nCloudInlineCompletionFinishedCompletionsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloudInlineCompletionFinishedCompletionsStorage.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,55:1\n30#2,2:56\n*S KotlinDebug\n*F\n+ 1 CloudInlineCompletionFinishedCompletionsStorage.kt\ncom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Companion\n*L\n53#1:56,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CloudInlineCompletionFinishedCompletionsStorage getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CloudInlineCompletionFinishedCompletionsStorage> serviceClass$iv = CloudInlineCompletionFinishedCompletionsStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CloudInlineCompletionFinishedCompletionsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$FinishedCompletion;", "", "result", "Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;", "finishTime", "", "<init>", "(Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;J)V", "getResult", "()Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;", "getFinishTime", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.completion"})
    public static final class FinishedCompletion {
        @NotNull
        private final Result result;
        private final long finishTime;

        public FinishedCompletion(@NotNull Result result2, long finishTime) {
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            this.result = result2;
            this.finishTime = finishTime;
        }

        @NotNull
        public final Result getResult() {
            return this.result;
        }

        public final long getFinishTime() {
            return this.finishTime;
        }

        @NotNull
        public final Result component1() {
            return this.result;
        }

        public final long component2() {
            return this.finishTime;
        }

        @NotNull
        public final FinishedCompletion copy(@NotNull Result result2, long finishTime) {
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            return new FinishedCompletion(result2, finishTime);
        }

        public static /* synthetic */ FinishedCompletion copy$default(FinishedCompletion finishedCompletion, Result result2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                result2 = finishedCompletion.result;
            }
            if ((n & 2) != 0) {
                l = finishedCompletion.finishTime;
            }
            return finishedCompletion.copy(result2, l);
        }

        @NotNull
        public String toString() {
            return "FinishedCompletion(result=" + this.result + ", finishTime=" + this.finishTime + ")";
        }

        public int hashCode() {
            int result2 = this.result.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.finishTime);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FinishedCompletion)) {
                return false;
            }
            FinishedCompletion finishedCompletion = (FinishedCompletion)other;
            if (this.result != finishedCompletion.result) {
                return false;
            }
            return this.finishTime == finishedCompletion.finishTime;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/completion/cloud/inline/debounce/CloudInlineCompletionFinishedCompletionsStorage$Result;", "", "<init>", "(Ljava/lang/String;I)V", "ACCEPTED", "REJECTED", "OTHER", "intellij.ml.llm.completion"})
    public static final class Result
    extends Enum<Result> {
        public static final /* enum */ Result ACCEPTED = new Result();
        public static final /* enum */ Result REJECTED = new Result();
        public static final /* enum */ Result OTHER = new Result();
        private static final /* synthetic */ Result[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        @NotNull
        public static EnumEntries<Result> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = resultArray = new Result[]{Result.ACCEPTED, Result.REJECTED, Result.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

