/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.terminal.completion.validation;

import com.intellij.ml.llm.terminal.completion.ParsedCommand;
import com.intellij.ml.llm.terminal.completion.validation.RiskCategory;
import com.intellij.ml.llm.terminal.completion.validation.Validator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/terminal/completion/validation/ServiceDisruptionValidator;", "Lcom/intellij/ml/llm/terminal/completion/validation/Validator;", "<init>", "()V", "validate", "Lkotlin/Pair;", "Lcom/intellij/ml/llm/terminal/completion/validation/RiskCategory;", "", "command", "Lcom/intellij/ml/llm/terminal/completion/ParsedCommand;", "intellij.ml.llm.terminal.completion"})
@SourceDebugExtension(value={"SMAP\nServiceDisruptionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServiceDisruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/ServiceDisruptionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1807#2,3:47\n1807#2,3:50\n1807#2,3:53\n1807#2,3:56\n1807#2,3:59\n*S KotlinDebug\n*F\n+ 1 ServiceDisruptionValidator.kt\ncom/intellij/ml/llm/terminal/completion/validation/ServiceDisruptionValidator\n*L\n14#1:47,3\n23#1:50,3\n27#1:53,3\n34#1:56,3\n38#1:59,3\n*E\n"})
public final class ServiceDisruptionValidator
implements Validator {
    @Override
    @Nullable
    public Pair<RiskCategory, String> validate(@NotNull ParsedCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        String string = command.getBaseCommand();
        Object[] objectArray = new String[]{"shutdown", "reboot", "halt", "poweroff"};
        if (SetsKt.setOf((Object[])objectArray).contains(string)) {
            return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"system shutdown/reboot command");
        }
        if (Intrinsics.areEqual((Object)string, (Object)"init")) {
            boolean bl;
            block34: {
                $this$any$iv = command.getArgs();
                boolean $i$f$any2 = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        Object[] objectArray2 = new String[]{"0", "6"};
                        if (!SetsKt.setOf((Object[])objectArray2).contains(it)) continue;
                        bl = true;
                        break block34;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"system shutdown/reboot command");
            }
        } else if (Intrinsics.areEqual((Object)string, (Object)"systemctl")) {
            boolean $i$f$any;
            Iterable $this$any$iv;
            Object[] $i$f$any2 = new String[]{"sshd", "ssh", "networking", "network", "docker", "systemd-resolved"};
            criticalServices = SetsKt.setOf((Object[])$i$f$any2);
            String operation = (String)CollectionsKt.firstOrNull(command.getArgs());
            String string2 = operation;
            if (Intrinsics.areEqual((Object)string2, (Object)"disable")) {
                boolean bl;
                block36: {
                    $this$any$iv = command.getArgs();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            block35: {
                                String srv = (String)element$iv;
                                boolean bl4 = false;
                                Iterable $this$any$iv2 = (Iterable)criticalServices;
                                boolean $i$f$any3 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        String it = (String)element$iv2;
                                        boolean bl5 = false;
                                        if (!StringsKt.contains$default((CharSequence)srv, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                                        bl3 = true;
                                        break block35;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) continue;
                            bl = true;
                            break block36;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"disabling critical service");
                }
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"mask")) {
                return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"masking service (hard to re-enable)");
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"stop")) {
                boolean bl;
                block37: {
                    $this$any$iv = command.getArgs();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl6 = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block37;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"stopping services with wildcard");
                }
            }
        } else {
            criticalServices = new String[]{"kill", "killall", "pkill"};
            if (SetsKt.setOf((Object[])criticalServices).contains(string)) {
                String it;
                boolean bl;
                boolean $i$f$any;
                block38: {
                    $this$any$iv = command.getArgs();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl7 = false;
                            Object[] objectArray3 = new String[]{"1", "init", "systemd"};
                            if (!SetsKt.setOf((Object[])objectArray3).contains(it)) continue;
                            bl = true;
                            break block38;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"attempting to kill init process");
                }
                if (command.getArgs().isEmpty()) {
                    return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"kill command without target");
                }
                if (command.getArgs().contains("-9")) {
                    boolean bl8;
                    block39: {
                        $this$any$iv = command.getArgs();
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl8 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl9 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"*", (boolean)false, (int)2, null)) continue;
                                bl8 = true;
                                break block39;
                            }
                            bl8 = false;
                        }
                    }
                    if (bl8) {
                        return TuplesKt.to((Object)((Object)RiskCategory.SERVICE_DISRUPTION), (Object)"SIGKILL with wildcard pattern");
                    }
                }
            }
        }
        return null;
    }
}

