/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.psi.HintedPsiElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class LocalInspectionTool
extends InspectionProfileEntry
implements PossiblyDumbAware {
    public static final LocalInspectionTool[] EMPTY_ARRAY = new LocalInspectionTool[0];
    private static final Logger LOG = Logger.getInstance(LocalInspectionTool.class);
    @Language(value="RegExp")
    @NonNls
    public static final String VALID_ID_PATTERN = "[a-zA-Z_0-9.-]+";
    private static final Pattern COMPILED_VALID_ID_PATTERN = Pattern.compile("[a-zA-Z_0-9.-]+");

    public static boolean isValidID(@NotNull String id) {
        if (id == null) {
            LocalInspectionTool.$$$reportNull$$$0(0);
        }
        return !id.isEmpty() && COMPILED_VALID_ID_PATTERN.matcher(id).matches();
    }

    @NonNls
    @NotNull
    public String getID() {
        LocalDefaultNameProvider local;
        String id;
        InspectionProfileEntry.DefaultNameProvider nameProvider = this.getNameProvider();
        if (nameProvider instanceof LocalDefaultNameProvider && (id = (local = (LocalDefaultNameProvider)nameProvider).getDefaultID()) != null) {
            String string = id;
            if (string == null) {
                LocalInspectionTool.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = this.getShortName();
        if (string == null) {
            LocalInspectionTool.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getSuppressId() {
        String string = this.getID();
        if (string == null) {
            LocalInspectionTool.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NonNls
    @Nullable
    public String getAlternativeID() {
        InspectionProfileEntry.DefaultNameProvider nameProvider = this.getNameProvider();
        if (nameProvider instanceof LocalDefaultNameProvider) {
            LocalDefaultNameProvider local = (LocalDefaultNameProvider)nameProvider;
            return local.getDefaultAlternativeID();
        }
        return null;
    }

    public boolean runForWholeFile() {
        return false;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            LocalInspectionTool.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            LocalInspectionTool.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            LocalInspectionTool.$$$reportNull$$$0(6);
        }
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(7);
        }
        PsiElementVisitor psiElementVisitor = this.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            LocalInspectionTool.$$$reportNull$$$0(8);
        }
        return psiElementVisitor;
    }

    public boolean isAvailableForFile(@NotNull PsiFile file) {
        if (file == null) {
            LocalInspectionTool.$$$reportNull$$$0(9);
        }
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LocalInspectionTool.$$$reportNull$$$0(10);
        }
        return new PsiFileElementVisitor(holder, isOnTheFly);
    }

    @Nullable
    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            LocalInspectionTool.$$$reportNull$$$0(11);
        }
        return psiElement.getContainingFile();
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(12);
        }
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            LocalInspectionTool.$$$reportNull$$$0(13);
        }
        if (problemsHolder == null) {
            LocalInspectionTool.$$$reportNull$$$0(14);
        }
    }

    public @Unmodifiable @NotNull List<ProblemDescriptor> processFile(@NotNull PsiFile file, @NotNull InspectionManager manager) {
        if (file == null) {
            LocalInspectionTool.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            LocalInspectionTool.$$$reportNull$$$0(16);
        }
        List<ProblemDescriptor> list = manager.defaultProcessFile(this, file);
        if (list == null) {
            LocalInspectionTool.$$$reportNull$$$0(17);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/LocalInspectionTool";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/LocalInspectionTool";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 17: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 17 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static interface LocalDefaultNameProvider
    extends InspectionProfileEntry.DefaultNameProvider {
        @Nullable
        public String getDefaultID();

        @Nullable
        public String getDefaultAlternativeID();
    }

    private final class PsiFileElementVisitor
    extends PsiElementVisitor
    implements HintedPsiElementVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        private PsiFileElementVisitor(ProblemsHolder holder, boolean fly) {
            if (holder == null) {
                PsiFileElementVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
            this.myIsOnTheFly = fly;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                PsiFileElementVisitor.$$$reportNull$$$0(1);
            }
            this.addDescriptors(LocalInspectionTool.this.checkFile(psiFile, this.myHolder.getManager(), this.myIsOnTheFly));
        }

        private void addDescriptors(ProblemDescriptor @Nullable [] descriptors) {
            if (descriptors != null) {
                for (ProblemDescriptor descriptor : descriptors) {
                    if (descriptor != null) {
                        this.myHolder.registerProblem(descriptor);
                        continue;
                    }
                    Class<?> inspectionToolClass = LocalInspectionTool.this.getClass();
                    LOG.error((Throwable)PluginException.createByClass((String)("Array returned from checkFile() method of " + String.valueOf(inspectionToolClass) + " contains null element: " + Arrays.toString(descriptors)), null, inspectionToolClass));
                }
            }
        }

        @NotNull
        public List<Class<?>> getHintPsiElements() {
            List<Class<?>> list = List.of(PsiFile.class);
            if (list == null) {
                PsiFileElementVisitor.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/LocalInspectionTool$PsiFileElementVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/LocalInspectionTool$PsiFileElementVisitor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHintPsiElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitFile";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

