/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface FileNavigator<F extends VirtualFile> {
    public static final FileNavigator<NewVirtualFile> LEXICAL = new FileNavigator<NewVirtualFile>(){

        @Override
        @Nullable
        public NewVirtualFile parentOf(@NotNull NewVirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            return file.getParent();
        }

        @Override
        @Nullable
        public NewVirtualFile childOf(@NotNull NewVirtualFile parent, @NotNull String childName) {
            if (parent == null) {
                1.$$$reportNull$$$0(1);
            }
            if (childName == null) {
                1.$$$reportNull$$$0(2);
            }
            return parent.findChild(childName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileNavigator$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parentOf";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final FileNavigator<NewVirtualFile> POSIX_LIGHT = new FileNavigator<NewVirtualFile>(){

        @Override
        @Nullable
        public NewVirtualFile parentOf(@NotNull NewVirtualFile file) {
            if (file == null) {
                2.$$$reportNull$$$0(0);
            }
            if (file.is(VFileProperty.SYMLINK)) {
                NewVirtualFile canonicalFile = file.getCanonicalFile();
                if (NewVirtualFileSystem.LOG.isTraceEnabled()) {
                    NewVirtualFileSystem.LOG.trace("[" + file.getPath() + "]: symlink resolved to [" + String.valueOf((Object)canonicalFile) + "]");
                }
                if (canonicalFile == null) {
                    return null;
                }
                file = canonicalFile;
            }
            return file.getParent();
        }

        @Override
        @Nullable
        public NewVirtualFile childOf(@NotNull NewVirtualFile parent, @NotNull String childName) {
            if (parent == null) {
                2.$$$reportNull$$$0(1);
            }
            if (childName == null) {
                2.$$$reportNull$$$0(2);
            }
            return parent.findChild(childName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileNavigator$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parentOf";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @Nullable
    public F parentOf(@NotNull F var1);

    @Nullable
    public F childOf(@NotNull F var1, @NotNull String var2);

    @ApiStatus.Internal
    @NotNull
    public static <F extends VirtualFile> NavigateResult<F> navigate(@NotNull NewVirtualFileSystem vfs, @NotNull String path, @NotNull FileNavigator<F> navigator) {
        Pair<NewVirtualFile, Iterable<String>> rootAndPath;
        if (vfs == null) {
            FileNavigator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileNavigator.$$$reportNull$$$0(1);
        }
        if (navigator == null) {
            FileNavigator.$$$reportNull$$$0(2);
        }
        if ((rootAndPath = NewVirtualFileSystem.extractRootAndPathSegments(vfs, path)) == null) {
            if (NewVirtualFileSystem.LOG.isTraceEnabled()) {
                NewVirtualFileSystem.LOG.trace("extractRootAndPathSegments(" + String.valueOf((Object)vfs) + ", " + path + ") = null");
            }
            NavigateResult navigateResult = NavigateResult.empty();
            if (navigateResult == null) {
                FileNavigator.$$$reportNull$$$0(3);
            }
            return navigateResult;
        }
        VirtualFile file = (VirtualFile)rootAndPath.first;
        for (String pathElement : (Iterable)rootAndPath.second) {
            if (pathElement.isEmpty() || ".".equals(pathElement)) continue;
            VirtualFile fileBefore = file;
            file = "..".equals(pathElement) ? navigator.parentOf(file) : navigator.childOf(file, pathElement);
            if (NewVirtualFileSystem.LOG.isTraceEnabled()) {
                NewVirtualFileSystem.LOG.trace("[" + fileBefore.getPath() + "]/[" + pathElement + "] resolved to [" + String.valueOf(file) + "]");
            }
            if (file != null) continue;
            NavigateResult<VirtualFile> navigateResult = NavigateResult.unresolved(fileBefore);
            if (navigateResult == null) {
                FileNavigator.$$$reportNull$$$0(4);
            }
            return navigateResult;
        }
        NavigateResult<VirtualFile> navigateResult = NavigateResult.resolved(file);
        if (navigateResult == null) {
            FileNavigator.$$$reportNull$$$0(5);
        }
        return navigateResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileNavigator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileNavigator";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "navigate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class NavigateResult<F extends VirtualFile> {
        @Nullable
        private final F resolvedFile;
        private final boolean resolvedFully;

        public static <F extends VirtualFile> NavigateResult<F> empty() {
            return new NavigateResult<Object>(null, false);
        }

        public static <F extends VirtualFile> NavigateResult<F> unresolved(@NotNull F lastResolvedFile) {
            if (lastResolvedFile == null) {
                NavigateResult.$$$reportNull$$$0(0);
            }
            return new NavigateResult<F>(lastResolvedFile, false);
        }

        public static <F extends VirtualFile> NavigateResult<F> resolved(@NotNull F successfullyResolvedFile) {
            if (successfullyResolvedFile == null) {
                NavigateResult.$$$reportNull$$$0(1);
            }
            return new NavigateResult<F>(successfullyResolvedFile, true);
        }

        private NavigateResult(@Nullable F resolvedFile, boolean resolvedFully) {
            this.resolvedFile = resolvedFile;
            this.resolvedFully = resolvedFully;
        }

        public boolean isResolved() {
            return this.resolvedFully;
        }

        @NotNull
        public F resolvedFileOrFail() {
            if (this.resolvedFile != null) {
                F f = this.resolvedFile;
                if (f == null) {
                    NavigateResult.$$$reportNull$$$0(2);
                }
                return f;
            }
            throw new IllegalStateException("File was not resolved");
        }

        @Nullable
        public F resolvedFileOr(@Nullable F orElse) {
            if (!this.isResolved()) {
                return orElse;
            }
            return this.resolvedFile;
        }

        @Nullable
        public F lastResolvedFile() {
            return this.resolvedFile;
        }

        public String toString() {
            return this.isResolved() ? "NavigateResult[resolved: " + String.valueOf(this.resolvedFile) + "]" : "NavigateResult[not resolved, last resolved segment: " + String.valueOf(this.resolvedFile) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastResolvedFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "successfullyResolvedFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/newvfs/FileNavigator$NavigateResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/newvfs/FileNavigator$NavigateResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolvedFileOrFail";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "unresolved";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "resolved";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

