/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text.matching;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a(\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a(\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u000fH\u0000\u00a8\u0006\u0011"}, d2={"indexOf", "", "s", "", "c", "", "start", "end", "ignoreCase", "", "", "indexOfAny", "chars", "regionMatches", "s1", "", "s2", "intellij.platform.util.text.matching"})
public final class CharArrayUtilKt {
    public static final int indexOf(@NotNull String s, char c, int start, int end, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int n = RangesKt.coerceAtMost((int)end, (int)s.length());
        for (int i = RangesKt.coerceAtLeast((int)start, (int)0); i < n; ++i) {
            if (!CharsKt.equals((char)s.charAt(i), (char)c, (boolean)ignoreCase)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOf(@NotNull char[] s, char c, int start, int end, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int n = RangesKt.coerceAtMost((int)end, (int)s.length);
        for (int i = RangesKt.coerceAtLeast((int)start, (int)0); i < n; ++i) {
            if (!CharsKt.equals((char)s[i], (char)c, (boolean)ignoreCase)) continue;
            return i;
        }
        return -1;
    }

    public static final int indexOfAny(@NotNull String s, @NotNull char[] chars, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        if (chars.length == 0) {
            return -1;
        }
        int n = RangesKt.coerceAtMost((int)end, (int)s.length());
        for (int i = RangesKt.coerceAtLeast((int)start, (int)0); i < n; ++i) {
            if (!ArraysKt.contains((char[])chars, (char)s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static final boolean regionMatches(@NotNull CharSequence s1, int start, int end, @NotNull CharSequence s2) {
        Intrinsics.checkNotNullParameter((Object)s1, (String)"s1");
        Intrinsics.checkNotNullParameter((Object)s2, (String)"s2");
        int len = s1.length();
        if (start < 0 || start + len > end) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (s1.charAt(i) == s2.charAt(i + start)) continue;
            return false;
        }
        return true;
    }
}

