/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.projectWizard.NewProjectWizard;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.projectWizard.ProjectCategory;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.projectWizard.ProjectTemplateList;
import com.intellij.ide.projectWizard.TemplateBasedCategory;
import com.intellij.ide.projectWizard.projectTypeStep.LanguageGeneratorItem;
import com.intellij.ide.projectWizard.projectTypeStep.ProjectTypeList;
import com.intellij.ide.projectWizard.projectTypeStep.ProjectTypeListKt;
import com.intellij.ide.projectWizard.projectTypeStep.TemplateGroupItem;
import com.intellij.ide.projectWizard.projectTypeStep.UserTemplateGroupItem;
import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.newProjectWizard.WizardDelegate;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.PromoModuleBuilder;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.ide.wizard.GeneratorNewProjectWizard;
import com.intellij.ide.wizard.LanguageNewProjectWizard;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.ide.wizard.language.BaseLanguageGeneratorNewProjectWizard;
import com.intellij.ide.wizard.language.LanguageGeneratorNewProjectWizard;
import com.intellij.ide.wizard.language.LegacyLanguageGeneratorNewProjectWizard;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplateEP;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.BuilderBasedTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class ProjectTypeStep
extends ModuleWizardStep
implements SettingsStep,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.projectWizard.ProjectTypeStep");
    private static final ExtensionPointName<ProjectCategory> CATEGORY_EP = new ExtensionPointName("com.intellij.projectWizard.projectCategory");
    private static final ExtensionPointName<ProjectTemplateEP> TEMPLATE_EP = new ExtensionPointName("com.intellij.projectTemplate");
    private static final String EMPTY_CARD = "empty card";
    private static final String TEMPLATES_CARD = "templates card";
    private static final String FRAMEWORKS_CARD = "frameworks card";
    private final WizardContext myContext;
    private final NewProjectWizard myWizard;
    private final ModulesProvider myModulesProvider;
    private final AddSupportForFrameworksPanel myFrameworksPanel;
    private final ModuleBuilder.ModuleConfigurationUpdater myConfigurationUpdater;
    private final Map<ProjectTemplate, ModuleBuilder> myBuilders;
    private final MultiMap<TemplatesGroup, ProjectTemplate> myTemplatesMap;
    private final Map<String, ModuleWizardStep> myCustomSteps;
    private JPanel myPanel;
    private JPanel myOptionsPanel;
    private ProjectTemplateList myTemplatesList;
    private JPanel myFrameworksPanelPlaceholder;
    private JPanel myHeaderPanel;
    private JBLabel myFrameworksLabel;
    private JPanel mySettingsPanel;
    private JPanel myProjectTypePanel;
    @Nullable
    private ModuleWizardStep mySettingsStep;
    private String myCurrentCard;
    private final ProjectTypeList myProjectTypeList;

    public ProjectTypeStep(WizardContext context, NewProjectWizard wizard2, ModulesProvider modulesProvider) {
        com.intellij.util.Function function = key -> (ModuleBuilder)key.createModuleBuilder();
        this.$$$setupUI$$$();
        this.myBuilders = FactoryMap.create((com.intellij.util.Function)function);
        this.myCustomSteps = new HashMap<String, ModuleWizardStep>();
        this.myContext = context;
        this.myContext.addContextListener(new WizardContext.Listener(){

            public void switchToRequested(@NotNull String placeId, @NotNull Consumer<? super Step> configure) {
                TemplatesGroup groupToSelect;
                if (placeId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (configure == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((groupToSelect = (TemplatesGroup)ContainerUtil.find((Iterable)ProjectTypeStep.this.myTemplatesMap.keySet(), group -> group.getId().equals(placeId))) != null) {
                    ProjectTypeStep.this.myProjectTypeList.setSelectedTemplateGroup(groupToSelect);
                    try {
                        configure.accept((Step)ProjectTypeStep.this.getCustomStep());
                    }
                    catch (Throwable exception) {
                        throw new IllegalStateException("Cannot switch on " + placeId + ", current step " + ProjectTypeStep.this.myCurrentCard, exception);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "placeId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "configure";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/projectWizard/ProjectTypeStep$1";
                objectArray[2] = "switchToRequested";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        this.myWizard = wizard2;
        this.myTemplatesMap = MultiMap.createLinked();
        this.myProjectTypeList = new ProjectTypeList(context);
        this.myProjectTypeList.installFilteringListModel(this.getNamer(), this.getEmptyStatusPresenter());
        this.myProjectTypeList.setTemplateGroupItems(this.fillGroupTemplateMap(context));
        this.myProjectTypeList.setLanguageGeneratorItems(this.fillLanguageGeneratorTemplateMap(context));
        this.myProjectTypeList.setUserTemplateGroupItems(this.fillUserTemplateMap(context));
        this.installLanguageGeneratorWatcher(context);
        GridLayoutManager layout = (GridLayoutManager)this.myPanel.getLayout();
        layout.setHGap(0);
        this.myPanel.setLayout((LayoutManager)layout);
        this.myProjectTypePanel.setMinimumSize(new Dimension(240, 100));
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.25f);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setFirstComponent((JComponent)this.myProjectTypePanel);
        splitter.setSecondComponent((JComponent)this.mySettingsPanel);
        this.myPanel.removeAll();
        this.myPanel.add((Component)splitter, new GridConstraints(0, 0, 1, 1, 1, 3, 3, 4, null, null, null));
        this.myProjectTypePanel.add(this.myProjectTypeList.getComponent());
        JBPanelWithEmptyText panelWithEmptyText = new JBPanelWithEmptyText().withEmptyText(JavaUiBundle.message("label.select.project.type.to.configure", new Object[0]));
        this.myOptionsPanel.add((Component)panelWithEmptyText, EMPTY_CARD);
        this.mySettingsPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)1, (int)0));
        this.myModulesProvider = modulesProvider;
        Project project2 = context.getProject();
        LibrariesContainer container = LibrariesContainerFactory.createContainer(context, modulesProvider);
        FrameworkSupportModelBase model = new FrameworkSupportModelBase(project2, null, container){

            @Override
            @NotNull
            public String getBaseDirectoryForLibrariesPath() {
                ModuleBuilder builder = ProjectTypeStep.this.getSelectedBuilder();
                String contentEntryPath = (String)ObjectUtils.doIfNotNull((Object)builder, it -> it.getContentEntryPath());
                String string = StringUtil.notNullize((String)contentEntryPath);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public ModuleBuilder getModuleBuilder() {
                return ProjectTypeStep.this.getSelectedBuilder();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectWizard/ProjectTypeStep$2", "getBaseDirectoryForLibrariesPath"));
            }
        };
        this.myFrameworksPanel = new AddSupportForFrameworksPanel(Collections.emptyList(), model, true, this.myHeaderPanel);
        Disposer.register((Disposable)this, (Disposable)this.myFrameworksPanel);
        this.myFrameworksPanelPlaceholder.add(this.myFrameworksPanel.getMainPanel());
        this.myFrameworksLabel.setLabelFor((Component)((Object)this.myFrameworksPanel.getFrameworksTree()));
        this.myFrameworksLabel.setBorder(JBUI.Borders.empty((int)3));
        this.myConfigurationUpdater = new ModuleBuilder.ModuleConfigurationUpdater(){

            public void update(@NotNull Module module, @NotNull ModifiableRootModel rootModel) {
                if (module == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rootModel == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (ProjectTypeStep.this.isFrameworksMode()) {
                    ProjectTypeStep.this.myFrameworksPanel.addSupport(module, rootModel);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rootModel";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/projectWizard/ProjectTypeStep$3";
                objectArray[2] = "update";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myProjectTypeList.whenProjectTemplateGroupSelected(group -> this.projectTypeChanged((TemplatesGroup)group));
        this.myTemplatesList.addListSelectionListener(event -> {
            if (!event.getValueIsAdjusting()) {
                this.updateSelection();
            }
        });
        for (TemplatesGroup templatesGroup : this.myTemplatesMap.keySet()) {
            ModuleBuilder builder = templatesGroup.getModuleBuilder();
            if (builder != null) {
                Collection<ModuleWizardStep> steps = this.myWizard.getSequence().addSteps((AbstractModuleBuilder)builder, context, modulesProvider);
                this.initStepListener(steps);
            }
            for (ProjectTemplate template : this.myTemplatesMap.get((Object)templatesGroup)) {
                Collection<ModuleWizardStep> steps = this.myWizard.getSequence().addSteps((AbstractModuleBuilder)this.myBuilders.get(template), context, modulesProvider);
                this.initStepListener(steps);
            }
        }
        this.myProjectTypeList.restoreSelection();
        this.myTemplatesList.restoreSelection();
    }

    private void initStepListener(Collection<ModuleWizardStep> steps) {
        this.myWizard.setStepListener(steps);
    }

    @NotNull
    private Function<TemplateGroupItem, String> getNamer() {
        Function<TemplateGroupItem, String> function = groupItem -> {
            ModuleWizardStep step;
            LinkedHashSet<String> keywords = new LinkedHashSet<String>();
            keywords.add(groupItem.getGroup().getName());
            ModuleBuilder builder = groupItem.getGroup().getModuleBuilder();
            if (builder != null && (step = this.myCustomSteps.get(builder.getBuilderId())) instanceof NewProjectWizardStep) {
                NewProjectWizardStep newProjectWizardStep = (NewProjectWizardStep)step;
                keywords.addAll(newProjectWizardStep.getKeywords().toSet());
            }
            return String.join((CharSequence)" ", keywords);
        };
        if (function == null) {
            ProjectTypeStep.$$$reportNull$$$0(0);
        }
        return function;
    }

    @NotNull
    private Runnable getEmptyStatusPresenter() {
        Runnable runnable = () -> {
            this.showCard(EMPTY_CARD);
            this.myWizard.updateButtons(true, false, true);
        };
        if (runnable == null) {
            ProjectTypeStep.$$$reportNull$$$0(1);
        }
        return runnable;
    }

    private static ModuleType getModuleType(TemplatesGroup group) {
        ModuleBuilder moduleBuilder = group.getModuleBuilder();
        return moduleBuilder == null ? null : moduleBuilder.getModuleType();
    }

    private static boolean matchFramework(ProjectCategory projectCategory, FrameworkSupportInModuleProvider framework) {
        FrameworkRole[] roles = framework.getRoles();
        if (roles.length == 0) {
            return true;
        }
        List<FrameworkRole> acceptable = Arrays.asList(projectCategory.getAcceptableFrameworkRoles());
        return ContainerUtil.intersects(Arrays.asList(roles), acceptable);
    }

    private static MultiMap<TemplatesGroup, ProjectTemplate> getTemplatesMap(WizardContext context) {
        ProjectTemplatesFactory[] factories = (ProjectTemplatesFactory[])ProjectTemplatesFactory.EP_NAME.getExtensions();
        MultiMap groups = new MultiMap();
        for (ProjectTemplatesFactory factory : factories) {
            for (String group : factory.getGroups()) {
                ProjectTemplate[] templates;
                List<ProjectTemplate> values;
                if (factory instanceof ArchivedTemplatesFactory || (values = Arrays.asList(templates = factory.createTemplates(group, context))).isEmpty()) continue;
                Icon icon = factory.getGroupIcon(group);
                String parentGroup = factory.getParentGroup(group);
                TemplatesGroup templatesGroup = new TemplatesGroup(group, null, icon, factory.getGroupWeight(group), parentGroup, group, null);
                templatesGroup.setPluginInfo(PluginInfoDetectorKt.getPluginInfo(factory.getClass()));
                groups.putValues((Object)templatesGroup, values);
            }
        }
        return groups;
    }

    private boolean isFrameworksMode() {
        return FRAMEWORKS_CARD.equals(this.myCurrentCard) && Objects.equals(this.getSelectedBuilder(), this.myContext.getProjectBuilder());
    }

    private @Unmodifiable @NotNull List<TemplateGroupItem> fillGroupTemplateMap(@NotNull WizardContext context) {
        TemplatesGroup group;
        if (context == null) {
            ProjectTypeStep.$$$reportNull$$$0(2);
        }
        List builders = ModuleBuilder.getAllBuilders();
        HashMap<String, TemplatesGroup> groupMap = new HashMap<String, TemplatesGroup>();
        for (ModuleBuilder builder : builders) {
            try {
                TemplatesGroup group2;
                BuilderBasedTemplate template = new BuilderBasedTemplate(builder);
                if (builder.isTemplate()) {
                    group2 = (TemplatesGroup)groupMap.get(builder.getGroupName());
                    if (group2 == null) {
                        group2 = new TemplatesGroup(builder);
                    }
                    this.myTemplatesMap.putValue((Object)group2, (Object)template);
                    continue;
                }
                group2 = new TemplatesGroup(builder);
                groupMap.put(group2.getName(), group2);
                this.myTemplatesMap.put((Object)group2, new ArrayList());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        this.myTemplatesMap.putAllValues(ProjectTypeStep.getTemplatesMap(context));
        for (Object category : CATEGORY_EP.getExtensionList()) {
            Object group3 = new TemplatesGroup((ProjectCategory)category);
            ModuleBuilder builder = ((TemplatesGroup)group3).getModuleBuilder();
            if (builder != null && !builder.isAvailable()) continue;
            this.myTemplatesMap.remove(group3);
            this.myTemplatesMap.put(group3, new ArrayList());
        }
        if (context.isCreatingNewProject()) {
            MultiMap<String, ProjectTemplate> localTemplates = this.loadLocalTemplates();
            for (Object group3 : this.myTemplatesMap.keySet()) {
                this.myTemplatesMap.putValues(group3, localTemplates.get((Object)((TemplatesGroup)group3).getId()));
            }
        }
        ArrayList groups = new ArrayList(this.myTemplatesMap.keySet());
        MultiMap moduleTypes = new MultiMap();
        for (TemplatesGroup group2 : groups) {
            ModuleType type = ProjectTypeStep.getModuleType(group2);
            moduleTypes.putValue((Object)type, (Object)group2);
        }
        groups.sort((o1, o2) -> {
            int i = o2.getWeight() - o1.getWeight();
            if (i != 0) {
                return i;
            }
            int i1 = moduleTypes.get((Object)ProjectTypeStep.getModuleType(o2)).size() - moduleTypes.get((Object)ProjectTypeStep.getModuleType(o1)).size();
            if (i1 != 0) {
                return i1;
            }
            return o1.compareTo((TemplatesGroup)o2);
        });
        Set groupNames = ContainerUtil.map2Set(groups, TemplatesGroup::getParentGroup);
        MultiMap subGroups = new MultiMap();
        ListIterator<TemplatesGroup> iterator = groups.listIterator();
        while (iterator.hasNext()) {
            group = (TemplatesGroup)iterator.next();
            String parentGroup = group.getParentGroup();
            if (parentGroup == null || !groupNames.contains(parentGroup) || group.getName().equals(parentGroup) || !groupMap.containsKey(parentGroup)) continue;
            subGroups.putValue((Object)parentGroup, (Object)group);
            iterator.remove();
        }
        iterator = groups.listIterator();
        while (iterator.hasNext()) {
            group = (TemplatesGroup)iterator.next();
            for (TemplatesGroup subGroup : subGroups.get((Object)group.getName())) {
                iterator.add(subGroup);
            }
        }
        if (PlatformUtils.isIdeaCommunity()) {
            iterator = groups.listIterator();
            while (iterator.hasNext()) {
                group = (TemplatesGroup)iterator.next();
                if (!"WEB_MODULE".equals(group.getId()) || !this.myTemplatesMap.get((Object)group).isEmpty()) continue;
                iterator.remove();
                break;
            }
        }
        List list2 = ContainerUtil.map(groups, it -> new TemplateGroupItem((TemplatesGroup)it));
        if (list2 == null) {
            ProjectTypeStep.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private List<LanguageGeneratorItem> fillLanguageGeneratorTemplateMap(@NotNull WizardContext context) {
        if (context == null) {
            ProjectTypeStep.$$$reportNull$$$0(4);
        }
        ArrayList<GeneratorNewProjectWizard> generators = new ArrayList<GeneratorNewProjectWizard>();
        LanguageNewProjectWizard.EP_NAME.forEachExtensionSafe(wizard2 -> generators.add((GeneratorNewProjectWizard)new LegacyLanguageGeneratorNewProjectWizard(context, wizard2)));
        LanguageGeneratorNewProjectWizard.EP_NAME.forEachExtensionSafe(wizard2 -> generators.add((GeneratorNewProjectWizard)new BaseLanguageGeneratorNewProjectWizard(context, wizard2)));
        generators.removeIf(it -> !it.isEnabled());
        generators.sort(Comparator.comparing(it -> it.getOrdinal()));
        if (context.isCreatingNewProject()) {
            GeneratorNewProjectWizard.EP_NAME.forEachExtensionSafe(wizard2 -> generators.add((GeneratorNewProjectWizard)wizard2));
        }
        List generatorItems = ContainerUtil.map(generators, it -> new LanguageGeneratorItem((GeneratorNewProjectWizard)it));
        for (LanguageGeneratorItem generatorItem : generatorItems) {
            this.myTemplatesMap.put((Object)generatorItem.getGroup(), new ArrayList());
        }
        List list2 = generatorItems;
        if (list2 == null) {
            ProjectTypeStep.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void installLanguageGeneratorWatcher(final @NotNull WizardContext context) {
        if (context == null) {
            ProjectTypeStep.$$$reportNull$$$0(6);
        }
        LanguageNewProjectWizard.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageNewProjectWizard>(){

            public void extensionAdded(LanguageNewProjectWizard extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                LegacyLanguageGeneratorNewProjectWizard generator = new LegacyLanguageGeneratorNewProjectWizard(context, extension);
                LanguageGeneratorItem generatorItem = new LanguageGeneratorItem((GeneratorNewProjectWizard)generator);
                ProjectTypeStep.this.myProjectTypeList.addLanguageGeneratorItem(generatorItem);
            }

            public void extensionRemoved(LanguageNewProjectWizard extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ProjectTypeStep.this.myProjectTypeList.removeLanguageGeneratorItem(extension.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/projectWizard/ProjectTypeStep$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, context.getDisposable());
        LanguageGeneratorNewProjectWizard.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<LanguageGeneratorNewProjectWizard>(){

            public void extensionAdded(LanguageGeneratorNewProjectWizard extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    5.$$$reportNull$$$0(0);
                }
                BaseLanguageGeneratorNewProjectWizard generator = new BaseLanguageGeneratorNewProjectWizard(context, extension);
                LanguageGeneratorItem generatorItem = new LanguageGeneratorItem((GeneratorNewProjectWizard)generator);
                ProjectTypeStep.this.myProjectTypeList.addLanguageGeneratorItem(generatorItem);
            }

            public void extensionRemoved(LanguageGeneratorNewProjectWizard extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    5.$$$reportNull$$$0(1);
                }
                ProjectTypeStep.this.myProjectTypeList.removeLanguageGeneratorItem(extension.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/ide/projectWizard/ProjectTypeStep$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, context.getDisposable());
    }

    @NotNull
    private List<UserTemplateGroupItem> fillUserTemplateMap(@NotNull WizardContext context) {
        if (context == null) {
            ProjectTypeStep.$$$reportNull$$$0(7);
        }
        if (!context.isCreatingNewProject()) {
            List<UserTemplateGroupItem> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectTypeStep.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<UserTemplateGroupItem> templateItems = new ArrayList<UserTemplateGroupItem>();
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined", context);
        for (ProjectTemplate template : templates) {
            if (!(template instanceof ArchivedProjectTemplate)) continue;
            ArchivedProjectTemplate archivedTemplate = (ArchivedProjectTemplate)template;
            templateItems.add(new UserTemplateGroupItem(archivedTemplate));
        }
        for (UserTemplateGroupItem templateItem : templateItems) {
            this.myTemplatesMap.put((Object)templateItem.getGroup(), new ArrayList());
        }
        ArrayList<UserTemplateGroupItem> arrayList = templateItems;
        if (arrayList == null) {
            ProjectTypeStep.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private void projectTypeChanged(@NotNull TemplatesGroup group) {
        if (group == null) {
            ProjectTypeStep.$$$reportNull$$$0(10);
        }
        ModuleBuilder groupModuleBuilder = group.getModuleBuilder();
        this.mySettingsStep = null;
        this.myHeaderPanel.removeAll();
        if (groupModuleBuilder != null && groupModuleBuilder.getModuleType() != null) {
            this.mySettingsStep = groupModuleBuilder.modifyProjectTypeStep((SettingsStep)this);
        }
        if (groupModuleBuilder == null) {
            this.showTemplates(group);
        } else if (!this.showCustomOptions(groupModuleBuilder)) {
            this.showFrameworks(group, groupModuleBuilder);
        }
        this.myHeaderPanel.setVisible(this.myHeaderPanel.getComponentCount() > 0);
        List labels = ContainerUtil.filter((Collection)UIUtil.findComponentsOfType((JComponent)this.myHeaderPanel, JLabel.class), label -> label.isVisible() && label.getLabelFor() != null);
        int width = 0;
        for (JLabel label2 : labels) {
            int width1 = label2.getPreferredSize().width;
            width = Math.max(width, width1);
        }
        for (JLabel label2 : labels) {
            label2.setPreferredSize(new Dimension(width, label2.getPreferredSize().height));
        }
        this.myHeaderPanel.revalidate();
        this.myHeaderPanel.repaint();
        this.updateSelection();
    }

    private void showCard(String card) {
        ((CardLayout)this.myOptionsPanel.getLayout()).show(this.myOptionsPanel, card);
        this.myCurrentCard = card;
    }

    private void showTemplates(TemplatesGroup group) {
        this.setTemplatesList(group);
        this.showCard(TEMPLATES_CARD);
    }

    private void setTemplatesList(@NotNull TemplatesGroup group) {
        if (group == null) {
            ProjectTypeStep.$$$reportNull$$$0(11);
        }
        ArrayList<BuilderBasedTemplate> list2 = new ArrayList<BuilderBasedTemplate>(this.myTemplatesMap.get((Object)group));
        ModuleBuilder moduleBuilder = group.getModuleBuilder();
        if (moduleBuilder != null && !(moduleBuilder instanceof TemplateModuleBuilder)) {
            list2.add(0, new BuilderBasedTemplate(moduleBuilder));
        }
        this.myTemplatesList.setTemplates(list2, false);
    }

    private boolean showCustomOptions(@NotNull ModuleBuilder builder) {
        String card;
        ModuleWizardStep step;
        if (builder == null) {
            ProjectTypeStep.$$$reportNull$$$0(12);
        }
        if ((step = this.myCustomSteps.get(card = builder.getBuilderId())) == null) {
            step = builder.getCustomOptionsStep(this.myContext, (Disposable)this);
            if (step != null) {
                this.initStepListener(List.of(step));
            }
            if (builder instanceof TemplateModuleBuilder) {
                step = new ProjectSettingsStep(this.myContext);
                this.myContext.setProjectBuilder((ProjectBuilder)builder);
                NewProjectWizardCollector.logCustomTemplateSelected((WizardContext)this.myContext);
            }
            if (step == null) {
                return false;
            }
            this.myContext.setProjectBuilder((ProjectBuilder)builder);
            step.updateStep();
            JComponent component = step.getComponent();
            if (!(builder instanceof PromoModuleBuilder)) {
                if (component instanceof DialogPanel) {
                    DialogPanel dialogPanel = (DialogPanel)component;
                    dialogPanel.withPreferredWidth(Math.max(400, component.getMinimumSize().width));
                }
                component = new JBScrollPane((Component)component);
                component.setBorder((Border)JBUI.Borders.empty());
            }
            this.myOptionsPanel.add((Component)component, card);
            this.myCustomSteps.put(card, step);
        }
        try {
            step._init();
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        this.myContext.setScreen(1);
        this.showCard(card);
        return true;
    }

    private void showFrameworks(@NotNull TemplatesGroup group, @NotNull ModuleBuilder moduleBuilder) {
        if (group == null) {
            ProjectTypeStep.$$$reportNull$$$0(13);
        }
        if (moduleBuilder == null) {
            ProjectTypeStep.$$$reportNull$$$0(14);
        }
        ProjectCategory category = group.getProjectCategory();
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(moduleBuilder);
        if (category != null) {
            List filtered = ContainerUtil.filter(providers, provider -> ProjectTypeStep.matchFramework(category, provider));
            Map map = ContainerUtil.newMapFromValues(providers.iterator(), o -> o.getId());
            HashSet<FrameworkSupportInModuleProvider> set = new HashSet<FrameworkSupportInModuleProvider>(filtered);
            for (FrameworkSupportInModuleProvider provider2 : filtered) {
                for (FrameworkSupportInModuleProvider.FrameworkDependency depId : provider2.getDependenciesFrameworkIds()) {
                    FrameworkSupportInModuleProvider dependency = (FrameworkSupportInModuleProvider)map.get(depId.getFrameworkId());
                    if (dependency == null) {
                        if (depId.isOptional()) continue;
                        LOG.error("Cannot find provider '" + depId.getFrameworkId() + "' which is required for '" + provider2.getId() + "'");
                        continue;
                    }
                    set.add(dependency);
                }
            }
            this.myFrameworksPanel.setProviders(new ArrayList(set), Set.of(category.getAssociatedFrameworkIds()), Set.of(category.getPreselectedFrameworkIds()));
        } else {
            this.myFrameworksPanel.setProviders(providers);
        }
        moduleBuilder.addModuleConfigurationUpdater(this.myConfigurationUpdater);
        this.showCard(FRAMEWORKS_CARD);
    }

    @Nullable
    public ModuleWizardStep getCustomStep() {
        return this.myCustomSteps.get(this.myCurrentCard);
    }

    @Nullable
    private ProjectTemplate getSelectedTemplate() {
        return TEMPLATES_CARD.equals(this.myCurrentCard) ? this.myTemplatesList.getSelectedTemplate() : null;
    }

    @Nullable
    private ModuleBuilder getSelectedBuilder() {
        ProjectTemplate template = this.getSelectedTemplate();
        if (template != null) {
            return this.myBuilders.get(template);
        }
        TemplatesGroup group = this.myProjectTypeList.getSelectedTemplateGroup();
        if (group == null) {
            return null;
        }
        return group.getModuleBuilder();
    }

    public void onStepLeaving() {
        ModuleWizardStep moduleWizardStep = this.myCustomSteps.get(this.myCurrentCard);
        if (moduleWizardStep instanceof ModuleWizardStep) {
            ModuleWizardStep wizardStep = moduleWizardStep;
            wizardStep.onStepLeaving();
        }
    }

    public void onWizardFinished() throws CommitStepException {
        boolean ok;
        if (this.isFrameworksMode() && !(ok = this.myFrameworksPanel.downloadLibraries(this.myWizard.getContentComponent()))) {
            throw new CommitStepException(null);
        }
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public void updateDataModel() {
        ModuleWizardStep step;
        ModuleBuilder builder = this.getSelectedBuilder();
        if (builder != null) {
            Collection<ModuleWizardStep> steps = this.myWizard.getSequence().addSteps((AbstractModuleBuilder)builder, this.myContext, this.myModulesProvider);
            this.initStepListener(steps);
        }
        if ((step = this.getCustomStep()) != null) {
            step.updateDataModel();
        }
        if (this.mySettingsStep != null) {
            this.mySettingsStep.updateDataModel();
        }
    }

    public boolean validate() throws ConfigurationException {
        ModuleWizardStep wizardStep;
        if (this.mySettingsStep != null && !this.mySettingsStep.validate()) {
            return false;
        }
        ModuleWizardStep step = this.getCustomStep();
        if (step != null && !step.validate()) {
            return false;
        }
        if (this.isFrameworksMode() && !this.myFrameworksPanel.validate()) {
            return false;
        }
        ModuleWizardStep moduleWizardStep = this.myCustomSteps.get(this.myCurrentCard);
        if (moduleWizardStep instanceof ModuleWizardStep && !(wizardStep = moduleWizardStep).validate()) {
            return false;
        }
        return super.validate();
    }

    public JComponent getPreferredFocusedComponent() {
        ModuleWizardStep step = this.getCustomStep();
        JComponent component = (JComponent)ObjectUtils.doIfNotNull((Object)step, it -> it.getPreferredFocusedComponent());
        return (JComponent)ObjectUtils.chooseNotNull((Object)component, (Object)this.myProjectTypeList.getComponent());
    }

    public void dispose() {
        this.mySettingsStep = null;
        this.myTemplatesMap.clear();
        this.myBuilders.clear();
        this.myCustomSteps.clear();
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    @NotNull
    private MultiMap<String, ProjectTemplate> loadLocalTemplates() {
        MultiMap map = MultiMap.createConcurrent();
        TEMPLATE_EP.processWithPluginDescriptor((ep, pluginDescriptor) -> {
            ClassLoader classLoader = pluginDescriptor.getClassLoader();
            URL url = classLoader.getResource(StringUtil.trimStart((String)ep.templatePath, (String)"/"));
            if (url == null) {
                LOG.error((Throwable)new PluginException("Can't find resource for project template: " + ep.templatePath, pluginDescriptor.getPluginId()));
                return Unit.INSTANCE;
            }
            try {
                LocalArchivedTemplate template = new LocalArchivedTemplate(url, classLoader);
                if (ep.category) {
                    TemplateBasedCategory category = new TemplateBasedCategory((ArchivedProjectTemplate)template, ep.projectType);
                    this.myTemplatesMap.putValue((Object)new TemplatesGroup(category), (Object)template);
                } else {
                    map.putValue((Object)ep.projectType, (Object)template);
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)new PluginException("Error loading template from URL: " + ep.templatePath, (Throwable)e, pluginDescriptor.getPluginId()));
            }
            return Unit.INSTANCE;
        });
        MultiMap multiMap = map;
        if (multiMap == null) {
            ProjectTypeStep.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    private void updateSelection() {
        ProjectTemplate template = this.getSelectedTemplate();
        if (template != null) {
            this.myContext.setProjectTemplate(template);
        }
        ModuleBuilder builder = this.getSelectedBuilder();
        LOG.debug("builder=" + String.valueOf(builder) + "; template=" + String.valueOf(template) + "; group=" + String.valueOf(this.myProjectTypeList.getSelectedTemplateGroup()));
        this.myContext.setProjectBuilder((ProjectBuilder)builder);
        if (builder != null) {
            StepSequence sequence = this.myWizard.getSequence();
            sequence.setType(builder.getBuilderId());
            sequence.setIgnoredSteps(builder.getIgnoredSteps());
        }
        this.myWizard.setDelegate(builder instanceof WizardDelegate ? (WizardDelegate)builder : null);
        this.myWizard.updateWizardButtons();
        NewProjectWizardCollector.logGeneratorSelected((WizardContext)this.myContext);
    }

    @TestOnly
    public String availableTemplateGroupsToString() {
        return this.myProjectTypeList.getAvailableTemplateGroups();
    }

    @TestOnly
    public boolean setSelectedTemplate(@NotNull String groupName, @Nullable String name) {
        if (groupName == null) {
            ProjectTypeStep.$$$reportNull$$$0(16);
        }
        this.myProjectTypeList.setSelectedTemplateGroup(groupName);
        TemplatesGroup selectedGroup = this.myProjectTypeList.getSelectedTemplateGroup();
        if (selectedGroup == null || !groupName.equals(selectedGroup.getName())) {
            return false;
        }
        if (name != null) {
            this.setTemplatesList(selectedGroup);
            return this.myTemplatesList.setSelectedTemplate(name);
        }
        return true;
    }

    @TestOnly
    public static void resetGroupForTests() {
        ProjectTypeListKt.resetStoredSelectionForTests();
    }

    public WizardContext getContext() {
        return this.myContext;
    }

    public void addSettingsField(@NlsContexts.Label @NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            ProjectTypeStep.$$$reportNull$$$0(17);
        }
        if (field == null) {
            ProjectTypeStep.$$$reportNull$$$0(18);
        }
        ProjectSettingsStep.addField(label, field, this.myHeaderPanel);
    }

    public void addSettingsComponent(@NotNull JComponent component) {
        if (component == null) {
            ProjectTypeStep.$$$reportNull$$$0(19);
        }
    }

    public void addExpertPanel(@NotNull JComponent panel2) {
        if (panel2 == null) {
            ProjectTypeStep.$$$reportNull$$$0(20);
        }
    }

    public void addExpertField(@NlsContexts.Label @NotNull String label, @NotNull JComponent field) {
        if (label == null) {
            ProjectTypeStep.$$$reportNull$$$0(21);
        }
        if (field == null) {
            ProjectTypeStep.$$$reportNull$$$0(22);
        }
    }

    public String getHelpId() {
        if (this.getCustomStep() != null && this.getCustomStep().getHelpId() != null) {
            return this.getCustomStep().getHelpId();
        }
        return this.myContext.isCreatingNewProject() ? "Project_Category_and_Options" : "Module_Category_and_Options";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 6, 7, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectWizard/ProjectTypeStep";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuilder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptyStatusPresenter";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectWizard/ProjectTypeStep";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fillGroupTemplateMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "fillLanguageGeneratorTemplateMap";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "fillUserTemplateMap";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLocalTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillGroupTemplateMap";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fillLanguageGeneratorTemplateMap";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installLanguageGeneratorWatcher";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillUserTemplateMap";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "projectTypeChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setTemplatesList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showCustomOptions";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showFrameworks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedTemplate";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsField";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addSettingsComponent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addExpertPanel";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addExpertField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 6, 7, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        ProjectTemplateList projectTemplateList;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySettingsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null));
        this.myHeaderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        jPanel5.add((Component)jPanel4, "North");
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myOptionsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new CardLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel5.add((Component)jPanel3, "Center");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel7, TEMPLATES_CARD);
        this.myTemplatesList = projectTemplateList = new ProjectTemplateList();
        JComponent jComponent = projectTemplateList.$$$getRootComponent$$$();
        jPanel7.add((Component)jComponent, "Center");
        this.myFrameworksPanelPlaceholder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, FRAMEWORKS_CARD);
        this.myFrameworksLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/JavaUiBundle", ProjectTypeStep.class).getString("label.additional.libraries.and.frameworks"));
        jPanel2.add((Component)jBLabel, "North");
        this.myProjectTypePanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

