/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.DynamicBundle;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionProcessor;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.ui.DetectedFrameworksComponent;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.FrameworkDetectionInWizardContext;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkDetectionStep
extends AbstractStepWithProgress<List<? extends DetectedFrameworkDescription>>
implements ProjectFromSourcesBuilderImpl.ProjectConfigurationUpdater {
    private final Icon myIcon;
    private List<File> myLastRoots;
    private final DetectedFrameworksComponent myDetectedFrameworksComponent;
    private JPanel myMainPanel;
    private JPanel myFrameworksPanel;
    private JLabel myFrameworksDetectedLabel;
    private final FrameworkDetectionContext myContext;

    protected FrameworkDetectionStep(Icon icon, final ProjectFromSourcesBuilder builder) {
        super(JavaUiBundle.message("message.text.stop.searching.for.frameworks", ApplicationNamesInfo.getInstance().getProductName()));
        this.myIcon = icon;
        this.$$$setupUI$$$();
        this.myContext = new FrameworkDetectionInWizardContext(){

            @Override
            protected List<ModuleDescriptor> getModuleDescriptors() {
                return FrameworkDetectionStep.this.getModuleDescriptors();
            }

            @Override
            protected String getContentPath() {
                return builder.getBaseProjectPath();
            }
        };
        this.myDetectedFrameworksComponent = new DetectedFrameworksComponent(this.myContext);
    }

    public void updateDataModel() {
    }

    @Override
    protected boolean shouldRunProgress() {
        return this.myLastRoots == null || !Comparing.haveEqualElements(this.myLastRoots, this.getRoots());
    }

    @Override
    protected String getProgressText() {
        return JavaUiBundle.message("progress.text.searching.frameworks", new Object[0]);
    }

    @Override
    protected JComponent createResultsPanel() {
        JComponent mainPanel = this.myDetectedFrameworksComponent.getMainPanel();
        this.myFrameworksPanel.add((Component)mainPanel, "Center");
        return this.myMainPanel;
    }

    @Override
    protected List<? extends DetectedFrameworkDescription> calculate() {
        this.myLastRoots = this.getRoots();
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        ArrayList<File> roots = new ArrayList<File>();
        for (ModuleDescriptor moduleDescriptor : this.getModuleDescriptors()) {
            roots.addAll(moduleDescriptor.getContentRoots());
        }
        FrameworkDetectionProcessor processor = new FrameworkDetectionProcessor(progressIndicator, this.myContext);
        return processor.processRoots(roots);
    }

    public abstract List<ModuleDescriptor> getModuleDescriptors();

    private List<File> getRoots() {
        ArrayList<File> roots = new ArrayList<File>();
        for (ModuleDescriptor moduleDescriptor : this.getModuleDescriptors()) {
            roots.addAll(moduleDescriptor.getContentRoots());
        }
        return roots;
    }

    @Override
    protected void onFinished(@Nullable List<? extends DetectedFrameworkDescription> result, boolean canceled) {
        List frameworks = ContainerUtil.notNullize(result);
        this.myDetectedFrameworksComponent.getTree().rebuildTree(frameworks);
        if (frameworks.isEmpty()) {
            this.myFrameworksDetectedLabel.setText(JavaUiBundle.message("label.text.no.frameworks.detected", new Object[0]));
        } else {
            this.myFrameworksDetectedLabel.setText(JavaUiBundle.message("label.text.the.following.frameworks.are.detected", new Object[0]));
        }
        this.myFrameworksPanel.setVisible(!frameworks.isEmpty());
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public static boolean isEnabled() {
        return FrameworkDetector.EP_NAME.hasAnyExtensions();
    }

    @NonNls
    public String getHelpId() {
        return "reference.dialogs.new.project.fromCode.facets";
    }

    @Override
    public void updateProject(@NotNull Project project2, @NotNull ModifiableModelsProvider modelsProvider, @NotNull ModulesProvider modulesProvider) {
        if (project2 == null) {
            FrameworkDetectionStep.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            FrameworkDetectionStep.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            FrameworkDetectionStep.$$$reportNull$$$0(2);
        }
        FrameworkDetectionUtil.setupFrameworks((List)this.myDetectedFrameworksComponent.getSelectedFrameworks(), (ModifiableModelsProvider)modelsProvider, (ModulesProvider)modulesProvider);
        this.myDetectedFrameworksComponent.processUncheckedNodes(DetectionExcludesConfiguration.getInstance((Project)project2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "modelsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "modulesProvider";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/importProject/FrameworkDetectionStep";
        objectArray[2] = "updateProject";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 5));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null, 0, 0, null, null));
        this.myFrameworksDetectedLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaUiBundle", FrameworkDetectionStep.class).getString("label.text.the.following.frameworks.are.detected"));
        jPanel2.add((Component)jLabel, "North");
        this.myFrameworksPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "Center");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

