/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.framework.FrameworkVersion;
import com.intellij.framework.PresentableVersion;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ui.FormBuilder;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class FrameworkVersionComponent {
    private final JPanel myMainPanel;
    private final FrameworkSupportModelBase myModel;
    private final List<? extends FrameworkVersion> myAllVersions;
    private final JPanel myVersionsPanel;
    private final ComboBox<FrameworkVersion> myVersionsBox;
    private final String myFrameworkOrGroupId;

    public FrameworkVersionComponent(final FrameworkSupportModelBase model, final String frameworkOrGroupId, List<? extends FrameworkVersion> versions_, @NlsContexts.Label String labelText) {
        this.myModel = model;
        this.myAllVersions = versions_;
        this.myMainPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 3, true, false));
        this.myFrameworkOrGroupId = frameworkOrGroupId;
        this.myVersionsBox = new ComboBox();
        this.myVersionsBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", PresentableVersion::getPresentableName));
        this.myVersionsBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameworkVersion selectedVersion = FrameworkVersionComponent.this.getSelectedVersion();
                if (selectedVersion != null) {
                    model.setSelectedVersion(frameworkOrGroupId, selectedVersion);
                }
            }
        });
        this.myVersionsPanel = FormBuilder.createFormBuilder().setHorizontalGap(5).addLabeledComponent(labelText, this.myVersionsBox).getPanel();
        this.myMainPanel.add(this.myVersionsPanel);
        this.updateVersionsList();
    }

    private FrameworkVersion getSelectedVersion() {
        return (FrameworkVersion)this.myVersionsBox.getSelectedItem();
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void updateVersionsList() {
        FrameworkVersion oldSelection = this.getSelectedVersion();
        List<FrameworkVersion> versions = this.computeAvailableVersions();
        this.myVersionsBox.removeAllItems();
        for (FrameworkVersion version : versions) {
            this.myVersionsBox.addItem((Object)version);
        }
        this.myVersionsPanel.setVisible(!versions.isEmpty());
        if (!versions.isEmpty()) {
            FrameworkVersion toSelect = oldSelection != null && versions.contains(oldSelection) ? oldSelection : versions.getLast();
            this.myVersionsBox.setSelectedItem((Object)toSelect);
            this.myModel.setSelectedVersion(this.myFrameworkOrGroupId, toSelect);
        }
    }

    private List<FrameworkVersion> computeAvailableVersions() {
        ArrayList<FrameworkVersion> versions = new ArrayList<FrameworkVersion>();
        for (FrameworkVersion frameworkVersion : this.myAllVersions) {
            if (!frameworkVersion.getAvailabilityCondition().isAvailableFor((FrameworkSupportModel)this.myModel)) continue;
            versions.add(frameworkVersion);
        }
        return versions;
    }
}

