/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.importSources.DetectedContentRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFromSourcesBuilderImpl
extends ProjectImportBuilder
implements ProjectFromSourcesBuilder {
    private static final Logger LOG = Logger.getInstance(ProjectFromSourcesBuilderImpl.class);
    private String myBaseProjectPath;
    private final List<ProjectConfigurationUpdater> myUpdaters = new ArrayList<ProjectConfigurationUpdater>();
    private final Map<ProjectStructureDetector, ProjectDescriptor> myProjectDescriptors = new LinkedHashMap<ProjectStructureDetector, ProjectDescriptor>();
    private MultiMap<ProjectStructureDetector, DetectedProjectRoot> myRoots = MultiMap.empty();
    private final WizardContext myContext;
    private final ModulesProvider myModulesProvider;
    private Set<String> myModuleNames;
    private Set<String> myProjectLibrariesNames;

    public ProjectFromSourcesBuilderImpl(WizardContext context, ModulesProvider modulesProvider) {
        this.myContext = context;
        this.myModulesProvider = modulesProvider;
        for (ProjectStructureDetector detector : (ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()) {
            this.myProjectDescriptors.put(detector, new ProjectDescriptor());
        }
    }

    @Override
    @NotNull
    public Set<String> getExistingModuleNames() {
        if (this.myModuleNames == null) {
            this.myModuleNames = new HashSet<String>();
            for (Module module : this.myModulesProvider.getModules()) {
                this.myModuleNames.add(module.getName());
            }
        }
        Set<String> set = this.myModuleNames;
        if (set == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Set<String> getExistingProjectLibraryNames() {
        if (this.myProjectLibrariesNames == null) {
            this.myProjectLibrariesNames = new HashSet<String>();
            LibrariesContainer container = LibrariesContainerFactory.createContainer(this.myContext, this.myModulesProvider);
            for (Library library : container.getLibraries(LibrariesContainer.LibraryLevel.PROJECT)) {
                this.myProjectLibrariesNames.add(library.getName());
            }
        }
        Set<String> set = this.myProjectLibrariesNames;
        if (set == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Override
    @NotNull
    public WizardContext getContext() {
        WizardContext wizardContext = this.myContext;
        if (wizardContext == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(2);
        }
        return wizardContext;
    }

    public void setBaseProjectPath(String contentRootPath) {
        this.myBaseProjectPath = contentRootPath;
    }

    @Override
    public String getBaseProjectPath() {
        return this.myBaseProjectPath;
    }

    public void setupProjectStructure(MultiMap<ProjectStructureDetector, DetectedProjectRoot> roots) {
        this.myRoots = roots;
        for (ProjectStructureDetector detector : roots.keySet()) {
            detector.setupProjectStructure(roots.get((Object)detector), this.getProjectDescriptor(detector), this);
        }
    }

    @Override
    @NotNull
    public Collection<DetectedProjectRoot> getProjectRoots(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(3);
        }
        Collection collection = this.myRoots.get((Object)detector);
        if (collection == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getName() {
        String string = JavaUiBundle.message("existing.sources", new Object[0]);
        if (string == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Folder;
    }

    public boolean isMarked(Object element) {
        return false;
    }

    @Override
    public void setOpenProjectSettingsAfter(boolean on) {
    }

    @Override
    public void setFileToImport(@NotNull String path) {
        if (path == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(6);
        }
        this.setBaseProjectPath(path);
    }

    @Override
    @NotNull
    public List<Module> commit(@NotNull Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider) {
        boolean commitModels;
        ModulesProvider updatedModulesProvider;
        ModifiableModuleModel moduleModel;
        if (project2 == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(7);
        }
        if (model != null) {
            moduleModel = model;
            updatedModulesProvider = modulesProvider;
            commitModels = false;
        } else {
            moduleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
            updatedModulesProvider = new DefaultModulesProvider(project2);
            commitModels = true;
        }
        List<Module> list2 = new ProjectFromSourcesBuilderHelper(project2, moduleModel, updatedModulesProvider, commitModels, this.myUpdaters, this.getSelectedDescriptors()).commit();
        if (list2 == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Module> commit(Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        List<Module> list2 = this.commit(project2, model, modulesProvider);
        if (list2 == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(9);
        }
        return list2;
    }

    public Collection<ProjectDescriptor> getSelectedDescriptors() {
        return this.myProjectDescriptors.values();
    }

    public void addConfigurationUpdater(ProjectConfigurationUpdater updater) {
        this.myUpdaters.add(updater);
    }

    @Override
    public boolean hasRootsFromOtherDetectors(ProjectStructureDetector thisDetector) {
        for (ProjectStructureDetector projectStructureDetector : ProjectStructureDetector.EP_NAME.getExtensionList()) {
            if (projectStructureDetector == thisDetector || this.getProjectRoots(projectStructureDetector).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setupModulesByContentRoots(ProjectDescriptor projectDescriptor, Collection<? extends DetectedProjectRoot> roots) {
        if (projectDescriptor.getModules().isEmpty()) {
            ArrayList<ModuleDescriptor> modules = new ArrayList<ModuleDescriptor>();
            for (DetectedProjectRoot detectedProjectRoot : roots) {
                if (!(detectedProjectRoot instanceof DetectedContentRoot)) continue;
                modules.add(new ModuleDescriptor(detectedProjectRoot.getDirectory(), ((DetectedContentRoot)detectedProjectRoot).getModuleType(), Collections.emptyList()));
            }
            projectDescriptor.setModules(modules);
        }
    }

    public static String getPackagePrefix(DetectedSourceRoot srcRoot) {
        return srcRoot.getPackagePrefix();
    }

    @Override
    @NotNull
    public ProjectDescriptor getProjectDescriptor(@NotNull ProjectStructureDetector detector) {
        if (detector == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(10);
        }
        ProjectDescriptor projectDescriptor = this.myProjectDescriptors.get(detector);
        if (projectDescriptor == null) {
            ProjectFromSourcesBuilderImpl.$$$reportNull$$$0(11);
        }
        return projectDescriptor;
    }

    static boolean isTestRootName(String name) {
        return "test".equalsIgnoreCase(name) || "tests".equalsIgnoreCase(name) || "testSource".equalsIgnoreCase(name) || "testSources".equalsIgnoreCase(name) || "testSrc".equalsIgnoreCase(name) || "tst".equalsIgnoreCase(name);
    }

    public boolean isSuitableSdkType(SdkTypeId sdkTypeId) {
        for (ProjectDescriptor projectDescriptor : this.getSelectedDescriptors()) {
            for (ModuleDescriptor moduleDescriptor : projectDescriptor.getModules()) {
                try {
                    ModuleType<?> moduleType = ProjectFromSourcesBuilderImpl.getModuleType(moduleDescriptor);
                    if (moduleType == null || moduleType.createModuleBuilder().isSuitableSdkType(sdkTypeId)) continue;
                    return false;
                }
                catch (Exception exception) {
                }
            }
        }
        return true;
    }

    @Nullable
    private static ModuleType<?> getModuleType(ModuleDescriptor moduleDescriptor) throws InvalidDataException, JDOMException, IOException {
        if (moduleDescriptor.isReuseExistingElement()) {
            Element rootElement;
            String type;
            File file = new File(moduleDescriptor.computeModuleFilePath());
            if (file.exists() && (type = (rootElement = JDOMUtil.load((File)file)).getAttributeValue("type")) != null) {
                return ModuleTypeManager.getInstance().findByID(type);
            }
            return null;
        }
        return moduleDescriptor.getModuleType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 6, 7, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingModuleNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingProjectLibraryNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/impl/ProjectFromSourcesBuilderImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoots";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setFileToImport";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 6, 7, 10 -> new IllegalArgumentException(string);
        };
    }

    public static interface ProjectConfigurationUpdater {
        public void updateProject(@NotNull Project var1, @NotNull ModifiableModelsProvider var2, @NotNull ModulesProvider var3);
    }
}

