/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.JavaCompilerBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ClasspathFormatUI;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    private ClasspathPanelImpl myPanel;
    private ClasspathFormatUI myClasspathFormatUI;
    private boolean myDisposed;

    public ClasspathEditor(ModuleConfigurationState state) {
        super(state);
        Disposable disposable = Disposer.newDisposable();
        state.getProject().getMessageBus().connect(disposable).subscribe(TOPIC, (Object)this);
        this.registerDisposable(disposable);
    }

    public boolean isModified() {
        return super.isModified() || this.myClasspathFormatUI != null && this.myClasspathFormatUI.isModified();
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return ClasspathEditor.getName();
    }

    public void saveData() {
        this.myPanel.stopEditing();
    }

    public void apply() throws ConfigurationException {
        if (this.myClasspathFormatUI != null) {
            this.myClasspathFormatUI.apply();
        }
    }

    public void canApply() throws ConfigurationException {
        super.canApply();
        if (this.myClasspathFormatUI != null) {
            this.myClasspathFormatUI.canApply();
        }
    }

    public JComponent createComponentImpl() {
        this.myPanel = new ClasspathPanelImpl(this.getState());
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder((Border)JBUI.Borders.empty((int)0, (int)10));
        panel2.add((Component)this.myPanel, "Center");
        ModuleJdkConfigurable jdkConfigurable = new ModuleJdkConfigurable(this, ((ModulesConfigurator)this.getState().getModulesProvider()).getProjectStructureConfigurable()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getModifiableModel();
            }
        };
        panel2.add((Component)jdkConfigurable.createComponent(), "North");
        jdkConfigurable.reset();
        this.registerDisposable(jdkConfigurable);
        ClasspathStorageProvider[] providers = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        if (providers.length > 0) {
            this.myClasspathFormatUI = new ClasspathFormatUI(providers, this.getState());
            panel2.add((Component)this.myClasspathFormatUI.getPanel(), "South");
        }
        return panel2;
    }

    private ModifiableRootModel getModifiableModel() {
        return this.getState().getModifiableRootModel();
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathEditor.$$$reportNull$$$0(0);
        }
        this.myPanel.selectOrderEntry(entry);
    }

    public void moduleStateChanged() {
        if (this.myPanel != null) {
            this.myPanel.initFromModel();
        }
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            ClasspathEditor.$$$reportNull$$$0(1);
        }
        if (this.myPanel != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myDisposed) {
                    this.myPanel.rootsChanged();
                }
            });
        }
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        this.myDisposed = true;
    }

    public void setSdk(@Nullable Sdk newJDK) {
        ModifiableRootModel model = this.getModel();
        if (newJDK != null) {
            model.setSdk(newJDK);
        } else {
            model.inheritSdk();
        }
        if (this.myPanel != null) {
            this.myPanel.forceInitFromModel();
        }
    }

    @NlsContexts.ConfigurableName
    public static String getName() {
        return JavaCompilerBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ClasspathEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectOrderEntry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

