/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.pom.java.AcceptedLanguageLevelsSettings;
import com.intellij.pom.java.JavaRelease;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.dsl.listCellRenderer.LcrRow;
import com.intellij.ui.dsl.listCellRenderer.LcrSeparator;
import com.intellij.ui.dsl.listCellRenderer.LcrTextInitParams;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B.\b\u0007\u0012\r\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0015\u001a\u00020\r2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\tJ\u001a\u0010\u0019\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\tH\u0002J\u0012\u0010\u001e\u001a\u00020\r2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010 \u001a\u0004\u0018\u00010\u00022\b\u0010!\u001a\u0004\u0018\u00010\u0002H\u0002R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0014R\u0011\u0010\u001c\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/LanguageLevelCombo;", "Lcom/intellij/openapi/ui/ComboBox;", "", "defaultItem", "", "Lorg/jetbrains/annotations/Nls;", "levelFilter", "Lkotlin/Function1;", "Lcom/intellij/pom/java/LanguageLevel;", "", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "checkAcceptedLevel", "", "selectedLevel", "reset", "project", "Lcom/intellij/openapi/project/Project;", "defaultLevel", "getDefaultLevel", "()Lcom/intellij/pom/java/LanguageLevel;", "sdkUpdated", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "isDefaultProject", "updateDefaultLevel", "newLevel", "getSelectedLevel", "isDefault", "()Z", "setSelectedItem", "anObject", "getEntryForLevel", "levelToSelect", "Companion", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nLanguageLevelCombo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LanguageLevelCombo.kt\ncom/intellij/openapi/roots/ui/configuration/LanguageLevelCombo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1080#2:166\n777#2:167\n873#2,2:168\n1915#2,2:170\n777#2:172\n873#2,2:173\n777#2:177\n873#2,2:178\n37#3,2:175\n1#4:180\n*S KotlinDebug\n*F\n+ 1 LanguageLevelCombo.kt\ncom/intellij/openapi/roots/ui/configuration/LanguageLevelCombo\n*L\n39#1:166\n40#1:167\n40#1:168,2\n41#1:170,2\n64#1:172\n64#1:173,2\n35#1:177\n35#1:178,2\n67#1:175,2\n*E\n"})
public abstract class LanguageLevelCombo
extends ComboBox<Object> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final LanguageLevel[] LTS;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public LanguageLevelCombo(@Nullable String defaultItem, @NotNull Function1<? super LanguageLevel, Boolean> levelFilter) {
        Object $this$_init__u24lambda_u244;
        List $this$_init__u24lambda_u243;
        Object level4;
        List $this$_init__u24lambda_u242;
        void $this$forEach$iv;
        Object element$iv$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$sortedByDescending$iv;
        List list2;
        Intrinsics.checkNotNullParameter(levelFilter, (String)"levelFilter");
        List items = new ArrayList();
        String string = defaultItem;
        if (string == null) {
            string = "";
        }
        items.add(string);
        LanguageLevel languageLevel = JavaRelease.getHighest();
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getHighest(...)");
        LanguageLevel highestLanguageLevel = languageLevel;
        LanguageLevel languageLevel2 = highestLanguageLevel.getPreviewLevel();
        if (languageLevel2 == null) {
            languageLevel2 = highestLanguageLevel;
        }
        LanguageLevel highestWithPreview = languageLevel2;
        List list3 = list2 = CollectionsKt.createListBuilder();
        Function1<? super LanguageLevel, Boolean> function1 = levelFilter;
        List list4 = items;
        boolean $i$a$-buildList-LanguageLevelCombo$regularItems$22 = false;
        Iterable iterable = (Iterable)LanguageLevel.getEntries();
        boolean $i$f$sortedByDescending = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                LanguageLevel it = (LanguageLevel)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.feature());
                it = (LanguageLevel)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.feature()));
            }
        });
        boolean $i$f$filter = false;
        void var12_18 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            LanguageLevel level2 = (LanguageLevel)element$iv$iv;
            boolean bl = false;
            if (!(level2.compareTo((Enum)highestWithPreview) <= 0 && !level2.isUnsupported())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Object element$iv = $this$filterTo$iv$iv.next();
            LanguageLevel level3 = (LanguageLevel)element$iv;
            boolean bl = false;
            $this$_init__u24lambda_u242.add(level3);
        }
        Unit unit = Unit.INSTANCE;
        List<LanguageLevel> regularItems = LanguageLevelCombo._init_$filterAndAdd(list4, function1, CollectionsKt.build((List)list2));
        List $i$a$-buildList-LanguageLevelCombo$regularItems$22 = $this$_init__u24lambda_u242 = CollectionsKt.createListBuilder();
        function1 = levelFilter;
        list4 = items;
        boolean $i$a$-buildList-LanguageLevelCombo$experimentalItems$22 = false;
        for (Object level4 : CollectionsKt.reversed((Iterable)((Iterable)LanguageLevel.getEntries()))) {
            if (level4.compareTo((Enum)highestWithPreview) <= 0 || level4.isUnsupported()) continue;
            $this$_init__u24lambda_u243.add(level4);
        }
        unit = Unit.INSTANCE;
        List<LanguageLevel> experimentalItems = LanguageLevelCombo._init_$filterAndAdd(list4, function1, CollectionsKt.build((List)$this$_init__u24lambda_u242));
        List $i$a$-buildList-LanguageLevelCombo$experimentalItems$22 = $this$_init__u24lambda_u243 = CollectionsKt.createListBuilder();
        function1 = levelFilter;
        list4 = items;
        boolean bl = false;
        for (LanguageLevel level5 : CollectionsKt.reversed((Iterable)((Iterable)LanguageLevel.getEntries()))) {
            if (!level5.isUnsupported()) continue;
            $this$_init__u24lambda_u244.add(level5);
        }
        unit = Unit.INSTANCE;
        List<LanguageLevel> unsupportedItems = LanguageLevelCombo._init_$filterAndAdd(list4, function1, CollectionsKt.build((List)$this$_init__u24lambda_u243));
        $this$_init__u24lambda_u244 = new Pair[]{TuplesKt.to((Object)CollectionsKt.firstOrNull(regularItems), (Object)new ListSeparator(JavaUiBundle.message("language.level.combo.supported.versions", new Object[0]))), TuplesKt.to((Object)CollectionsKt.firstOrNull(experimentalItems), (Object)new ListSeparator(JavaUiBundle.message("language.level.combo.experimental.versions", new Object[0]))), TuplesKt.to((Object)CollectionsKt.firstOrNull(unsupportedItems), (Object)new ListSeparator(JavaUiBundle.message("language.level.combo.unsupported.versions", new Object[0])))};
        $this$_init__u24lambda_u244 = CollectionsKt.listOf((Object[])$this$_init__u24lambda_u244);
        $i$f$filter = false;
        level4 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            Pair it = (Pair)element$iv$iv;
            boolean bl2 = false;
            if (!(it.getFirst() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Map separatorsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        this.setSwingPopup(false);
        Collection $this$toTypedArray$iv = items;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.setModel(new DefaultComboBoxModel<Object>(thisCollection$iv.toArray(new Object[0])));
        this.renderer = BuilderKt.listCellRenderer((String)"", arg_0 -> LanguageLevelCombo._init_$lambda$6(separatorsMap, highestLanguageLevel, arg_0));
    }

    public /* synthetic */ LanguageLevelCombo(String string, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = LanguageLevelCombo::_init_$lambda$0;
        }
        this(string, (Function1<? super LanguageLevel, Boolean>)function1);
    }

    private final void checkAcceptedLevel(LanguageLevel selectedLevel) {
        if (selectedLevel == null) {
            return;
        }
        this.hidePopup();
        LanguageLevel level = AcceptedLanguageLevelsSettings.checkAccepted((Component)((Component)((Object)this)), (LanguageLevel)selectedLevel);
        if (level == null) {
            this.setSelectedItem(AcceptedLanguageLevelsSettings.getHighestAcceptedLevel());
        }
    }

    public final void reset(@NotNull Project project2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Sdk sdk = ProjectRootManagerEx.getInstanceEx((Project)project2).getProjectSdk();
        this.sdkUpdated(sdk, project2.isDefault());
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)project2);
        if (extension.isDefault()) {
            string = "default";
        } else {
            LanguageLevel languageLevel = extension.getLanguageLevel();
            string = languageLevel;
            Intrinsics.checkNotNullExpressionValue((Object)languageLevel, (String)"getLanguageLevel(...)");
        }
        this.setSelectedItem(string);
    }

    @Nullable
    protected abstract LanguageLevel getDefaultLevel();

    public final void sdkUpdated(@Nullable Sdk sdk, boolean isDefaultProject) {
        JavaSdkVersion version;
        LanguageLevel newLevel = null;
        if (sdk != null && (version = JavaSdk.getInstance().getVersion(sdk)) != null) {
            newLevel = version.getMaxLanguageLevel();
        }
        this.updateDefaultLevel(newLevel, isDefaultProject);
        if (this.isDefault()) {
            this.checkAcceptedLevel(newLevel);
        }
    }

    private final void updateDefaultLevel(LanguageLevel newLevel, boolean isDefaultProject) {
        if (newLevel == null && !isDefaultProject && this.isDefault()) {
            this.setSelectedItem(this.getDefaultLevel());
        }
        this.repaint();
    }

    @Nullable
    public final LanguageLevel getSelectedLevel() {
        Object item = this.getSelectedItem();
        return item instanceof LanguageLevel ? (LanguageLevel)item : (item instanceof String ? this.getDefaultLevel() : null);
    }

    public final boolean isDefault() {
        return this.getSelectedItem() instanceof String;
    }

    public void setSelectedItem(@Nullable Object anObject) {
        Object levelToSelect;
        Object entryForLevel;
        Object object = anObject;
        if (object == null) {
            object = "default";
        }
        if ((entryForLevel = this.getEntryForLevel(levelToSelect = object)) != null) {
            super.setSelectedItem(entryForLevel);
        }
        if (entryForLevel instanceof LanguageLevel) {
            this.checkAcceptedLevel((LanguageLevel)entryForLevel);
        }
    }

    private final Object getEntryForLevel(Object levelToSelect) {
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object entry = this.getItemAt(i);
            if (Intrinsics.areEqual((Object)levelToSelect, (Object)entry)) {
                return entry;
            }
            Object object = entry;
            if (!(object instanceof LanguageLevel ? Intrinsics.areEqual((Object)levelToSelect, (Object)entry) : object instanceof String && levelToSelect instanceof String)) continue;
            return entry;
        }
        return null;
    }

    @JvmOverloads
    public LanguageLevelCombo(@Nullable String defaultItem) {
        this(defaultItem, null, 2, null);
    }

    private static final boolean _init_$lambda$0(LanguageLevel it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit lambda$6$1$0(ListSeparator $it, LcrSeparator $this$separator) {
        Intrinsics.checkNotNullParameter((Object)$this$separator, (String)"$this$separator");
        $this$separator.setText($it.getText());
        return Unit.INSTANCE;
    }

    private static final Unit lambda$6$0(Object $value, LanguageLevel $highestLanguageLevel, LcrTextInitParams $this$text) {
        Intrinsics.checkNotNullParameter((Object)$this$text, (String)"$this$text");
        if ($value instanceof LanguageLevel && ((LanguageLevel)$value).isUnsupported()) {
            $this$text.setAttributes(SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else if ($value instanceof LanguageLevel && ArraysKt.contains((Object[])LTS, (Object)$value) && ((LanguageLevel)$value).compareTo((Enum)$highestLanguageLevel) <= 0) {
            $this$text.setAttributes(SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(1, null, null, null));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<LanguageLevel> _init_$filterAndAdd(List<Object> $this$_init__u24filterAndAdd, Function1<? super LanguageLevel, Boolean> $levelFilter, Collection<? extends LanguageLevel> levels) {
        List list2;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = levels;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)$levelFilter.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List it = list2 = (List)destination$iv$iv;
        boolean bl = false;
        $this$_init__u24filterAndAdd.addAll(it);
        return list2;
    }

    private static final Unit _init_$lambda$6(Map $separatorsMap, LanguageLevel $highestLanguageLevel, LcrRow $this$listCellRenderer) {
        block0: {
            Object value;
            Intrinsics.checkNotNullParameter((Object)$this$listCellRenderer, (String)"$this$listCellRenderer");
            Object object = value = $this$listCellRenderer.getValue();
            $this$listCellRenderer.text(object instanceof String ? (String)value : (object instanceof LanguageLevel ? ((LanguageLevel)value).getPresentableText() : ""), arg_0 -> LanguageLevelCombo.lambda$6$0(value, $highestLanguageLevel, arg_0));
            ListSeparator listSeparator = (ListSeparator)$separatorsMap.get(value);
            if (listSeparator == null) break block0;
            ListSeparator it = listSeparator;
            boolean bl = false;
            $this$listCellRenderer.separator(arg_0 -> LanguageLevelCombo.lambda$6$1$0(it, arg_0));
        }
        return Unit.INSTANCE;
    }

    static {
        LanguageLevel[] languageLevelArray = new LanguageLevel[]{LanguageLevel.JDK_25, LanguageLevel.JDK_21, LanguageLevel.JDK_17, LanguageLevel.JDK_11, LanguageLevel.JDK_1_8};
        LTS = languageLevelArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/LanguageLevelCombo$Companion;", "", "<init>", "()V", "LTS", "", "Lcom/intellij/pom/java/LanguageLevel;", "[Lcom/intellij/pom/java/LanguageLevel;", "intellij.java.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

