/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.impl.ModuleConfigurationStateImpl;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootManagerEx;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.RootConfigurationAccessor;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModificationOfImportedModelWarningComponent;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationEditorProviderEx;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.UIRootConfigurationAccessor;
import com.intellij.openapi.roots.ui.configuration.impl.ModuleConfigurationEditorProviderEp;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleEditor
implements Place.Navigator,
Disposable {
    private static final ExtensionPointName<ModuleConfigurationEditorProviderEp> EP_NAME = new ExtensionPointName("com.intellij.moduleConfigurationEditorProvider");
    public static final String SELECTED_EDITOR_NAME = "selectedEditor";
    private final Project myProject;
    private JPanel myGenericSettingsPanel;
    private ModificationOfImportedModelWarningComponent myModificationOfImportedModelWarningComponent;
    private ModifiableRootModel myModifiableRootModel;
    private final ModulesConfigurator myModulesProvider;
    private String myName;
    private final Module myModule;
    protected final List<ModuleConfigurationEditor> myEditors;
    private ModifiableRootModel myModifiableRootModelProxy;
    private final EventDispatcher<ChangeListener> myEventDispatcher;
    @NonNls
    private static final String METHOD_COMMIT = "commit";
    private boolean myEditorsInitialized;
    protected History myHistory;

    public ModuleEditor(@NotNull Project project2, @NotNull ModulesConfigurator modulesProvider, @NotNull Module module) {
        if (project2 == null) {
            ModuleEditor.$$$reportNull$$$0(0);
        }
        if (modulesProvider == null) {
            ModuleEditor.$$$reportNull$$$0(1);
        }
        if (module == null) {
            ModuleEditor.$$$reportNull$$$0(2);
        }
        this.myEditors = new ArrayList<ModuleConfigurationEditor>();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myProject = project2;
        this.myModulesProvider = modulesProvider;
        this.myModule = module;
        this.myName = module.getName();
    }

    public void init(History history) {
        this.myHistory = history;
        this.restoreSelectedEditor();
    }

    public abstract ProjectFacetsConfigurator getFacetsConfigurator();

    protected abstract JComponent createCenterPanel();

    @Nullable
    public abstract ModuleConfigurationEditor getSelectedEditor();

    public abstract void selectEditor(String var1);

    protected abstract void restoreSelectedEditor();

    @Nullable
    public abstract ModuleConfigurationEditor getEditor(@NotNull String var1);

    protected abstract void disposeCenterPanel();

    public void addChangeListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    @Nullable
    public Module getModule() {
        return this.myModulesProvider.getModule(this.myName);
    }

    public ModifiableRootModel getModifiableRootModel() {
        Module module;
        if (this.myModifiableRootModel == null && (module = this.getModule()) != null) {
            MutableEntityStorage builder = this.myModulesProvider.getWorkspaceEntityStorageBuilder();
            this.myModifiableRootModel = ModuleRootManagerEx.getInstanceEx((Module)module).getModifiableModelForMultiCommit((RootConfigurationAccessor)new UIRootConfigurationAccessor(this.myProject, builder));
        }
        return this.myModifiableRootModel;
    }

    public OrderEntry @NotNull [] getOrderEntries() {
        if (this.myModifiableRootModel == null) {
            OrderEntry[] orderEntryArray = ModuleRootManager.getInstance((Module)this.getModule()).getOrderEntries();
            if (orderEntryArray == null) {
                ModuleEditor.$$$reportNull$$$0(3);
            }
            return orderEntryArray;
        }
        OrderEntry[] orderEntryArray = this.myModifiableRootModel.getOrderEntries();
        if (orderEntryArray == null) {
            ModuleEditor.$$$reportNull$$$0(4);
        }
        return orderEntryArray;
    }

    public ModifiableRootModel getModifiableRootModelProxy() {
        ModifiableRootModel rootModel;
        if (this.myModifiableRootModelProxy == null && (rootModel = this.getModifiableRootModel()) != null) {
            this.myModifiableRootModelProxy = (ModifiableRootModel)ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), ModifiableRootModel.class, (InvocationHandler)new ModifiableRootModelInvocationHandler(rootModel));
        }
        return this.myModifiableRootModelProxy;
    }

    public ModuleRootModel getRootModel() {
        if (this.myModifiableRootModel != null) {
            return this.getModifiableRootModelProxy();
        }
        return ModuleRootManager.getInstance((Module)this.myModule);
    }

    public boolean isModified() {
        if (!this.myModule.getName().equals(this.myName)) {
            return true;
        }
        for (ModuleConfigurationEditor moduleElementsEditor : this.myEditors) {
            if (!moduleElementsEditor.isModified()) continue;
            return true;
        }
        return false;
    }

    private void createEditors(@NotNull Module module) {
        if (module == null) {
            ModuleEditor.$$$reportNull$$$0(5);
        }
        ModuleConfigurationState state = this.createModuleConfigurationState();
        for (ModuleConfigurationEditorProviderEp providerEp : EP_NAME.getExtensionList()) {
            ModuleConfigurationEditorProvider provider = providerEp.getOrCreateInstance(module);
            Object[] editors = provider.createEditors(state);
            if (editors.length > 0 && provider instanceof ModuleConfigurationEditorProviderEx && ((ModuleConfigurationEditorProviderEx)provider).isCompleteEditorSet()) {
                this.myEditors.clear();
                ContainerUtil.addAll(this.myEditors, (Object[])editors);
                break;
            }
            ContainerUtil.addAll(this.myEditors, (Object[])editors);
        }
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).addListener(this::updateImportedModelWarning);
        }
    }

    @NotNull
    public ModuleConfigurationState createModuleConfigurationState() {
        return new ModuleConfigurationStateImpl(this.myProject, this.myModulesProvider){

            public ModifiableRootModel getModifiableRootModel() {
                return ModuleEditor.this.getModifiableRootModelProxy();
            }

            public ModuleRootModel getCurrentRootModel() {
                return ModuleEditor.this.getRootModel();
            }

            public FacetsProvider getFacetsProvider() {
                return ModuleEditor.this.getFacetsConfigurator();
            }
        };
    }

    @NotNull
    private JPanel createPanel() {
        this.getModifiableRootModel();
        this.getModifiableRootModelProxy();
        this.myGenericSettingsPanel = new ModuleEditorPanel();
        Module module = this.getModule();
        if (module != null) {
            this.createEditors(module);
        }
        JComponent component = this.createCenterPanel();
        this.myGenericSettingsPanel.add((Component)component, "Center");
        this.myModificationOfImportedModelWarningComponent = new ModificationOfImportedModelWarningComponent();
        this.myGenericSettingsPanel.add((Component)this.myModificationOfImportedModelWarningComponent.getLabel(), "South");
        this.updateImportedModelWarning();
        this.myEditorsInitialized = true;
        JPanel jPanel = this.myGenericSettingsPanel;
        if (jPanel == null) {
            ModuleEditor.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    public JPanel getPanel() {
        if (this.myGenericSettingsPanel == null) {
            this.myGenericSettingsPanel = this.createPanel();
        }
        JPanel jPanel = this.myGenericSettingsPanel;
        if (jPanel == null) {
            ModuleEditor.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    public void moduleCountChanged() {
        this.updateOrderEntriesInEditors(false);
    }

    private void updateOrderEntriesInEditors(boolean forceInitEditors) {
        if (this.getModule() != null) {
            if (this.myEditorsInitialized || forceInitEditors) {
                this.getPanel();
                for (ModuleConfigurationEditor myEditor : this.myEditors) {
                    myEditor.moduleStateChanged();
                }
                this.updateImportedModelWarning();
            }
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).moduleStateChanged(this.getModifiableRootModelProxy());
        }
    }

    private void updateImportedModelWarning() {
        if (!this.myEditorsInitialized) {
            return;
        }
        ProjectModelExternalSource externalSource = ModuleRootManager.getInstance((Module)this.myModule).getExternalSource();
        if (externalSource != null && this.isModified()) {
            this.myModificationOfImportedModelWarningComponent.showWarning(JavaUiBundle.message("project.roots.module.banner.text", this.myModule.getName()), externalSource);
        } else {
            this.myModificationOfImportedModelWarningComponent.hideWarning();
        }
    }

    public void updateCompilerOutputPathChanged(String baseUrl, String moduleName) {
        if (this.myGenericSettingsPanel == null) {
            return;
        }
        for (ModuleConfigurationEditor myEditor : this.myEditors) {
            if (!(myEditor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)myEditor).moduleCompileOutputChanged(baseUrl, moduleName);
        }
    }

    public void dispose() {
        try {
            this.myEventDispatcher.getListeners().clear();
            for (ModuleConfigurationEditor myEditor : this.myEditors) {
                myEditor.disposeUIResources();
            }
            this.myEditors.clear();
            this.disposeCenterPanel();
            if (this.myModifiableRootModel != null) {
                this.myModifiableRootModel.dispose();
            }
            this.myGenericSettingsPanel = null;
        }
        finally {
            this.resetModifiableModel();
        }
    }

    public ModifiableRootModel apply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            editor.saveData();
            editor.apply();
        }
        return this.myModifiableRootModel;
    }

    void resetModifiableModel() {
        this.myModifiableRootModel = null;
        this.myModifiableRootModelProxy = null;
    }

    public void canApply() throws ConfigurationException {
        for (ModuleConfigurationEditor editor : this.myEditors) {
            if (!(editor instanceof ModuleElementsEditor)) continue;
            ((ModuleElementsEditor)editor).canApply();
        }
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ModuleEditor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static Object[] unwrapParams(Object[] params) {
        if (params == null || params.length == 0) {
            return params;
        }
        Object[] unwrappedParams = new Object[params.length];
        for (int idx = 0; idx < params.length; ++idx) {
            InvocationHandler invocationHandler;
            Object param = params[idx];
            if (param != null && Proxy.isProxyClass(param.getClass()) && (invocationHandler = Proxy.getInvocationHandler(param)) instanceof ProxyDelegateAccessor) {
                param = ((ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate();
            }
            unwrappedParams[idx] = param;
        }
        return unwrappedParams;
    }

    @Nullable
    public String getHelpTopic() {
        if (this.myEditors.isEmpty()) {
            return null;
        }
        ModuleConfigurationEditor selectedEditor = this.getSelectedEditor();
        return selectedEditor != null ? selectedEditor.getHelpTopic() : null;
    }

    public void setModuleName(@NotNull String name) {
        if (name == null) {
            ModuleEditor.$$$reportNull$$$0(9);
        }
        this.myName = name;
        this.updateImportedModelWarning();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ModuleEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditors";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setModuleName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static interface ChangeListener
    extends EventListener {
        public void moduleStateChanged(ModifiableRootModel var1);
    }

    private class ModifiableRootModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final ModifiableRootModel myDelegateModel;
        @NonNls
        private static final Set<String> myCheckedNames = Set.of("addOrderEntry", "addLibraryEntry", "addInvalidLibrary", "addModuleOrderEntry", "addInvalidModuleEntry", "removeOrderEntry", "setSdk", "inheritSdk", "inheritCompilerOutputPath", "setExcludeOutput", "replaceEntryOfType", "rearrangeOrderEntries");

        ModifiableRootModelInvocationHandler(ModifiableRootModel model) {
            if (model == null) {
                ModifiableRootModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateModel = model;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryTable) {
                    LibraryTable table = (LibraryTable)result;
                    Object object2 = ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), LibraryTable.class, (InvocationHandler)new LibraryTableInvocationHandler(table));
                    return object2;
                }
                Object object3 = result;
                return object3;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$ModifiableRootModelInvocationHandler", "<init>"));
        }
    }

    private class ModuleEditorPanel
    extends JPanel
    implements UiDataProvider {
        ModuleEditorPanel() {
            super(new BorderLayout());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ModuleEditorPanel.$$$reportNull$$$0(0);
            }
            sink.set(LangDataKeys.MODULE_CONTEXT, (Object)ModuleEditor.this.getModule());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$ModuleEditorPanel", "uiDataSnapshot"));
        }
    }

    public static interface ProxyDelegateAccessor {
        public Object getDelegate();
    }

    private class LibraryTableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable.ModifiableModel myDelegateModel;

        LibraryTableModelInvocationHandler(LibraryTable.ModifiableModel delegateModel) {
            if (delegateModel == null) {
                LibraryTableModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), LibraryEx.class, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                if (result instanceof Library) {
                    Library library = (Library)result;
                    result = ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), LibraryEx.class, (InvocationHandler)new LibraryInvocationHandler(library));
                }
                Object object2 = result;
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateModel", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryTableModelInvocationHandler", "<init>"));
        }
    }

    private class LibraryModifiableModelInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library.ModifiableModel myDelegateModel;

        LibraryModifiableModelInvocationHandler(Library.ModifiableModel delegateModel) {
            if (delegateModel == null) {
                LibraryModifiableModelInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateModel = delegateModel;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = ModuleEditor.METHOD_COMMIT.equals(method.getName());
            try {
                Object object2 = method.invoke((Object)this.myDelegateModel, ModuleEditor.unwrapParams(params));
                return object2;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateModel", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryModifiableModelInvocationHandler", "<init>"));
        }
    }

    private class LibraryInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final Library myDelegateLibrary;

        LibraryInvocationHandler(Library delegateLibrary) {
            if (delegateLibrary == null) {
                LibraryInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myDelegateLibrary = delegateLibrary;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            try {
                Object result = method.invoke((Object)this.myDelegateLibrary, ModuleEditor.unwrapParams(params));
                if (result instanceof LibraryEx.ModifiableModelEx) {
                    LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)result;
                    return ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), LibraryEx.ModifiableModelEx.class, (InvocationHandler)new LibraryModifiableModelInvocationHandler((Library.ModifiableModel)model));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateLibrary;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegateLibrary", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryInvocationHandler", "<init>"));
        }
    }

    private class LibraryTableInvocationHandler
    implements InvocationHandler,
    ProxyDelegateAccessor {
        private final LibraryTable myDelegateTable;
        @NonNls
        private final Set<String> myCheckedNames;

        LibraryTableInvocationHandler(LibraryTable table) {
            if (table == null) {
                LibraryTableInvocationHandler.$$$reportNull$$$0(0);
            }
            this.myCheckedNames = new HashSet<String>(Collections.singletonList("removeLibrary"));
            this.myDelegateTable = table;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] params) throws Throwable {
            boolean needUpdate = this.myCheckedNames.contains(method.getName());
            try {
                Object result = method.invoke((Object)this.myDelegateTable, ModuleEditor.unwrapParams(params));
                if (result instanceof Library) {
                    Library library = (Library)result;
                    Object object2 = ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), result instanceof LibraryEx ? LibraryEx.class : Library.class, (InvocationHandler)new LibraryInvocationHandler(library));
                    return object2;
                }
                if (result instanceof LibraryTable.ModifiableModel) {
                    LibraryTable.ModifiableModel model = (LibraryTable.ModifiableModel)result;
                    Object object3 = ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), LibraryTable.ModifiableModel.class, (InvocationHandler)new LibraryTableModelInvocationHandler(model));
                    return object3;
                }
                if (result instanceof Library[]) {
                    Library[] libraries = (Library[])result;
                    for (int idx = 0; idx < libraries.length; ++idx) {
                        Library library = libraries[idx];
                        libraries[idx] = (Library)ReflectionUtil.proxy((ClassLoader)this.getClass().getClassLoader(), library instanceof LibraryEx ? LibraryEx.class : Library.class, (InvocationHandler)new LibraryInvocationHandler(library));
                    }
                }
                Object object4 = result;
                return object4;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (needUpdate) {
                    ModuleEditor.this.updateOrderEntriesInEditors(true);
                }
            }
        }

        @Override
        public Object getDelegate() {
            return this.myDelegateTable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/ModuleEditor$LibraryTableInvocationHandler", "<init>"));
        }
    }
}

