/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectConfigurableUi;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.project.ProjectKt;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project myProject;
    private ProjectConfigurableUi myUi;
    private final StructureConfigurableContext myContext;
    private final ModulesConfigurator myModulesConfigurator;
    private boolean myFreeze = false;
    private DetailsComponent myDetailsComponent;
    private final GeneralProjectSettingsElement mySettingsElement;

    public ProjectConfigurable(Project project2, StructureConfigurableContext context, ModulesConfigurator configurator, ProjectSdksModel model) {
        this.myProject = project2;
        this.myContext = context;
        this.myModulesConfigurator = configurator;
        this.mySettingsElement = new GeneralProjectSettingsElement(context);
        final ProjectStructureDaemonAnalyzer daemonAnalyzer = context.getDaemonAnalyzer();
        this.myModulesConfigurator.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel moduleRootModel) {
                daemonAnalyzer.queueUpdate(ProjectConfigurable.this.mySettingsElement);
            }
        });
        this.myUi = new ProjectConfigurableUi(this, project2);
        this.myUi.initComponents(this.myModulesConfigurator, model);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.mySettingsElement;
    }

    public DetailsComponent getDetailsComponent() {
        return this.myDetailsComponent;
    }

    public JComponent createOptionsPanel() {
        this.myDetailsComponent = new DetailsComponent(false, false);
        this.myDetailsComponent.setContent((JComponent)this.myUi.getPanel());
        this.myDetailsComponent.setText(new String[]{this.getBannerSlogan()});
        this.myUi.reloadJdk();
        return this.myDetailsComponent.getComponent();
    }

    protected boolean isFrozen() {
        return this.myFreeze;
    }

    public void disposeUIResources() {
        this.myUi.disposeUIResources();
    }

    public void reset() {
        this.myFreeze = true;
        try {
            String compilerOutput = this.getOriginalCompilerOutputUrl();
            this.myUi.reset(compilerOutput);
        }
        finally {
            this.myFreeze = false;
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(this.mySettingsElement);
    }

    public void apply() throws ConfigurationException {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.myProject);
        assert (compilerProjectExtension != null) : this.myProject;
        String myProjectName = this.myUi.getProjectName();
        if (StringUtil.isEmptyOrSpaces((String)myProjectName)) {
            throw new ConfigurationException(JavaUiBundle.message("project.configurable.dialog.message", new Object[0]));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            String canonicalPath = this.myUi.getProjectCompilerOutput();
            if (!canonicalPath.isEmpty()) {
                try {
                    canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                canonicalPath = FileUtil.toSystemIndependentName((String)canonicalPath);
                compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)canonicalPath));
            } else {
                compilerProjectExtension.setCompilerOutputUrl(null);
            }
            LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)this.myProject);
            LanguageLevel level = this.myUi.getLanguageLevel();
            if (level != null) {
                extension.setLanguageLevel(level);
            }
            extension.setDefault(Boolean.valueOf(this.myUi.isDefaultLanguageLevel()));
            this.myUi.applyProjectJdkConfigurable();
            if (this.myProject instanceof ProjectEx) {
                ((ProjectEx)this.myProject).setProjectName(this.getProjectName());
                if (this.myDetailsComponent != null) {
                    this.myDetailsComponent.setText(new String[]{this.getBannerSlogan()});
                }
            }
        });
    }

    public void setDisplayName(String name) {
    }

    public Project getEditableObject() {
        return this.myProject;
    }

    public String getBannerSlogan() {
        return JavaUiBundle.message("project.roots.project.banner.text", this.myProject.getName());
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon(boolean open) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        LanguageLevelProjectExtension extension = LanguageLevelProjectExtension.getInstance((Project)this.myProject);
        if (extension.isDefault() != this.myUi.isDefaultLanguageLevel() || !extension.isDefault() && !extension.getLanguageLevel().equals((Object)this.myUi.getLanguageLevel())) {
            return true;
        }
        String compilerOutput = this.getOriginalCompilerOutputUrl();
        if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)compilerOutput)), (String)FileUtil.toSystemIndependentName((String)this.myUi.getProjectCompilerOutput()))) {
            return true;
        }
        if (this.myUi.isProjectJdkConfigurableModified()) {
            return true;
        }
        return !this.getProjectName().equals(this.myProject.getName());
    }

    @NotNull
    @NlsSafe
    public String getProjectName() {
        if (ProjectKt.isDirectoryBased((Project)this.myProject)) {
            @NlsSafe String text = this.myUi.getProjectName();
            String string = text.trim();
            if (string == null) {
                ProjectConfigurable.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = this.myProject.getName();
        if (string == null) {
            ProjectConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private String getOriginalCompilerOutputUrl() {
        CompilerProjectExtension extension = CompilerProjectExtension.getInstance((Project)this.myProject);
        return extension != null ? extension.getCompilerOutputUrl() : null;
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.myUi.getProjectCompilerOutput().trim());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectConfigurable", "getProjectName"));
    }
}

