/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.SdkBridge;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.IconUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectJdksConfigurable
extends MasterDetailsComponent {
    private final ProjectSdksModel myProjectJdksModel;
    private final Project myProject;

    public ProjectJdksConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            ProjectJdksConfigurable.$$$reportNull$$$0(0);
        }
        this(project2, ProjectStructureConfigurable.getInstance(project2).getProjectJdksModel());
    }

    public ProjectJdksConfigurable(@NotNull Project project2, @NotNull ProjectSdksModel sdksModel) {
        if (project2 == null) {
            ProjectJdksConfigurable.$$$reportNull$$$0(1);
        }
        if (sdksModel == null) {
            ProjectJdksConfigurable.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myProjectJdksModel = sdksModel;
        this.initTree();
        this.myToReInitWholePanel = true;
        this.reInitWholePanelIfNeeded();
    }

    protected String getComponentStateKey() {
        return "ProjectJDKs.UI";
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    protected void initTree() {
        super.initTree();
        TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, treePath -> ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName());
        this.myTree.setRootVisible(false);
    }

    public void reset() {
        super.reset();
        this.myProjectJdksModel.reset(this.myProject);
        this.myRoot.removeAllChildren();
        HashMap sdks = this.myProjectJdksModel.getProjectSdks();
        for (Sdk sdk : sdks.keySet()) {
            if (!(sdk instanceof SdkBridge)) continue;
            JdkConfigurable configurable = new JdkConfigurable((Sdk)sdks.get(sdk), this.myProjectJdksModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
        this.selectJdk(this.myProjectJdksModel.getProjectSdk());
        JBSplitter splitter = this.extractSplitter();
        if (splitter != null) {
            splitter.setAndLoadSplitterProportionKey("project.jdk.splitter");
        }
    }

    @Nullable
    private JBSplitter extractSplitter() {
        Component[] components = this.myWholePanel.getComponents();
        return components.length == 1 && components[0] instanceof JBSplitter ? (JBSplitter)components[0] : null;
    }

    public void apply() throws ConfigurationException {
        Ref exceptionRef = Ref.create();
        try {
            super.apply();
            boolean modifiedJdks = false;
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable();
                if (!configurable.isModified()) continue;
                configurable.apply();
                modifiedJdks = true;
            }
            if (this.myProjectJdksModel.isModified() || modifiedJdks) {
                this.myProjectJdksModel.apply((MasterDetailsComponent)this);
            }
            this.myProjectJdksModel.setProjectSdk(this.getSelectedJdk());
        }
        catch (ConfigurationException e) {
            exceptionRef.set((Object)e);
        }
        if (!exceptionRef.isNull()) {
            throw (ConfigurationException)((Object)exceptionRef.get());
        }
    }

    public boolean isModified() {
        return super.isModified() || this.myProjectJdksModel.isModified();
    }

    public void disposeUIResources() {
        this.myProjectJdksModel.disposeUIResources();
        super.disposeUIResources();
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        if (this.myProjectJdksModel == null) {
            return null;
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        DefaultActionGroup group = DefaultActionGroup.createPopupGroup(JavaUiBundle.messagePointer("add.new.jdk.text", new Object[0]));
        group.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        this.myProjectJdksModel.createAddActions(this.myProject, group, (JComponent)this.myTree, projectJdk -> {
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((Sdk)projectJdk, this.myProjectJdksModel, this.TREE_UPDATER, this.myHistory, this.myProject), false), this.myRoot);
            this.selectNodeInTree((DefaultMutableTreeNode)ProjectJdksConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)projectJdk));
        }, SimpleJavaSdkType.notSimpleJavaSdkType());
        actions.add((AnAction)new MasterDetailsComponent.MyActionGroupWrapper((MasterDetailsComponent)this, (ActionGroup)group));
        actions.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        return actions;
    }

    protected void processRemovedItems() {
        HashSet<Sdk> jdks = new HashSet<Sdk>();
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.myRoot.getChildAt(i);
            NamedConfigurable namedConfigurable = (NamedConfigurable)node.getUserObject();
            jdks.add(((JdkConfigurable)namedConfigurable).getEditableObject());
        }
        HashMap sdks = new HashMap(this.myProjectJdksModel.getProjectSdks());
        for (Sdk sdk : sdks.values()) {
            if (jdks.contains(sdk)) continue;
            this.myProjectJdksModel.removeSdk(sdk);
        }
    }

    protected boolean wasObjectStored(Object editableObject) {
        return this.myProjectJdksModel.getProjectSdks().containsKey((Sdk)editableObject);
    }

    @Nullable
    public Sdk getSelectedJdk() {
        return (Sdk)this.getSelectedObject();
    }

    public void selectJdk(Sdk projectJdk) {
        this.selectNodeInTree(projectJdk);
    }

    @Nullable
    public String getDisplayName() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return null;
    }

    @NlsContexts.StatusText
    @NotNull
    protected String getEmptySelectionString() {
        String string = JavaUiBundle.message("project.jdks.configurable.empty.selection.string", new Object[0]);
        if (string == null) {
            ProjectJdksConfigurable.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void selectJdkVersion(JavaSdkVersion requiredJdkVersion) {
        for (Sdk sdk : this.myProjectJdksModel.getSdks()) {
            if (!JavaSdk.getInstance().isOfVersionOrHigher(sdk, requiredJdkVersion)) continue;
            this.selectJdk(sdk);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ProjectJdksConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ProjectJdksConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmptySelectionString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

