/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import javax.swing.Icon;

public final class SourcesOrderRootTypeUIFactory
implements OrderRootTypeUIFactory {
    public SdkPathEditor createPathEditor(Sdk sdk) {
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, false, true, true);
        return new SourcesPathEditor(sdk, descriptor);
    }

    public Icon getIcon() {
        return PlatformIcons.SOURCE_FOLDERS_ICON;
    }

    public String getNodeText() {
        return JavaUiBundle.message("library.sources.node", new Object[0]);
    }

    private static class SourcesPathEditor
    extends SdkPathEditor {
        private final Sdk mySdk;

        SourcesPathEditor(Sdk sdk, FileChooserDescriptor descriptor) {
            super(JavaUiBundle.message("sdk.configure.sourcepath.tab", new Object[0]), OrderRootType.SOURCES, descriptor);
            this.mySdk = sdk;
        }

        protected VirtualFile[] adjustAddedFileSet(Component component, VirtualFile[] files) {
            if (this.mySdk.getSdkType() instanceof JavaSdkType) {
                return LibrarySourceRootDetectorUtil.scanAndSelectDetectedJavaSourceRoots(component, files);
            }
            return super.adjustAddedFileSet(component, files);
        }
    }
}

