/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RefreshRootsLibraryAction
extends DumbAwareAction {
    @NotNull
    private final BaseLibrariesConfigurable myConfigurable;

    RefreshRootsLibraryAction(@NotNull BaseLibrariesConfigurable configurable) {
        if (configurable == null) {
            RefreshRootsLibraryAction.$$$reportNull$$$0(0);
        }
        super(JavaUiBundle.message("refresh.library.roots.action.name", new Object[0]));
        this.myConfigurable = configurable;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Library library;
        if (e == null) {
            RefreshRootsLibraryAction.$$$reportNull$$$0(1);
        }
        if ((library = this.getLibrary()) == null) {
            return;
        }
        final ArrayList allUrls = new ArrayList();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            Collections.addAll(allUrls, library.getUrls(rootType));
        }
        new Task.Backgroundable(this, e.getProject(), LangBundle.message((String)"progress.title.refreshing", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                for (int i = 0; i < allUrls.size(); ++i) {
                    String url = (String)allUrls.get(i);
                    VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
                    indicator.setFraction((double)i / (double)allUrls.size());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/projectRoot/RefreshRootsLibraryAction$1", "run"));
            }
        }.queue();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            RefreshRootsLibraryAction.$$$reportNull$$$0(2);
        }
        Library library = this.getLibrary();
        e.getPresentation().setEnabledAndVisible(library != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            RefreshRootsLibraryAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    @Nullable
    private Library getLibrary() {
        ProjectStructureElement element = this.myConfigurable.getSelectedElement();
        return element instanceof LibraryProjectStructureElement ? ((LibraryProjectStructureElement)element).getLibrary() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/RefreshRootsLibraryAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/RefreshRootsLibraryAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

