/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.intellij.execution.Executor;
import com.intellij.execution.RunContentDescriptorId;
import com.intellij.execution.RunContentDescriptorIdImpl;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.rpc.ComponentDirectTransferId;
import com.intellij.ide.rpc.ComponentDirectTransferIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.dashboard.splitApi.RunDashboardLuxedContentEvent;
import com.intellij.platform.ide.productMode.IdeProductMode;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0007J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u000eJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001fJ\u0012\u0010 \u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u000eH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\"\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getScope", "()Lkotlinx/coroutines/CoroutineScope;", "registeredComponents", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "Lcom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager$RegisteredComponent;", "luxedContents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/intellij/platform/execution/dashboard/splitApi/RunDashboardLuxedContentEvent;", "registerToolWindowContentForLuxingIfNecessary", "", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "executor", "Lcom/intellij/execution/Executor;", "unregisterLuxedToolWindowContent", "startLuxing", "Lcom/intellij/ide/rpc/ComponentDirectTransferId;", "id", "pauseLuxing", "getLuxedContents", "Lkotlinx/coroutines/flow/Flow;", "guessServiceSuitableForDescriptor", "pauseLuxForComponent", "serviceId", "disposeLuxForComponent", "Companion", "RegisteredComponent", "intellij.platform.execution.dashboard"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackendLuxedRunDashboardContentManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLuxedRunDashboardContentManager.kt\ncom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n23#2:129\n23#2:130\n23#2:131\n*S KotlinDebug\n*F\n+ 1 BackendLuxedRunDashboardContentManager.kt\ncom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager\n*L\n68#1:129\n74#1:130\n116#1:131\n*E\n"})
public final class BackendLuxedRunDashboardContentManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<RunDashboardServiceId, RegisteredComponent> registeredComponents;
    @NotNull
    private final MutableSharedFlow<RunDashboardLuxedContentEvent> luxedContents;

    public BackendLuxedRunDashboardContentManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.registeredComponents = new ConcurrentHashMap();
        this.luxedContents = SharedFlowKt.MutableSharedFlow((int)10, (int)10, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getScope() {
        return this.scope;
    }

    public final void registerToolWindowContentForLuxingIfNecessary(@NotNull RunContentDescriptor descriptor, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (IdeProductMode.Companion.isBackend() && Intrinsics.areEqual((Object)"Run", (Object)executor.getId())) {
            Object object = descriptor.getId();
            RunContentDescriptorIdImpl runContentDescriptorIdImpl = object instanceof RunContentDescriptorIdImpl ? (RunContentDescriptorIdImpl)object : null;
            if (runContentDescriptorIdImpl == null) {
                return;
            }
            RunContentDescriptorIdImpl descriptorId = runContentDescriptorIdImpl;
            RunDashboardServiceId runDashboardServiceId = this.guessServiceSuitableForDescriptor(descriptor);
            if (runDashboardServiceId == null) {
                return;
            }
            RunDashboardServiceId serviceId = runDashboardServiceId;
            this.disposeLuxForComponent(serviceId);
            object = this.registeredComponents;
            JComponent jComponent = descriptor.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            RegisteredComponent registeredComponent = new RegisteredComponent(jComponent, serviceId, descriptorId, null);
            object.put(serviceId, registeredComponent);
            this.luxedContents.tryEmit((Object)new RunDashboardLuxedContentEvent(serviceId, descriptorId, "Run", true));
        }
    }

    public final void unregisterLuxedToolWindowContent(@NotNull RunContentDescriptor descriptor, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        if (IdeProductMode.Companion.isBackend() && Intrinsics.areEqual((Object)"Debug", (Object)executor.getId())) {
            RunDashboardServiceId runDashboardServiceId = this.guessServiceSuitableForDescriptor(descriptor);
            if (runDashboardServiceId == null) {
                return;
            }
            RunDashboardServiceId serviceId = runDashboardServiceId;
            RegisteredComponent disposedComponentOrNull = this.disposeLuxForComponent(serviceId);
            RegisteredComponent registeredComponent = disposedComponentOrNull;
            if (registeredComponent == null || (registeredComponent = registeredComponent.getDescriptorId()) == null) {
                return;
            }
            RegisteredComponent disposedDescriptorId = registeredComponent;
            this.luxedContents.tryEmit((Object)new RunDashboardLuxedContentEvent(serviceId, (RunContentDescriptorIdImpl)disposedDescriptorId, "Debug", false));
        }
    }

    @RequiresEdt
    @Nullable
    public final ComponentDirectTransferId startLuxing(@NotNull RunDashboardServiceId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        RegisteredComponent registeredComponent = this.registeredComponents.get(id);
        if (registeredComponent == null) {
            return null;
        }
        RegisteredComponent registeredComponent2 = registeredComponent;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable luxDisposable = disposable;
        registeredComponent2.setActiveDisposable(luxDisposable);
        ComponentDirectTransferId transfer = ComponentDirectTransferIdKt.setupTransfer((JComponent)registeredComponent2.getComponent(), (Disposable)luxDisposable);
        BackendLuxedRunDashboardContentManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendLuxedRunDashboardContentManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("BACKEND DASHBOARD LUX: start for " + id);
        return transfer;
    }

    public final void pauseLuxing(@NotNull RunDashboardServiceId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        BackendLuxedRunDashboardContentManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(BackendLuxedRunDashboardContentManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("BACKEND DASHBOARD LUX: pause for " + id);
        this.pauseLuxForComponent(id);
    }

    @NotNull
    public final Flow<RunDashboardLuxedContentEvent> getLuxedContents() {
        return (Flow)FlowKt.asSharedFlow(this.luxedContents);
    }

    private final RunDashboardServiceId guessServiceSuitableForDescriptor(RunContentDescriptor descriptor) {
        RunDashboardManagerImpl managerImpl = RunDashboardManagerImpl.getInstance(this.project);
        RunContentDescriptorId runContentDescriptorId = descriptor.getId();
        if (runContentDescriptorId == null) {
            return null;
        }
        RunContentDescriptorId descriptorId = runContentDescriptorId;
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = managerImpl.findSettings(descriptorId);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
        RunDashboardService runDashboardService = managerImpl.getServices(settings);
        return runDashboardService != null && (runDashboardService = (RunDashboardService)CollectionsKt.firstOrNull(runDashboardService)) != null ? runDashboardService.getUuid() : null;
    }

    private final void pauseLuxForComponent(RunDashboardServiceId serviceId) {
        boolean bl;
        RegisteredComponent registeredComponent = this.registeredComponents.get(serviceId);
        if (registeredComponent == null) {
            return;
        }
        RegisteredComponent registeredComponent2 = registeredComponent;
        Disposable activeDisposable = registeredComponent2.getActiveDisposable();
        boolean bl2 = bl = activeDisposable != null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "activeDisposable is null for " + serviceId + " while LUXing component is still active - somebody likely changed the backend model incorrectly";
            throw new AssertionError((Object)string);
        }
        Disposable disposable = activeDisposable;
        Intrinsics.checkNotNull((Object)disposable);
        Disposer.dispose((Disposable)disposable);
        registeredComponent2.setActiveDisposable(null);
    }

    private final RegisteredComponent disposeLuxForComponent(RunDashboardServiceId serviceId) {
        Disposable activeDisposable;
        RegisteredComponent registeredComponent = this.registeredComponents.remove(serviceId);
        if (registeredComponent == null) {
            return null;
        }
        RegisteredComponent registeredComponent2 = registeredComponent;
        RunDashboardService existingServiceOrNull = RunDashboardManagerImpl.getInstance(this.project).findServiceById(serviceId);
        if (existingServiceOrNull != null && Intrinsics.areEqual((Object)existingServiceOrNull.getDescriptorId(), (Object)registeredComponent2.getDescriptorId())) {
            RunDashboardManagerImpl.getInstance(this.project).detachServiceRunContentDescriptor((RunContentDescriptorId)registeredComponent2.getDescriptorId());
        }
        if ((activeDisposable = registeredComponent2.getActiveDisposable()) != null) {
            Disposer.dispose((Disposable)activeDisposable);
        } else {
            BackendLuxedRunDashboardContentManager $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BackendLuxedRunDashboardContentManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("activeDisposable is already null for " + serviceId + ". Service was not selected -> LUX was paused, nothing to dispose of");
        }
        return registeredComponent2;
    }

    @JvmStatic
    @NotNull
    public static final BackendLuxedRunDashboardContentManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution.dashboard"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BackendLuxedRunDashboardContentManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(BackendLuxedRunDashboardContentManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BackendLuxedRunDashboardContentManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\tH\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u001fH\u00d6\u0081\u0004J\n\u0010 \u001a\u00020!H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/platform/execution/dashboard/BackendLuxedRunDashboardContentManager$RegisteredComponent;", "", "component", "Ljavax/swing/JComponent;", "serviceId", "Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "descriptorId", "Lcom/intellij/execution/RunContentDescriptorIdImpl;", "activeDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljavax/swing/JComponent;Lcom/intellij/execution/dashboard/RunDashboardServiceId;Lcom/intellij/execution/RunContentDescriptorIdImpl;Lcom/intellij/openapi/Disposable;)V", "getComponent", "()Ljavax/swing/JComponent;", "getServiceId", "()Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "getDescriptorId", "()Lcom/intellij/execution/RunContentDescriptorIdImpl;", "getActiveDisposable", "()Lcom/intellij/openapi/Disposable;", "setActiveDisposable", "(Lcom/intellij/openapi/Disposable;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.execution.dashboard"})
    private static final class RegisteredComponent {
        @NotNull
        private final JComponent component;
        @NotNull
        private final RunDashboardServiceId serviceId;
        @NotNull
        private final RunContentDescriptorIdImpl descriptorId;
        @Nullable
        private Disposable activeDisposable;

        public RegisteredComponent(@NotNull JComponent component, @NotNull RunDashboardServiceId serviceId, @NotNull RunContentDescriptorIdImpl descriptorId, @Nullable Disposable activeDisposable) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            Intrinsics.checkNotNullParameter((Object)descriptorId, (String)"descriptorId");
            this.component = component;
            this.serviceId = serviceId;
            this.descriptorId = descriptorId;
            this.activeDisposable = activeDisposable;
        }

        @NotNull
        public final JComponent getComponent() {
            return this.component;
        }

        @NotNull
        public final RunDashboardServiceId getServiceId() {
            return this.serviceId;
        }

        @NotNull
        public final RunContentDescriptorIdImpl getDescriptorId() {
            return this.descriptorId;
        }

        @Nullable
        public final Disposable getActiveDisposable() {
            return this.activeDisposable;
        }

        public final void setActiveDisposable(@Nullable Disposable disposable) {
            this.activeDisposable = disposable;
        }

        @NotNull
        public final JComponent component1() {
            return this.component;
        }

        @NotNull
        public final RunDashboardServiceId component2() {
            return this.serviceId;
        }

        @NotNull
        public final RunContentDescriptorIdImpl component3() {
            return this.descriptorId;
        }

        @Nullable
        public final Disposable component4() {
            return this.activeDisposable;
        }

        @NotNull
        public final RegisteredComponent copy(@NotNull JComponent component, @NotNull RunDashboardServiceId serviceId, @NotNull RunContentDescriptorIdImpl descriptorId, @Nullable Disposable activeDisposable) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)serviceId, (String)"serviceId");
            Intrinsics.checkNotNullParameter((Object)descriptorId, (String)"descriptorId");
            return new RegisteredComponent(component, serviceId, descriptorId, activeDisposable);
        }

        public static /* synthetic */ RegisteredComponent copy$default(RegisteredComponent registeredComponent, JComponent jComponent, RunDashboardServiceId runDashboardServiceId, RunContentDescriptorIdImpl runContentDescriptorIdImpl, Disposable disposable, int n, Object object) {
            if ((n & 1) != 0) {
                jComponent = registeredComponent.component;
            }
            if ((n & 2) != 0) {
                runDashboardServiceId = registeredComponent.serviceId;
            }
            if ((n & 4) != 0) {
                runContentDescriptorIdImpl = registeredComponent.descriptorId;
            }
            if ((n & 8) != 0) {
                disposable = registeredComponent.activeDisposable;
            }
            return registeredComponent.copy(jComponent, runDashboardServiceId, runContentDescriptorIdImpl, disposable);
        }

        @NotNull
        public String toString() {
            return "RegisteredComponent(component=" + this.component + ", serviceId=" + this.serviceId + ", descriptorId=" + this.descriptorId + ", activeDisposable=" + this.activeDisposable + ")";
        }

        public int hashCode() {
            int result = this.component.hashCode();
            result = result * 31 + this.serviceId.hashCode();
            result = result * 31 + this.descriptorId.hashCode();
            result = result * 31 + (this.activeDisposable == null ? 0 : this.activeDisposable.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RegisteredComponent)) {
                return false;
            }
            RegisteredComponent registeredComponent = (RegisteredComponent)other;
            if (!Intrinsics.areEqual((Object)this.component, (Object)registeredComponent.component)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serviceId, (Object)registeredComponent.serviceId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.descriptorId, (Object)registeredComponent.descriptorId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.activeDisposable, (Object)registeredComponent.activeDisposable);
        }
    }
}

