/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.properties;

import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.BuildIssueEventImpl;
import com.intellij.build.issue.BuildIssue;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.gradle.properties.OutdatedGradleVersionIssue;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.jvmcompat.GradleJvmSupportMatrix;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionChecker;
import org.jetbrains.plugins.gradle.service.execution.GradleExecutionContext;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/gradle/properties/OutdatedGradleVersionChecker;", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionChecker;", "<init>", "()V", "checkExecution", "", "context", "Lorg/jetbrains/plugins/gradle/service/execution/GradleExecutionContext;", "buildEnvironment", "Lorg/gradle/tooling/model/build/BuildEnvironment;", "isLatestMinorVersionInspectionDisabled", "", "isMinorGradleVersionOutdated", "currentVersion", "Lorg/gradle/util/GradleVersion;", "intellij.gradle.properties"})
public final class OutdatedGradleVersionChecker
implements GradleExecutionChecker {
    public void checkExecution(@NotNull GradleExecutionContext context, @NotNull BuildEnvironment buildEnvironment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)buildEnvironment, (String)"buildEnvironment");
        GradleVersion currentVersion = GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
        Intrinsics.checkNotNull((Object)currentVersion);
        if (GradleJvmSupportMatrix.Companion.isGradleDeprecatedByIdea(currentVersion)) {
            return;
        }
        if (this.isLatestMinorVersionInspectionDisabled(context)) {
            return;
        }
        if (this.isMinorGradleVersionOutdated(currentVersion)) {
            return;
        }
        OutdatedGradleVersionIssue issue = new OutdatedGradleVersionIssue(context, currentVersion);
        issue.addOpenInspectionSettingsQuickFix(context, "LatestMinorVersion");
        context.getListener().onStatusChange((ExternalSystemTaskNotificationEvent)new ExternalSystemBuildEvent(context.getTaskId(), (BuildEvent)new BuildIssueEventImpl((Object)context.getTaskId(), (BuildIssue)issue, MessageEvent.Kind.INFO)));
    }

    private final boolean isLatestMinorVersionInspectionDisabled(GradleExecutionContext context) {
        HighlightDisplayKey inspectionKey = HighlightDisplayKey.find((String)"LatestMinorVersion");
        if (inspectionKey == null) {
            return true;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance((Project)context.getProject());
        InspectionProfileImpl inspectionProfileImpl = projectProfileManager.getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl inspectionProfile = inspectionProfileImpl;
        return !inspectionProfile.isToolEnabled(inspectionKey);
    }

    private final boolean isMinorGradleVersionOutdated(GradleVersion currentVersion) {
        GradleVersion latestVersion = GradleJvmSupportMatrix.Companion.getLatestMinorGradleVersion(currentVersion.getMajorVersion());
        return currentVersion.compareTo(latestVersion) >= 0;
    }
}

