/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.java.codeserver.core.JavaPsiSealedUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiUnnamedPattern;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaPatternExhaustivenessUtil {
    private static final Logger LOG = Logger.getInstance(JavaPatternExhaustivenessUtil.class);
    private static final int MAX_ITERATION_COVERAGE = 5000;
    private static final int MAX_GENERATED_PATTERN_NUMBER = 10;

    private JavaPatternExhaustivenessUtil() {
    }

    @NotNull
    private static RecordExhaustivenessResult checkRecordPatternExhaustivenessForDescriptors(@NotNull List<? extends PatternDescriptor> elements, @NotNull PsiType targetType, @NotNull PsiElement context) {
        List descriptions;
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(0);
        }
        if (targetType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(2);
        }
        if ((descriptions = ((StreamEx)StreamEx.of(elements).select(PatternDeconstructionDescriptor.class).filter(element -> TypeConversionUtil.areTypesConvertible((PsiType)element.type(), (PsiType)targetType))).toList()).isEmpty()) {
            RecordExhaustivenessResult recordExhaustivenessResult = RecordExhaustivenessResult.createNotBeAdded();
            if (recordExhaustivenessResult == null) {
                JavaPatternExhaustivenessUtil.$$$reportNull$$$0(3);
            }
            return recordExhaustivenessResult;
        }
        RecordExhaustivenessResult recordExhaustivenessResult = (RecordExhaustivenessResult)((Map)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            ConcurrentMap cacheResult = ConcurrentFactoryMap.createMap(cacheContext -> {
                PsiType selectorType = cacheContext.mySelectorType;
                Set<? extends PatternDescriptor> patterns = cacheContext.currentPatterns;
                ReduceCache cache = ReduceCache.init();
                LoopReduceResult result = JavaPatternExhaustivenessUtil.reduceInLoop(selectorType, context, new HashSet<PatternDescriptor>(patterns), (descriptionPatterns, type) -> JavaPatternExhaustivenessUtil.coverSelectorType(context, descriptionPatterns, selectorType), cache, true);
                if (result.stopped()) {
                    return RecordExhaustivenessResult.createExhaustiveResult();
                }
                List<? extends PatternDescriptor> missedRecordPatterns = JavaPatternExhaustivenessUtil.findMissedRecordPatterns(selectorType, result.patterns, context, cache);
                if (missedRecordPatterns == null) {
                    return RecordExhaustivenessResult.createNotBeAdded();
                }
                RecordExhaustivenessResult exhaustiveResult = RecordExhaustivenessResult.createNotExhaustiveResult();
                exhaustiveResult.addBranches(missedRecordPatterns);
                return exhaustiveResult;
            });
            return CachedValueProvider.Result.create((Object)cacheResult, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(new ReduceResultCacheContext(targetType, new HashSet(descriptions)));
        if (recordExhaustivenessResult == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(4);
        }
        return recordExhaustivenessResult;
    }

    @ApiStatus.Experimental
    @NotNull
    public static RecordExhaustivenessResult checkRecordExhaustiveness(@NotNull List<? extends PsiCaseLabelElement> elements, @NotNull PsiType selectorType, @NotNull PsiElement context) {
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(5);
        }
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(7);
        }
        return JavaPatternExhaustivenessUtil.checkRecordPatternExhaustivenessForDescriptors(JavaPatternExhaustivenessUtil.preparePatternDescriptors(elements), selectorType, context);
    }

    @Nullable
    private static List<? extends PatternDescriptor> findMissedRecordPatterns(@NotNull PsiType selectorType, @NotNull Set<? extends PatternDescriptor> patterns, @NotNull PsiElement context, @NotNull ReduceCache cache) {
        PsiClass selectorClass;
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(8);
        }
        if (patterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(10);
        }
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(11);
        }
        if ((selectorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)selectorType)) == null) {
            return null;
        }
        if (patterns.size() > 100) {
            return null;
        }
        List<PsiType> componentTypes = JavaPatternExhaustivenessUtil.getComponentTypes(context, selectorType);
        if (componentTypes == null) {
            return null;
        }
        for (PsiType psiType : componentTypes) {
            PsiClass componentClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
            if (componentClass != null && !componentClass.hasTypeParameters() || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)psiType)) continue;
            return null;
        }
        for (PatternDescriptor patternDescriptor : patterns) {
            if (!(patternDescriptor instanceof PatternTypeTestDescriptor)) continue;
            return null;
        }
        Map groupedByType = StreamEx.of(patterns).select(PatternDeconstructionDescriptor.class).groupingBy(t -> t.type(), Collectors.toSet());
        if (groupedByType.size() != 1) {
            return null;
        }
        Set set2 = (Set)groupedByType.values().iterator().next();
        if (set2.isEmpty()) {
            return null;
        }
        PatternDeconstructionDescriptor sample = (PatternDeconstructionDescriptor)set2.iterator().next();
        if (!sample.type().equals(selectorType)) {
            return null;
        }
        LinkedHashSet missingRecordPatterns = new LinkedHashSet();
        Set<PatternDeconstructionDescriptor> filtered = JavaPatternExhaustivenessUtil.getDeconstructionPatternOnlyWithTestPatterns(set2);
        if (filtered.isEmpty()) {
            return List.of(new PatternDeconstructionDescriptor(selectorType, ContainerUtil.map(componentTypes, t -> new PatternTypeTestDescriptor((PsiType)t))));
        }
        HashSet<PatternDeconstructionDescriptor> combinedPatterns = new HashSet<PatternDeconstructionDescriptor>(filtered);
        for (int i = 0; i < sample.list().size(); ++i) {
            ArrayList<PatternDeconstructionDescriptor> missingRecordPatternsForThisIteration = new ArrayList<PatternDeconstructionDescriptor>();
            if (missingRecordPatterns.size() > 10) {
                return null;
            }
            MultiMap<List<PatternDescriptor>, PatternDeconstructionDescriptor> groupWithoutOneComponent = JavaPatternExhaustivenessUtil.getGroupWithoutOneComponent(combinedPatterns, i);
            for (Map.Entry value : groupWithoutOneComponent.entrySet()) {
                Collection setWithOneDifferentElement = (Collection)value.getValue();
                if (setWithOneDifferentElement.isEmpty()) {
                    return null;
                }
                List<PatternTypeTestDescriptor> nestedTypeDescriptions = JavaPatternExhaustivenessUtil.getNestedTypeTestDescriptions(setWithOneDifferentElement, i);
                HashSet<PatternTypeTestDescriptor> missedComponentTypeDescription = new HashSet<PatternTypeTestDescriptor>();
                if (componentTypes.size() <= i) {
                    return null;
                }
                PsiType componentType = componentTypes.get(i);
                if (nestedTypeDescriptions.isEmpty()) {
                    missedComponentTypeDescription.add(new PatternTypeTestDescriptor(componentType));
                } else {
                    Set<PsiType> existedTypes = nestedTypeDescriptions.stream().map(t -> t.type()).collect(Collectors.toSet());
                    Set<PsiClass> sealedResult = JavaPatternExhaustivenessUtil.findMissedClasses(componentType, nestedTypeDescriptions, new ArrayList<PsiEnumConstant>(), context);
                    if (!sealedResult.isEmpty()) {
                        JavaPatternExhaustivenessUtil.addNewClasses(context, componentType, sealedResult, existedTypes, missedComponentTypeDescription);
                    } else {
                        combinedPatterns.removeAll(setWithOneDifferentElement);
                        Collection<PatternDeconstructionDescriptor> topLevelPattern = JavaPatternExhaustivenessUtil.createPatternsFrom(i, Set.of(new PatternTypeTestDescriptor(componentType)), (PatternDeconstructionDescriptor)setWithOneDifferentElement.iterator().next());
                        combinedPatterns.addAll(topLevelPattern);
                    }
                }
                Collection<PatternDeconstructionDescriptor> newPatterns = JavaPatternExhaustivenessUtil.createPatternsFrom(i, missedComponentTypeDescription, (PatternDeconstructionDescriptor)setWithOneDifferentElement.iterator().next());
                for (PatternDeconstructionDescriptor pattern : newPatterns) {
                    if (ContainerUtil.exists(filtered, existedPattern -> JavaPatternExhaustivenessUtil.oneOfUnconditional(context, existedPattern, pattern))) continue;
                    missingRecordPatternsForThisIteration.add(pattern);
                }
                missingRecordPatterns.addAll(missingRecordPatternsForThisIteration);
            }
            combinedPatterns.addAll(missingRecordPatternsForThisIteration);
            LoopReduceResult reduceResult = JavaPatternExhaustivenessUtil.reduceInLoop(selectorType, context, combinedPatterns, (set, type) -> false, cache, false);
            HashSet<? extends PatternDescriptor> newPatterns = new HashSet<PatternDescriptor>(reduceResult.patterns());
            if (!reduceResult.changed()) continue;
            newPatterns.removeAll(combinedPatterns);
            combinedPatterns.clear();
            combinedPatterns.addAll(newPatterns);
        }
        LoopReduceResult reduceResult = JavaPatternExhaustivenessUtil.reduceInLoop(selectorType, context, combinedPatterns, (set, type) -> false, cache, false);
        return JavaPatternExhaustivenessUtil.coverSelectorType(context, reduceResult.patterns(), selectorType) ? new ArrayList(missingRecordPatterns) : null;
    }

    @NotNull
    private static List<PatternTypeTestDescriptor> getNestedTypeTestDescriptions(@NotNull Collection<PatternDeconstructionDescriptor> setWithOneDifferentElement, int i) {
        if (setWithOneDifferentElement == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(12);
        }
        List list = StreamEx.of(setWithOneDifferentElement).map(t -> t.list().get(i)).select(PatternTypeTestDescriptor.class).toList();
        if (list == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    private static MultiMap<List<PatternDescriptor>, PatternDeconstructionDescriptor> getGroupWithoutOneComponent(@NotNull Set<? extends PatternDescriptor> combinedPatterns, int i) {
        if (combinedPatterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(14);
        }
        MultiMap groupWithoutOneComponent = new MultiMap();
        for (PatternDescriptor patternDescriptor : combinedPatterns) {
            PatternDeconstructionDescriptor deconstructionDescription;
            if (!(patternDescriptor instanceof PatternDeconstructionDescriptor) || (deconstructionDescription = (PatternDeconstructionDescriptor)patternDescriptor).list().size() <= i) continue;
            groupWithoutOneComponent.putValue(JavaPatternExhaustivenessUtil.getWithoutComponent(deconstructionDescription, i), (Object)deconstructionDescription);
        }
        MultiMap multiMap = groupWithoutOneComponent;
        if (multiMap == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(15);
        }
        return multiMap;
    }

    private static List<PatternDescriptor> getWithoutComponent(@NotNull PatternDeconstructionDescriptor description, int toRemove) {
        if (description == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(16);
        }
        ArrayList<PatternDescriptor> shortKey = new ArrayList<PatternDescriptor>();
        for (int i = 0; i < description.list().size(); ++i) {
            if (toRemove == i) continue;
            shortKey.add(description.list().get(i));
        }
        return shortKey;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static ReduceResult unwrapSealedTypes(@NotNull Set<? extends PatternDescriptor> existedPatterns, @NotNull ReduceCache cache) {
        if (existedPatterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(17);
        }
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(18);
        }
        HashSet<? extends PatternDescriptor> result = new HashSet<PatternDescriptor>(existedPatterns);
        if (existedPatterns.isEmpty()) {
            return new ReduceResult(result, false);
        }
        List deconstructionExistedPatterns = ContainerUtil.filterIsInstance(existedPatterns, PatternDeconstructionDescriptor.class);
        if (deconstructionExistedPatterns.isEmpty()) {
            return new ReduceResult(result, false);
        }
        ReduceUnwrapContext cacheContext = new ReduceUnwrapContext(new HashSet<PatternDeconstructionDescriptor>(deconstructionExistedPatterns));
        ReduceResult cachedResult = cache.unwrapCache().get(cacheContext);
        if (cachedResult != null) {
            return new ReduceResult(cachedResult.patterns(), cachedResult.patterns().size() != existedPatterns.size());
        }
        Map deconstructionPatternsByType = StreamEx.of((Collection)deconstructionExistedPatterns).groupingBy(t -> t.type(), Collectors.toSet());
        for (Set deconstructionExistedPatternWithTheSameType : deconstructionPatternsByType.values()) {
            for (PatternDeconstructionDescriptor basePattern : deconstructionExistedPatternWithTheSameType) {
                List<? extends PatternDescriptor> patternDescriptions = basePattern.list();
                for (int i = 0; i < patternDescriptions.size(); ++i) {
                    PsiType psiType;
                    PatternDescriptor baseDescription = patternDescriptions.get(i);
                    if (!(baseDescription instanceof PatternTypeTestDescriptor)) continue;
                    PatternTypeTestDescriptor patternTypeTestDescriptor = (PatternTypeTestDescriptor)baseDescription;
                    PsiType baseType = psiType = patternTypeTestDescriptor.type();
                    PsiType baseClass = psiType = patternTypeTestDescriptor.psiClass();
                    if (baseClass == null || !JavaPsiSealedUtil.isAbstractSealed((PsiClass)baseClass)) continue;
                    for (PatternDeconstructionDescriptor comparedPattern : deconstructionExistedPatternWithTheSameType) {
                        PsiType psiType2;
                        PatternDescriptor comparedDescription;
                        if (comparedPattern == basePattern || !comparedPattern.type().equals(basePattern.type()) || comparedPattern.list().size() != patternDescriptions.size() || !((comparedDescription = comparedPattern.list().get(i)) instanceof PatternTypeTestDescriptor)) continue;
                        PatternTypeTestDescriptor patternTypeTestDescriptor2 = (PatternTypeTestDescriptor)comparedDescription;
                        PsiType cmpType = psiType2 = patternTypeTestDescriptor2.type();
                        psiType2 = patternTypeTestDescriptor2.psiClass();
                        PsiType cmpClass = psiType2;
                        if (cmpClass == null || baseClass.getManager().areElementsEquivalent((PsiElement)baseClass, (PsiElement)cmpClass) || !baseType.isAssignableFrom(cmpType) || !JavaPatternExhaustivenessUtil.isDirectSealedPath((PsiClass)cmpClass, (PsiClass)baseClass, cache, new HashSet<PsiClass>())) continue;
                        result.addAll(JavaPatternExhaustivenessUtil.createPatternsFrom(i, Set.of(comparedDescription), basePattern));
                    }
                }
            }
        }
        ReduceResult reduceResult = new ReduceResult(result, result.size() != existedPatterns.size());
        cache.unwrapCache().put(cacheContext, reduceResult);
        ReduceUnwrapContext newContext = new ReduceUnwrapContext(StreamEx.of(reduceResult.patterns()).select(PatternDeconstructionDescriptor.class).toSet());
        cache.unwrapCache().put(newContext, reduceResult);
        ReduceResult reduceResult2 = reduceResult;
        if (reduceResult2 == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(19);
        }
        return reduceResult2;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static boolean isDirectSealedPath(@Nullable PsiClass from, @Nullable PsiClass to, @NotNull ReduceCache cache, @NotNull Set<PsiClass> visited) {
        Boolean isSealedPath;
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(20);
        }
        if (visited == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(21);
        }
        if (from == null || to == null) {
            return false;
        }
        Map<PsiClass, Boolean> toCache = cache.sealedPath().get(from);
        if (toCache != null && (isSealedPath = toCache.get(to)) != null) {
            return isSealedPath;
        }
        if (!visited.add(from)) {
            return false;
        }
        if (from.getManager().areElementsEquivalent((PsiElement)from, (PsiElement)to)) {
            boolean result = JavaPsiSealedUtil.isAbstractSealed(to);
            JavaPatternExhaustivenessUtil.addToSealedCache(from, to, cache, result);
            return result;
        }
        if (!from.isInheritor(to, true)) {
            boolean result = false;
            JavaPatternExhaustivenessUtil.addToSealedCache(from, to, cache, result);
            return result;
        }
        boolean result = ContainerUtil.exists((Object[])from.getSupers(), superClass -> JavaPsiSealedUtil.isAbstractSealed(superClass) && JavaPatternExhaustivenessUtil.isDirectSealedPath(superClass, to, cache, visited));
        JavaPatternExhaustivenessUtil.addToSealedCache(from, to, cache, result);
        return result;
    }

    private static void addToSealedCache(@Nullable PsiClass from, @Nullable PsiClass to, @NotNull ReduceCache cache, boolean result) {
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(22);
        }
        cache.sealedPath().computeIfAbsent(from, k -> new HashMap()).put(to, result);
    }

    @NotNull
    private static Set<PatternDeconstructionDescriptor> getDeconstructionPatternOnlyWithTestPatterns(Set<PatternDeconstructionDescriptor> descriptions) {
        HashSet<PatternDeconstructionDescriptor> filtered = new HashSet<PatternDeconstructionDescriptor>();
        for (PatternDeconstructionDescriptor description : descriptions) {
            if (!ContainerUtil.and(description.list(), t -> t instanceof PatternTypeTestDescriptor)) continue;
            filtered.add(description);
        }
        HashSet<PatternDeconstructionDescriptor> hashSet = filtered;
        if (hashSet == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    @Nullable
    private static @Unmodifiable List<PsiType> getComponentTypes(@NotNull PsiElement context, @NotNull PsiType type) {
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(24);
        }
        if (type == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(25);
        }
        return (List)((Map)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
            ConcurrentMap result = ConcurrentFactoryMap.createMap(descriptionType -> {
                PsiType capturedToplevel = PsiUtil.captureToplevelWildcards((PsiType)descriptionType, (PsiElement)context);
                PsiClassType.ClassResolveResult resolve = PsiUtil.resolveGenericsClassInType((PsiType)capturedToplevel);
                PsiClass selectorClass = resolve.getElement();
                PsiSubstitutor substitutor = resolve.getSubstitutor();
                if (selectorClass == null) {
                    return null;
                }
                return ContainerUtil.map((Object[])selectorClass.getRecordComponents(), component -> substitutor.substitute(component.getType()));
            });
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        })).get(type);
    }

    @NotNull
    private static Collection<PatternDeconstructionDescriptor> createPatternsFrom(int differentElement, @NotNull Set<? extends PatternDescriptor> nestedPatterns, @NotNull PatternDeconstructionDescriptor sample) {
        if (nestedPatterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(26);
        }
        if (sample == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(27);
        }
        HashSet<PatternDeconstructionDescriptor> descriptions = new HashSet<PatternDeconstructionDescriptor>();
        for (PatternDescriptor patternDescriptor : nestedPatterns) {
            descriptions.add(sample.createFor(differentElement, patternDescriptor));
        }
        HashSet<PatternDeconstructionDescriptor> hashSet = descriptions;
        if (hashSet == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(28);
        }
        return hashSet;
    }

    private static boolean oneOfUnconditional(@NotNull PsiElement context, @NotNull PatternDeconstructionDescriptor whoType, @NotNull PatternDeconstructionDescriptor overWhom) {
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(29);
        }
        if (whoType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(30);
        }
        if (overWhom == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(31);
        }
        if (!whoType.type().equals(overWhom.type())) {
            return false;
        }
        if (whoType.list().size() != overWhom.list().size()) {
            return false;
        }
        for (int i = 0; i < whoType.list().size(); ++i) {
            if (JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)whoType.list().get(i).type(), (PsiType)overWhom.list().get(i).type())) continue;
            return false;
        }
        return true;
    }

    private static boolean coverSelectorType(@NotNull PsiElement context, @NotNull Set<? extends PatternDescriptor> patterns, @NotNull PsiType selectorType) {
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(32);
        }
        if (patterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(33);
        }
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(34);
        }
        for (PatternDescriptor patternDescriptor : patterns) {
            if (!(patternDescriptor instanceof PatternTypeTestDescriptor) || !JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)patternDescriptor.type(), (PsiType)selectorType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ReduceResult reduce(@NotNull PsiType selectorType, @NotNull PsiElement context, @NotNull Set<? extends PatternDescriptor> currentPatterns, @NotNull ReduceCache cache) {
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(35);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(36);
        }
        if (currentPatterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(37);
        }
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(38);
        }
        currentPatterns = new HashSet<PatternDescriptor>(currentPatterns);
        ReduceResultCacheContext cacheContext = new ReduceResultCacheContext(selectorType, currentPatterns);
        ReduceResult result = cache.loopReduceCache().get(cacheContext);
        if (result == null) {
            result = new ReduceResult(currentPatterns, false).reduceRecordPatterns(context, cache).reduceDeconstructionRecordToTypePattern(context).reduceClasses(selectorType, context);
            cache.loopReduceCache().put(cacheContext, result);
        }
        ReduceResult reduceResult = result;
        if (reduceResult == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(39);
        }
        return reduceResult;
    }

    @NotNull
    private static LoopReduceResult reduceInLoop(@NotNull PsiType selectorType, @NotNull PsiElement context, @NotNull Set<? extends PatternDescriptor> patterns, @NotNull BiPredicate<Set<? extends PatternDescriptor>, PsiType> stopAt, @NotNull ReduceCache cache, boolean tryToExpand) {
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(40);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(41);
        }
        if (patterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(42);
        }
        if (stopAt == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(43);
        }
        if (cache == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(44);
        }
        boolean changed = false;
        int currentIteration = 0;
        Set<? extends PatternDescriptor> currentPatterns = new HashSet<PatternDescriptor>(patterns);
        boolean tryToExpandNext = tryToExpand;
        while (currentIteration < 5000) {
            ++currentIteration;
            if (stopAt.test(currentPatterns, selectorType)) {
                return new LoopReduceResult(currentPatterns, true, true);
            }
            ReduceResult reduceResult = JavaPatternExhaustivenessUtil.reduce(selectorType, context, currentPatterns, cache);
            if (tryToExpandNext && !reduceResult.changed() && reduceResult.patterns().size() > 1) {
                reduceResult = JavaPatternExhaustivenessUtil.unwrapSealedTypes(reduceResult.patterns(), cache);
                tryToExpandNext = false;
            }
            changed |= reduceResult.changed();
            currentPatterns = reduceResult.patterns();
            if (reduceResult.changed()) continue;
            return new LoopReduceResult(currentPatterns, changed, false);
        }
        LOG.error("The number of iteration is exceeded, length of set patterns: " + patterns.size() + "max length deconstruction: " + String.valueOf(patterns.stream().filter(t -> t instanceof PatternDeconstructionDescriptor).map(t -> ((PatternDeconstructionDescriptor)t).list.size()).max(Comparator.naturalOrder())));
        return new LoopReduceResult(currentPatterns, changed, false);
    }

    private static boolean addNewClasses(@NotNull PsiElement context, @NotNull PsiType selectorType, @NotNull Set<PsiClass> visitedCovered, @NotNull Set<PsiType> existedTypes, @NotNull Collection<PatternTypeTestDescriptor> toAdd) {
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(45);
        }
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(46);
        }
        if (visitedCovered == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(47);
        }
        if (existedTypes == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(48);
        }
        if (toAdd == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(49);
        }
        boolean changed = false;
        for (PsiClass covered : visitedCovered) {
            PsiClassType classType = JavaPsiFacade.getElementFactory((Project)covered.getProject()).createType(covered);
            if (existedTypes.contains(classType)) continue;
            if (JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)selectorType, (PsiType)classType)) {
                toAdd.add(new PatternTypeTestDescriptor((PsiType)classType));
                changed = true;
            }
            if (!JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)classType, (PsiType)selectorType)) continue;
            toAdd.add(new PatternTypeTestDescriptor(selectorType));
            changed = true;
            break;
        }
        return changed;
    }

    @NotNull
    private static Set<PatternDescriptor> combineResult(@NotNull Set<? extends PatternDescriptor> patterns, Set<? extends PatternDescriptor> toRemove, Set<? extends PatternDescriptor> toAdd) {
        if (patterns == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(50);
        }
        HashSet<PatternDescriptor> result = new HashSet<PatternDescriptor>();
        for (PatternDescriptor patternDescriptor : patterns) {
            if (toRemove.contains(patternDescriptor)) continue;
            result.add(patternDescriptor);
        }
        result.addAll(toAdd);
        HashSet<PatternDescriptor> hashSet = result;
        if (hashSet == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(51);
        }
        return hashSet;
    }

    @NotNull
    private static MultiMap<PsiClass, PsiType> findPermittedClasses(@NotNull List<PatternTypeTestDescriptor> elements) {
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(52);
        }
        MultiMap patternClasses = new MultiMap();
        for (PatternDescriptor patternDescriptor : elements) {
            PsiType patternType = patternDescriptor.type();
            PsiClass patternClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)patternType);
            if (patternClass == null) continue;
            patternClasses.putValue((Object)patternClass, (Object)patternDescriptor.type());
            Set<PsiClass> classes = JavaPsiSealedUtil.getAllPermittedClasses(patternClass);
            for (PsiClass aClass : classes) {
                patternClasses.putValue((Object)aClass, (Object)patternDescriptor.type());
            }
        }
        MultiMap multiMap = patternClasses;
        if (multiMap == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(53);
        }
        return multiMap;
    }

    @NotNull
    private static List<PatternTypeTestDescriptor> reduceToTypeTest(@NotNull List<? extends PatternDescriptor> elements, @NotNull PsiElement context) {
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(54);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(55);
        }
        ArrayList<PatternTypeTestDescriptor> reducedToTypeTest = new ArrayList<PatternTypeTestDescriptor>();
        ArrayList<PatternDeconstructionDescriptor> deconstructionDescriptions = new ArrayList<PatternDeconstructionDescriptor>();
        for (PatternDescriptor patternDescriptor : elements) {
            if (patternDescriptor instanceof PatternTypeTestDescriptor) {
                PatternTypeTestDescriptor typeTestDescription = (PatternTypeTestDescriptor)patternDescriptor;
                reducedToTypeTest.add(typeTestDescription);
            }
            if (!(patternDescriptor instanceof PatternDeconstructionDescriptor)) continue;
            PatternDeconstructionDescriptor deconstructionDescription = (PatternDeconstructionDescriptor)patternDescriptor;
            deconstructionDescriptions.add(deconstructionDescription);
        }
        Map<PsiType, List<PatternDeconstructionDescriptor>> groupedByType = deconstructionDescriptions.stream().collect(Collectors.groupingBy(t -> t.type()));
        for (Map.Entry<PsiType, List<PatternDeconstructionDescriptor>> entry : groupedByType.entrySet()) {
            if (!JavaPatternExhaustivenessUtil.checkRecordPatternExhaustivenessForDescriptors(entry.getValue(), entry.getKey(), context).isExhaustive()) continue;
            reducedToTypeTest.add(new PatternTypeTestDescriptor(entry.getKey()));
        }
        ArrayList<PatternTypeTestDescriptor> arrayList = reducedToTypeTest;
        if (arrayList == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(56);
        }
        return arrayList;
    }

    @NotNull
    private static List<PatternTypeTestDescriptor> reduceEnumConstantsToTypeTest(@NotNull List<PsiEnumConstant> constants) {
        if (constants == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(57);
        }
        ArrayList<PatternTypeTestDescriptor> reducedToTypeTest = new ArrayList<PatternTypeTestDescriptor>();
        Map enumsByTypes = constants.stream().collect(Collectors.groupingBy(t -> t.getType(), Collectors.toUnmodifiableSet()));
        enumsByTypes.forEach((enumType, enumConstants) -> {
            PsiClass enumClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)enumType);
            if (enumClass != null && !JavaPatternExhaustivenessUtil.hasMissingEnumConstant(enumClass, enumConstants)) {
                reducedToTypeTest.add(new PatternTypeTestDescriptor((PsiType)enumType));
            }
        });
        ArrayList<PatternTypeTestDescriptor> arrayList = reducedToTypeTest;
        if (arrayList == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(58);
        }
        return arrayList;
    }

    private static boolean hasMissingEnumConstant(PsiClass enumClass, Set<PsiEnumConstant> covered) {
        for (PsiField field : enumClass.getFields()) {
            PsiEnumConstant enumConstant;
            if (!(field instanceof PsiEnumConstant) || covered.contains(enumConstant = (PsiEnumConstant)field)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Set<PsiClass> findMissedClasses(@NotNull PsiSwitchBlock block, @NotNull PsiType selectorType, @NotNull List<? extends PsiCaseLabelElement> elements) {
        if (block == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(59);
        }
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(60);
        }
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(61);
        }
        List<PatternDescriptor> descriptions = JavaPatternExhaustivenessUtil.preparePatternDescriptors(elements);
        List<PsiEnumConstant> enumConstants = JavaPatternExhaustivenessUtil.getEnumConstants(elements);
        return JavaPatternExhaustivenessUtil.findMissedClasses(selectorType, descriptions, enumConstants, (PsiElement)block);
    }

    @NotNull
    private static List<PsiEnumConstant> getEnumConstants(@NotNull List<? extends PsiCaseLabelElement> elements) {
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(62);
        }
        List list = StreamEx.of(elements).map(JavaPsiSwitchUtil::getEnumConstant).nonNull().toList();
        if (list == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(63);
        }
        return list;
    }

    @NotNull
    private static Set<PsiClass> findMissedClasses(@NotNull PsiType selectorType, @NotNull List<? extends PatternDescriptor> elements, @NotNull List<PsiEnumConstant> enumConstants, @NotNull PsiElement context) {
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(64);
        }
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(65);
        }
        if (enumConstants == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(66);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(67);
        }
        Set<PsiClass> set = JavaPatternExhaustivenessUtil.findMissedClassesData(selectorType, elements, enumConstants, context).missedClasses();
        if (set == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(68);
        }
        return set;
    }

    @NotNull
    private static SealedResult findMissedClassesData(@NotNull PsiType selectorType, @NotNull List<? extends PatternDescriptor> elements, @NotNull List<PsiEnumConstant> enumConstants, @NotNull PsiElement context) {
        if (selectorType == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(69);
        }
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(70);
        }
        if (enumConstants == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(71);
        }
        if (context == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(72);
        }
        HashSet<PsiClass> coveredClasses = new HashSet<PsiClass>();
        HashSet<PsiClass> visitedNotCovered = new HashSet<PsiClass>();
        LinkedHashSet<PsiClass> missingClasses = new LinkedHashSet<PsiClass>();
        List<PatternTypeTestDescriptor> reducedDescriptions = JavaPatternExhaustivenessUtil.reduceToTypeTest(elements, context);
        reducedDescriptions.addAll(JavaPatternExhaustivenessUtil.reduceEnumConstantsToTypeTest(enumConstants));
        MultiMap<PsiClass, PsiType> permittedPatternClasses = JavaPatternExhaustivenessUtil.findPermittedClasses(reducedDescriptions);
        Set<PsiClass> sealedUpperClasses = JavaPsiSealedUtil.findSealedUpperClasses(permittedPatternClasses.keySet());
        List typeTestPatterns = ContainerUtil.filterIsInstance(elements, PatternTypeTestDescriptor.class);
        Set selectorClasses = ContainerUtil.map2SetNotNull((Collection)JavaPsiPatternUtil.deconstructSelectorType((PsiType)selectorType), type -> PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)type)));
        if (selectorClasses.isEmpty()) {
            return new SealedResult(Collections.emptySet(), Collections.emptySet());
        }
        record ClassWithDependencies(PsiClass mainClass, List<PsiClass> dependencies) {
        }
        ArrayDeque<ClassWithDependencies> nonVisited = new ArrayDeque<ClassWithDependencies>();
        SmartHashSet visited = new SmartHashSet();
        for (PsiClass selectorClass : selectorClasses) {
            ArrayList<PsiClass> dependencies = new ArrayList<PsiClass>();
            dependencies.add(selectorClass);
            nonVisited.add(new ClassWithDependencies(selectorClass, dependencies));
        }
        while (!nonVisited.isEmpty()) {
            ClassWithDependencies peeked = (ClassWithDependencies)nonVisited.peek();
            if (!visited.add(peeked)) continue;
            PsiClass psiClass = peeked.mainClass;
            PsiClass selectorClass = peeked.dependencies.getLast();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            if (sealedUpperClasses.contains(psiClass) || selectorClasses.contains(psiClass) && elements.isEmpty()) {
                for (PsiClass permittedClass : JavaPsiSealedUtil.getPermittedClasses(psiClass)) {
                    Collection patternTypes = permittedPatternClasses.get((Object)permittedClass);
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)selectorClass, (PsiClass)permittedClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    PsiClassType permittedType = factory.createType(psiClass, substitutor);
                    if (patternTypes.isEmpty() && TypeConversionUtil.areTypesConvertible((PsiType)selectorType, (PsiType)permittedType) || !patternTypes.isEmpty() && !ContainerUtil.exists((Iterable)patternTypes, patternType -> JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)patternType, (PsiType)factory.createType(permittedClass)))) {
                        ArrayList<PsiClass> dependentClasses = new ArrayList<PsiClass>(peeked.dependencies);
                        dependentClasses.add(permittedClass);
                        nonVisited.add(new ClassWithDependencies(permittedClass, dependentClasses));
                        continue;
                    }
                    if (patternTypes.isEmpty()) continue;
                    coveredClasses.addAll(peeked.dependencies);
                }
            } else {
                PsiClassType targetType = factory.createType(psiClass);
                if (TypeConversionUtil.areTypesConvertible((PsiType)targetType, (PsiType)selectorType) || JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)targetType, (PsiType)selectorType)) {
                    if (!ContainerUtil.exists((Iterable)typeTestPatterns, pattern -> JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)pattern.type(), (PsiType)targetType))) {
                        missingClasses.add(psiClass);
                        visitedNotCovered.addAll(peeked.dependencies);
                    } else {
                        coveredClasses.addAll(peeked.dependencies);
                    }
                }
            }
            nonVisited.poll();
        }
        coveredClasses.removeAll(visitedNotCovered);
        for (PsiClass selectorClass : selectorClasses) {
            if (!coveredClasses.contains(selectorClass)) continue;
            missingClasses.clear();
            break;
        }
        return new SealedResult(missingClasses, coveredClasses);
    }

    @Contract(pure=true)
    @NotNull
    private static @NotNull List<@NotNull PatternDescriptor> preparePatternDescriptors(@NotNull List<? extends PsiCaseLabelElement> caseElements) {
        if (caseElements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(73);
        }
        List unconditionalPatterns = ContainerUtil.mapNotNull(caseElements, element -> JavaPsiPatternUtil.findUnconditionalPattern((PsiCaseLabelElement)element));
        List list = StreamEx.of((Collection)unconditionalPatterns).map(JavaPatternExhaustivenessUtil::createDescription).nonNull().toList();
        if (list == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(74);
        }
        return list;
    }

    @Nullable
    private static PatternDescriptor createDescription(@NotNull PsiPattern pattern) {
        PsiType type;
        if (pattern == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(75);
        }
        if ((type = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)pattern)) == null) {
            return null;
        }
        if (pattern instanceof PsiTypeTestPattern || pattern instanceof PsiUnnamedPattern) {
            return new PatternTypeTestDescriptor(type);
        }
        if (pattern instanceof PsiDeconstructionPattern) {
            PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)type);
            if (psiClass == null || !psiClass.isRecord()) {
                return null;
            }
            if (deconstructionPattern.getDeconstructionList().getDeconstructionComponents().length != psiClass.getRecordComponents().length) {
                return null;
            }
            ArrayList<PatternDescriptor> deconstructionList = new ArrayList<PatternDescriptor>();
            for (PsiPattern component : deconstructionPattern.getDeconstructionList().getDeconstructionComponents()) {
                PatternDescriptor description = JavaPatternExhaustivenessUtil.createDescription(component);
                if (description == null) {
                    return null;
                }
                deconstructionList.add(description);
            }
            return new PatternDeconstructionDescriptor(type, deconstructionList);
        }
        throw new IllegalArgumentException("Unknown type for createDescription for exhaustiveness: " + String.valueOf(pattern.getClass()));
    }

    public static boolean hasExhaustivenessError(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(76);
        }
        return JavaPatternExhaustivenessUtil.hasExhaustivenessError(block, JavaPsiSwitchUtil.getCaseLabelElements(block));
    }

    public static boolean hasExhaustivenessError(@NotNull PsiSwitchBlock block, @NotNull List<PsiCaseLabelElement> elements) {
        PsiExpression selector;
        if (block == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(77);
        }
        if (elements == null) {
            JavaPatternExhaustivenessUtil.$$$reportNull$$$0(78);
        }
        if ((selector = block.getExpression()) == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return false;
        }
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)TypeConversionUtil.erasure((PsiType)selectorType));
        if (unboxedType != null) {
            for (PsiCaseLabelElement t : elements) {
                PsiPrimitiveType primitiveType;
                PsiTypeTestPattern testPattern;
                PsiPrimaryPattern psiPrimaryPattern = JavaPsiPatternUtil.findUnconditionalPattern((PsiCaseLabelElement)t);
                if (!(psiPrimaryPattern instanceof PsiTypeTestPattern) || !((psiPrimaryPattern = JavaPsiPatternUtil.getPatternType((PsiCaseLabelElement)(testPattern = (PsiTypeTestPattern)psiPrimaryPattern))) instanceof PsiPrimitiveType) || !JavaPsiPatternUtil.isUnconditionallyExactForType((PsiElement)t, (PsiType)unboxedType, (PsiType)(primitiveType = (PsiPrimitiveType)psiPrimaryPattern))) continue;
                return false;
            }
        }
        if (JavaPsiSwitchUtil.isBooleanSwitchWithTrueAndFalse(block)) {
            return false;
        }
        PsiClass selectorClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)selectorType));
        if (selectorClass != null && JavaPsiSwitchUtil.getSwitchSelectorKind(selectorType) == JavaPsiSwitchUtil.SelectorKind.ENUM) {
            List<PsiEnumConstant> enumElements = JavaPatternExhaustivenessUtil.getEnumConstants(elements);
            if (enumElements.isEmpty()) {
                return true;
            }
            return StreamEx.of((Object[])selectorClass.getFields()).select(PsiEnumConstant.class).anyMatch(e -> !enumElements.contains(e));
        }
        boolean hasAbstractSealedType = StreamEx.of((Collection)JavaPsiPatternUtil.deconstructSelectorType((PsiType)selectorType)).map(type -> PsiUtil.resolveClassInClassTypeOnly((PsiType)TypeConversionUtil.erasure((PsiType)type))).nonNull().anyMatch(JavaPsiSealedUtil::isAbstractSealed);
        if (hasAbstractSealedType) {
            return !JavaPatternExhaustivenessUtil.findMissedClasses(block, selectorType, elements).isEmpty();
        }
        boolean recordExhaustive = selectorClass != null && selectorClass.isRecord() && JavaPatternExhaustivenessUtil.checkRecordExhaustiveness(elements, selectorType, (PsiElement)block).isExhaustive();
        return !recordExhaustive;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 13, 15, 19, 23, 28, 39, 51, 53, 56, 58, 63, 68, 74 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: 
            case 7: 
            case 10: 
            case 24: 
            case 29: 
            case 32: 
            case 36: 
            case 41: 
            case 45: 
            case 55: 
            case 67: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 39: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 63: 
            case 68: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil";
                break;
            }
            case 6: 
            case 8: 
            case 34: 
            case 35: 
            case 40: 
            case 46: 
            case 60: 
            case 64: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 9: 
            case 33: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 11: 
            case 18: 
            case 20: 
            case 22: 
            case 38: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setWithOneDifferentElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combinedPatterns";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existedPatterns";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedPatterns";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whoType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPatterns";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedCovered";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existedTypes";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constants";
                break;
            }
            case 59: 
            case 76: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 66: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumConstants";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseElements";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkRecordPatternExhaustivenessForDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedTypeTestDescriptions";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupWithoutOneComponent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapSealedTypes";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeconstructionPatternOnlyWithTestPatterns";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternsFrom";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "reduce";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "combineResult";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "findPermittedClasses";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "reduceToTypeTest";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "reduceEnumConstantsToTypeTest";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumConstants";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "findMissedClasses";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePatternDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordPatternExhaustivenessForDescriptors";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 15: 
            case 19: 
            case 23: 
            case 28: 
            case 39: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 63: 
            case 68: 
            case 74: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordExhaustiveness";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findMissedRecordPatterns";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNestedTypeTestDescriptions";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getGroupWithoutOneComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getWithoutComponent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unwrapSealedTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDirectSealedPath";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addToSealedCache";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getComponentTypes";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createPatternsFrom";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "oneOfUnconditional";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "coverSelectorType";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "reduce";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "reduceInLoop";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addNewClasses";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "combineResult";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "findPermittedClasses";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "reduceToTypeTest";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "reduceEnumConstantsToTypeTest";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findMissedClasses";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getEnumConstants";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "findMissedClassesData";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "preparePatternDescriptors";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "hasExhaustivenessError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 13, 15, 19, 23, 28, 39, 51, 53, 56, 58, 63, 68, 74 -> new IllegalStateException(string);
        };
    }

    private record PatternDeconstructionDescriptor(@NotNull PsiType type, @NotNull List<? extends PatternDescriptor> list) implements PatternDescriptor
    {
        @NotNull
        private final PsiType type;
        @NotNull
        private final List<? extends PatternDescriptor> list;

        private PatternDeconstructionDescriptor(@NotNull PsiType type, @NotNull List<? extends PatternDescriptor> list) {
            if (type == null) {
                PatternDeconstructionDescriptor.$$$reportNull$$$0(0);
            }
            if (list == null) {
                PatternDeconstructionDescriptor.$$$reportNull$$$0(1);
            }
        }

        PatternDeconstructionDescriptor createFor(int element, PatternDescriptor pattern) {
            ArrayList<? extends PatternDescriptor> descriptions = new ArrayList<PatternDescriptor>(this.list);
            descriptions.set(element, pattern);
            return new PatternDeconstructionDescriptor(this.type, descriptions);
        }

        @Override
        @NotNull
        public PsiType type() {
            PsiType psiType = this.type;
            if (psiType == null) {
                PatternDeconstructionDescriptor.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @NotNull
        public List<? extends PatternDescriptor> list() {
            List<? extends PatternDescriptor> list = this.list;
            if (list == null) {
                PatternDeconstructionDescriptor.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$PatternDeconstructionDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$PatternDeconstructionDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class RecordExhaustivenessResult {
        private final boolean isExhaustive;
        private final boolean canBeAdded;
        private final Map<PsiType, Set<List<PsiType>>> missedBranchesByType = new HashMap<PsiType, Set<List<PsiType>>>();

        private RecordExhaustivenessResult(boolean exhaustive, boolean added) {
            this.isExhaustive = exhaustive;
            this.canBeAdded = added;
        }

        public Map<PsiType, Set<List<PsiType>>> getMissedBranchesByType() {
            HashMap<PsiType, Set<List<PsiType>>> result = new HashMap<PsiType, Set<List<PsiType>>>();
            for (Map.Entry<PsiType, Set<List<PsiType>>> missedBranches : this.missedBranchesByType.entrySet()) {
                HashSet<ArrayList<PsiType>> branchSet = new HashSet<ArrayList<PsiType>>();
                for (List<PsiType> missedBranch : missedBranches.getValue()) {
                    ArrayList<PsiType> revertMissedBranch = new ArrayList<PsiType>(missedBranch);
                    Collections.reverse(revertMissedBranch);
                    branchSet.add(revertMissedBranch);
                }
                result.put(missedBranches.getKey(), branchSet);
            }
            return result;
        }

        public boolean isExhaustive() {
            return this.isExhaustive;
        }

        public boolean canBeAdded() {
            return this.canBeAdded;
        }

        void addBranches(List<? extends PatternDescriptor> patterns) {
            for (PatternDescriptor patternDescriptor : patterns) {
                if (!(patternDescriptor instanceof PatternDeconstructionDescriptor)) continue;
                PatternDeconstructionDescriptor deconstructionDescription = (PatternDeconstructionDescriptor)patternDescriptor;
                HashSet deconstructions = new HashSet();
                ArrayList componentTypes = new ArrayList(ContainerUtil.map(deconstructionDescription.list(), t -> t.type()));
                Collections.reverse(componentTypes);
                deconstructions.add(componentTypes);
                this.missedBranchesByType.merge(patternDescriptor.type(), deconstructions, (lists1, lists2) -> {
                    HashSet results = new HashSet();
                    results.addAll(lists1);
                    results.addAll(lists2);
                    return results;
                });
            }
        }

        @NotNull
        private static RecordExhaustivenessResult createExhaustiveResult() {
            return new RecordExhaustivenessResult(true, true);
        }

        @NotNull
        private static RecordExhaustivenessResult createNotExhaustiveResult() {
            return new RecordExhaustivenessResult(false, true);
        }

        @NotNull
        private static RecordExhaustivenessResult createNotBeAdded() {
            return new RecordExhaustivenessResult(false, false);
        }
    }

    private static final class ReduceResultCacheContext {
        @NotNull
        private final PsiType mySelectorType;
        @Nullable
        private final PsiClass myPsiClass;
        @NotNull
        private final Set<? extends PatternDescriptor> currentPatterns;

        ReduceResultCacheContext(@NotNull PsiType selectorType, @NotNull Set<? extends PatternDescriptor> currentPatterns) {
            if (selectorType == null) {
                ReduceResultCacheContext.$$$reportNull$$$0(0);
            }
            if (currentPatterns == null) {
                ReduceResultCacheContext.$$$reportNull$$$0(1);
            }
            this.mySelectorType = selectorType;
            this.currentPatterns = currentPatterns;
            this.myPsiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)selectorType);
        }

        @NotNull
        private ReduceResult reduceClassesInner(@NotNull PsiElement context) {
            if (context == null) {
                ReduceResultCacheContext.$$$reportNull$$$0(2);
            }
            Set typeTestDescriptions = StreamEx.of(this.currentPatterns).select(PatternTypeTestDescriptor.class).toSet();
            HashSet<PatternTypeTestDescriptor> toAdd = new HashSet<PatternTypeTestDescriptor>();
            Set existedTypes = StreamEx.of((Collection)typeTestDescriptions).map(t -> t.type()).toSet();
            Set<PsiClass> visitedCovered = JavaPatternExhaustivenessUtil.findMissedClassesData(this.mySelectorType, new ArrayList(typeTestDescriptions), List.of(), context).coveredClasses();
            boolean changed = JavaPatternExhaustivenessUtil.addNewClasses(context, this.mySelectorType, visitedCovered, existedTypes, toAdd);
            if (!changed) {
                return new ReduceResult(this.currentPatterns, false);
            }
            Set<PatternDescriptor> newPatterns = JavaPatternExhaustivenessUtil.combineResult(this.currentPatterns, Set.of(), toAdd);
            if (newPatterns.size() == this.currentPatterns.size()) {
                return new ReduceResult(this.currentPatterns, false);
            }
            return new ReduceResult(newPatterns, true);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ReduceResultCacheContext that = (ReduceResultCacheContext)obj;
            if (this.myPsiClass != null && that.myPsiClass != null && !this.myPsiClass.hasTypeParameters() ? !Objects.equals(this.myPsiClass, that.myPsiClass) : !Objects.equals(this.mySelectorType, that.mySelectorType)) {
                return false;
            }
            return Objects.equals(this.currentPatterns, that.currentPatterns);
        }

        public int hashCode() {
            return Objects.hash(this.mySelectorType, this.currentPatterns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentPatterns";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceResultCacheContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reduceClassesInner";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static sealed interface PatternDescriptor
    permits PatternDeconstructionDescriptor, PatternTypeTestDescriptor {
        @NotNull
        public PsiType type();
    }

    private static final class PatternTypeTestDescriptor
    extends Record
    implements PatternDescriptor {
        @NotNull
        private final PsiType type;
        @Nullable
        private final PsiClass psiClass;

        PatternTypeTestDescriptor(@NotNull PsiType type) {
            if (type == null) {
                PatternTypeTestDescriptor.$$$reportNull$$$0(0);
            }
            this(type, PsiUtil.resolveClassInClassTypeOnly((PsiType)type));
        }

        private PatternTypeTestDescriptor(@NotNull PsiType type, @Nullable PsiClass psiClass) {
            if (type == null) {
                PatternTypeTestDescriptor.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.psiClass = psiClass;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PatternTypeTestDescriptor that = (PatternTypeTestDescriptor)obj;
            if (this.psiClass != null && that.psiClass != null && !this.psiClass.hasTypeParameters()) {
                return Objects.equals(this.psiClass, that.psiClass);
            }
            return Objects.equals(this.type, that.type);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type);
        }

        @Override
        public String toString() {
            return "PatternTypeTestDescription[type=" + String.valueOf(this.type) + "]";
        }

        @Override
        @NotNull
        public PsiType type() {
            PsiType psiType = this.type;
            if (psiType == null) {
                PatternTypeTestDescriptor.$$$reportNull$$$0(2);
            }
            return psiType;
        }

        @Nullable
        public PsiClass psiClass() {
            return this.psiClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$PatternTypeTestDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$PatternTypeTestDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private record ReduceCache(@NotNull Map<ReduceResultCacheContext, ReduceResult> loopReduceCache, @NotNull Map<ReduceUnwrapContext, ReduceResult> unwrapCache, @NotNull Map<PsiClass, Map<PsiClass, Boolean>> sealedPath) {
        @NotNull
        private final Map<ReduceResultCacheContext, ReduceResult> loopReduceCache;
        @NotNull
        private final Map<ReduceUnwrapContext, ReduceResult> unwrapCache;
        @NotNull
        private final Map<PsiClass, Map<PsiClass, Boolean>> sealedPath;

        private ReduceCache(@NotNull Map<ReduceResultCacheContext, ReduceResult> loopReduceCache, @NotNull Map<ReduceUnwrapContext, ReduceResult> unwrapCache, @NotNull Map<PsiClass, Map<PsiClass, Boolean>> sealedPath) {
            if (loopReduceCache == null) {
                ReduceCache.$$$reportNull$$$0(0);
            }
            if (unwrapCache == null) {
                ReduceCache.$$$reportNull$$$0(1);
            }
            if (sealedPath == null) {
                ReduceCache.$$$reportNull$$$0(2);
            }
        }

        static ReduceCache init() {
            return new ReduceCache(new HashMap<ReduceResultCacheContext, ReduceResult>(), new HashMap<ReduceUnwrapContext, ReduceResult>(), new HashMap<PsiClass, Map<PsiClass, Boolean>>());
        }

        @NotNull
        public Map<ReduceResultCacheContext, ReduceResult> loopReduceCache() {
            Map<ReduceResultCacheContext, ReduceResult> map = this.loopReduceCache;
            if (map == null) {
                ReduceCache.$$$reportNull$$$0(3);
            }
            return map;
        }

        @NotNull
        public Map<ReduceUnwrapContext, ReduceResult> unwrapCache() {
            Map<ReduceUnwrapContext, ReduceResult> map = this.unwrapCache;
            if (map == null) {
                ReduceCache.$$$reportNull$$$0(4);
            }
            return map;
        }

        @NotNull
        public Map<PsiClass, Map<PsiClass, Boolean>> sealedPath() {
            Map<PsiClass, Map<PsiClass, Boolean>> map = this.sealedPath;
            if (map == null) {
                ReduceCache.$$$reportNull$$$0(5);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loopReduceCache";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unwrapCache";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sealedPath";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceCache";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "loopReduceCache";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrapCache";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sealedPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    private record LoopReduceResult(@NotNull Set<? extends PatternDescriptor> patterns, boolean changed, boolean stopped) {
        @NotNull
        private final Set<? extends PatternDescriptor> patterns;

        private LoopReduceResult(@NotNull Set<? extends PatternDescriptor> patterns, boolean changed, boolean stopped) {
            if (patterns == null) {
                LoopReduceResult.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public Set<? extends PatternDescriptor> patterns() {
            Set<? extends PatternDescriptor> set = this.patterns;
            if (set == null) {
                LoopReduceResult.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$LoopReduceResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$LoopReduceResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record ReduceResult(@NotNull Set<? extends PatternDescriptor> patterns, boolean changed) {
        @NotNull
        private final Set<? extends PatternDescriptor> patterns;

        private ReduceResult(@NotNull Set<? extends PatternDescriptor> patterns, boolean changed) {
            if (patterns == null) {
                ReduceResult.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        private ReduceResult reduceRecordPatterns(@NotNull PsiElement context, @NotNull ReduceCache cache) {
            if (context == null) {
                ReduceResult.$$$reportNull$$$0(1);
            }
            if (cache == null) {
                ReduceResult.$$$reportNull$$$0(2);
            }
            boolean changed = false;
            Map byType = StreamEx.of(this.patterns).select(PatternDeconstructionDescriptor.class).groupingBy(t -> t.type(), Collectors.toSet());
            HashSet toRemove = new HashSet();
            HashSet<PatternDeconstructionDescriptor> toAdd = new HashSet<PatternDeconstructionDescriptor>();
            HashMap<PsiType, List<PsiType>> componentCaches = new HashMap<PsiType, List<PsiType>>();
            for (Map.Entry entry : byType.entrySet()) {
                Set descriptions = (Set)entry.getValue();
                if (descriptions.isEmpty()) continue;
                PatternDeconstructionDescriptor first = (PatternDeconstructionDescriptor)descriptions.iterator().next();
                for (int i = 0; i < first.list().size(); ++i) {
                    MultiMap<List<PatternDescriptor>, PatternDeconstructionDescriptor> groupWithoutOneComponent = JavaPatternExhaustivenessUtil.getGroupWithoutOneComponent(descriptions, i);
                    for (Map.Entry value : groupWithoutOneComponent.entrySet()) {
                        LoopReduceResult result;
                        Collection setWithOneDifferentElement = (Collection)value.getValue();
                        if (setWithOneDifferentElement.isEmpty()) continue;
                        int finalI = i;
                        Set nestedDescriptions = setWithOneDifferentElement.stream().map(t -> t.list().get(finalI)).collect(Collectors.toSet());
                        PsiType recordType = (PsiType)entry.getKey();
                        List<PsiType> componentTypes = (List<PsiType>)componentCaches.get(recordType);
                        if (componentTypes == null) {
                            componentTypes = JavaPatternExhaustivenessUtil.getComponentTypes(context, recordType);
                            componentCaches.put(recordType, componentTypes);
                        }
                        if (componentTypes == null || componentTypes.size() <= i || !(result = JavaPatternExhaustivenessUtil.reduceInLoop(componentTypes.get(i), context, nestedDescriptions, (set, type) -> false, cache, true)).changed()) continue;
                        changed = true;
                        toRemove.addAll(setWithOneDifferentElement);
                        toAdd.addAll(ReduceResult.createPatternsFrom(i, result.patterns(), (PatternDeconstructionDescriptor)setWithOneDifferentElement.iterator().next()));
                    }
                }
            }
            if (!changed) {
                return new ReduceResult(this.patterns, this.changed());
            }
            return new ReduceResult(JavaPatternExhaustivenessUtil.combineResult(this.patterns, toRemove, toAdd), true);
        }

        @NotNull
        private static Collection<PatternDeconstructionDescriptor> createPatternsFrom(int differentElement, @NotNull Set<? extends PatternDescriptor> nestedPatterns, @NotNull PatternDeconstructionDescriptor sample) {
            if (nestedPatterns == null) {
                ReduceResult.$$$reportNull$$$0(3);
            }
            if (sample == null) {
                ReduceResult.$$$reportNull$$$0(4);
            }
            HashSet<PatternDeconstructionDescriptor> descriptions = new HashSet<PatternDeconstructionDescriptor>();
            for (PatternDescriptor patternDescriptor : nestedPatterns) {
                descriptions.add(sample.createFor(differentElement, patternDescriptor));
            }
            HashSet<PatternDeconstructionDescriptor> hashSet = descriptions;
            if (hashSet == null) {
                ReduceResult.$$$reportNull$$$0(5);
            }
            return hashSet;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        private ReduceResult reduceDeconstructionRecordToTypePattern(@NotNull PsiElement context) {
            if (context == null) {
                ReduceResult.$$$reportNull$$$0(6);
            }
            boolean changed = false;
            HashMap<PsiType, List<PsiType>> componentCache = new HashMap<PsiType, List<PsiType>>();
            HashSet<PatternTypeTestDescriptor> toAdd = new HashSet<PatternTypeTestDescriptor>();
            HashSet toRemove = new HashSet();
            Map groupedByType = StreamEx.of(this.patterns).select(PatternDeconstructionDescriptor.class).groupingBy(t -> t.type(), Collectors.toSet());
            block0: for (Map.Entry entry : groupedByType.entrySet()) {
                for (PatternDeconstructionDescriptor patternDeconstructionDescription : (Set)entry.getValue()) {
                    void var13_13;
                    ArrayList<PsiType> descriptionTypes = new ArrayList<PsiType>();
                    for (PatternDescriptor patternDescriptor : patternDeconstructionDescription.list()) {
                        if (!(patternDescriptor instanceof PatternTypeTestDescriptor)) continue;
                        PatternTypeTestDescriptor patternTypeTestDescription = (PatternTypeTestDescriptor)patternDescriptor;
                        descriptionTypes.add(patternTypeTestDescription.type());
                    }
                    PsiType descriptionType = patternDeconstructionDescription.type();
                    List list = (List)componentCache.get(descriptionType);
                    if (list == null) {
                        List<PsiType> recordTypes = JavaPatternExhaustivenessUtil.getComponentTypes(context, descriptionType);
                        if (recordTypes == null) continue;
                        componentCache.put(descriptionType, recordTypes);
                        List<PsiType> list2 = recordTypes;
                    }
                    if (var13_13.size() != descriptionTypes.size()) continue;
                    boolean allCovered = true;
                    for (int i = 0; i < var13_13.size(); ++i) {
                        PsiType recordComponentType = (PsiType)var13_13.get(i);
                        PsiType descriptionComponentType = (PsiType)descriptionTypes.get(i);
                        if (JavaPsiPatternUtil.covers((PsiElement)context, (PsiType)descriptionComponentType, (PsiType)recordComponentType)) continue;
                        allCovered = false;
                        break;
                    }
                    if (!allCovered) continue;
                    changed = true;
                    toAdd.add(new PatternTypeTestDescriptor(descriptionType));
                    toRemove.addAll((Collection)entry.getValue());
                    continue block0;
                }
            }
            if (!changed) {
                return new ReduceResult(this.patterns, this.changed());
            }
            Set<PatternDescriptor> result = JavaPatternExhaustivenessUtil.combineResult(this.patterns, toRemove, toAdd);
            return new ReduceResult(result, true);
        }

        @NotNull
        private ReduceResult reduceClasses(@NotNull PsiType selectorType, @NotNull PsiElement context) {
            Set consideredDescription;
            if (selectorType == null) {
                ReduceResult.$$$reportNull$$$0(7);
            }
            if (context == null) {
                ReduceResult.$$$reportNull$$$0(8);
            }
            if ((consideredDescription = (Set)StreamEx.of(this.patterns).select(PatternTypeTestDescriptor.class).collect(Collectors.toSet())).isEmpty()) {
                return new ReduceResult(this.patterns, this.changed());
            }
            ReduceResult result = (ReduceResult)((Map)CachedValuesManager.getCachedValue((PsiElement)context, () -> {
                ConcurrentMap map = ConcurrentFactoryMap.createMap(reduceContext -> reduceContext.reduceClassesInner(context));
                return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            })).get(new ReduceResultCacheContext(selectorType, this.patterns));
            ReduceResult reduceResult = !result.changed() ? this : result;
            if (reduceResult == null) {
                ReduceResult.$$$reportNull$$$0(9);
            }
            return reduceResult;
        }

        @NotNull
        public Set<? extends PatternDescriptor> patterns() {
            Set<? extends PatternDescriptor> set = this.patterns;
            if (set == null) {
                ReduceResult.$$$reportNull$$$0(10);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 1: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cache";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nestedPatterns";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sample";
                    break;
                }
                case 5: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceResult";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectorType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPatternsFrom";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reduceClasses";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "patterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "reduceRecordPatterns";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createPatternsFrom";
                    break;
                }
                case 5: 
                case 9: 
                case 10: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "reduceDeconstructionRecordToTypePattern";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "reduceClasses";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    private record ReduceUnwrapContext(@NotNull Set<PatternDeconstructionDescriptor> currentPatterns) {
        @NotNull
        private final Set<PatternDeconstructionDescriptor> currentPatterns;

        private ReduceUnwrapContext(@NotNull Set<PatternDeconstructionDescriptor> currentPatterns) {
            if (currentPatterns == null) {
                ReduceUnwrapContext.$$$reportNull$$$0(0);
            }
        }

        @NotNull
        public Set<PatternDeconstructionDescriptor> currentPatterns() {
            Set<PatternDeconstructionDescriptor> set = this.currentPatterns;
            if (set == null) {
                ReduceUnwrapContext.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentPatterns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceUnwrapContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$ReduceUnwrapContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "currentPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private record SealedResult(@NotNull Set<PsiClass> missedClasses, @NotNull Set<PsiClass> coveredClasses) {
        @NotNull
        private final Set<PsiClass> missedClasses;
        @NotNull
        private final Set<PsiClass> coveredClasses;

        private SealedResult(@NotNull Set<PsiClass> missedClasses, @NotNull Set<PsiClass> coveredClasses) {
            if (missedClasses == null) {
                SealedResult.$$$reportNull$$$0(0);
            }
            if (coveredClasses == null) {
                SealedResult.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public Set<PsiClass> missedClasses() {
            Set<PsiClass> set = this.missedClasses;
            if (set == null) {
                SealedResult.$$$reportNull$$$0(2);
            }
            return set;
        }

        @NotNull
        public Set<PsiClass> coveredClasses() {
            Set<PsiClass> set = this.coveredClasses;
            if (set == null) {
                SealedResult.$$$reportNull$$$0(3);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missedClasses";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coveredClasses";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$SealedResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/java/codeserver/core/JavaPatternExhaustivenessUtil$SealedResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "missedClasses";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "coveredClasses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

