/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiImplUtil;
import java.lang.annotation.RetentionPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiAnnotationUtil {
    private JavaPsiAnnotationUtil() {
    }

    @Nullable
    public static RetentionPolicy getRetentionPolicy(@NotNull PsiClass annotation) {
        PsiModifierList modifierList;
        if (annotation == null) {
            JavaPsiAnnotationUtil.$$$reportNull$$$0(0);
        }
        if ((modifierList = annotation.getModifierList()) != null) {
            PsiReference ref;
            PsiElement field;
            PsiAnnotation retentionAnno = modifierList.findAnnotation("java.lang.annotation.Retention");
            if (retentionAnno == null) {
                return RetentionPolicy.CLASS;
            }
            PsiAnnotationMemberValue policyRef = PsiImplUtil.findAttributeValue((PsiAnnotation)retentionAnno, null);
            if (policyRef instanceof PsiReference && (field = (ref = (PsiReference)policyRef).resolve()) instanceof PsiEnumConstant) {
                PsiEnumConstant constant = (PsiEnumConstant)field;
                String name = constant.getName();
                try {
                    return Enum.valueOf(RetentionPolicy.class, name);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static void processPackageAnnotations(@NotNull PsiFile file, @NotNull PackageAnnotationProcessor processor, boolean processSuperPackages) {
        if (file == null) {
            JavaPsiAnnotationUtil.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JavaPsiAnnotationUtil.$$$reportNull$$$0(2);
        }
        boolean superPackage = false;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            return;
        }
        VirtualFile root = index.getSourceRootForFile(vFile);
        boolean compiled = false;
        if (root == null) {
            root = index.getClassRootForFile(vFile);
            if (root == null) {
                return;
            }
            compiled = true;
        }
        if (root.equals(vFile)) {
            return;
        }
        for (PsiDirectory directory = file.getContainingDirectory(); directory != null; directory = directory.getParentDirectory()) {
            PsiModifierList modifierList;
            PsiJavaFile javaFile;
            PsiPackageStatement stmt;
            PsiFile packageFile = directory.findFile(compiled ? "package-info.class" : "package-info.java");
            if (packageFile instanceof PsiJavaFile && (stmt = (javaFile = (PsiJavaFile)packageFile).getPackageStatement()) != null && (modifierList = stmt.getAnnotationList()) != null) {
                for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                    processor.process(annotation, superPackage);
                }
            }
            if (!processSuperPackages || root.equals(directory.getVirtualFile())) break;
            superPackage = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiAnnotationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRetentionPolicy";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processPackageAnnotations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface PackageAnnotationProcessor {
        public void process(@NotNull PsiAnnotation var1, boolean var2);
    }
}

