/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiModifierUtil {
    private static final Map<String, Set<String>> ourInterfaceIncompatibleModifiers = Map.of("abstract", Set.of(), "packageLocal", Set.of("private", "public", "protected"), "private", Set.of("packageLocal", "public", "protected"), "public", Set.of("packageLocal", "private", "protected"), "protected", Set.of("packageLocal", "public", "private"), "strictfp", Set.of(), "static", Set.of(), "sealed", Set.of("non-sealed"), "non-sealed", Set.of("sealed"));
    private static final Map<String, Set<String>> ourMethodIncompatibleModifiers = Map.ofEntries(Map.entry("abstract", Set.of("native", "static", "final", "private", "strictfp", "synchronized", "default")), Map.entry("native", Set.of("abstract", "strictfp")), Map.entry("packageLocal", Set.of("private", "public", "protected")), Map.entry("private", Set.of("packageLocal", "public", "protected")), Map.entry("public", Set.of("packageLocal", "private", "protected")), Map.entry("protected", Set.of("packageLocal", "public", "private")), Map.entry("static", Set.of("abstract", "default")), Map.entry("default", Set.of("abstract", "static", "private")), Map.entry("synchronized", Set.of("abstract")), Map.entry("strictfp", Set.of("abstract")), Map.entry("final", Set.of("abstract")));
    private static final Map<String, Set<String>> ourFieldIncompatibleModifiers = Map.of("final", Set.of("volatile"), "packageLocal", Set.of("private", "public", "protected"), "private", Set.of("packageLocal", "public", "protected"), "public", Set.of("packageLocal", "private", "protected"), "protected", Set.of("packageLocal", "public", "private"), "static", Set.of(), "transient", Set.of(), "volatile", Set.of("final"));
    private static final Map<String, Set<String>> ourClassIncompatibleModifiers = Map.ofEntries(Map.entry("abstract", Set.of("final")), Map.entry("final", Set.of("abstract", "sealed", "non-sealed")), Map.entry("packageLocal", Set.of("private", "public", "protected")), Map.entry("private", Set.of("packageLocal", "public", "protected")), Map.entry("public", Set.of("packageLocal", "private", "protected")), Map.entry("protected", Set.of("packageLocal", "public", "private")), Map.entry("strictfp", Set.of()), Map.entry("static", Set.of()), Map.entry("sealed", Set.of("final", "non-sealed")), Map.entry("non-sealed", Set.of("final", "sealed")), Map.entry("value", Set.of()));
    private static final Map<String, Set<String>> ourClassInitializerIncompatibleModifiers = Map.of("static", Set.of());
    private static final Map<String, Set<String>> ourModuleIncompatibleModifiers = Map.of("open", Set.of());
    private static final Map<String, Set<String>> ourRequiresIncompatibleModifiers = Map.of("static", Set.of(), "transitive", Set.of());

    private JavaPsiModifierUtil() {
    }

    private static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList, @NotNull Map<String, Set<String>> incompatibleModifiersHash) {
        if (modifier == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(0);
        }
        if (modifierList == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(1);
        }
        if (incompatibleModifiersHash == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(2);
        }
        int modifierCount = 0;
        for (PsiElement otherModifier = modifierList.getFirstChild(); otherModifier != null; otherModifier = otherModifier.getNextSibling()) {
            if (!modifier.equals(otherModifier.getText())) continue;
            ++modifierCount;
        }
        if (modifierCount > 1) {
            return modifier;
        }
        Set<String> incompatibles = incompatibleModifiersHash.get(modifier);
        if (incompatibles == null) {
            return null;
        }
        PsiElement parent = modifierList.getParent();
        boolean level8OrHigher = PsiUtil.isLanguageLevel8OrHigher((PsiElement)modifierList);
        boolean level9OrHigher = PsiUtil.isLanguageLevel9OrHigher((PsiElement)modifierList);
        for (String incompatible : incompatibles) {
            PsiClass containingClass;
            if (level8OrHigher && modifier.equals("static") && incompatible.equals("abstract") || parent instanceof PsiMethod && (level9OrHigher && modifier.equals("private") && incompatible.equals("public") || modifier.equals("static") && incompatible.equals("final") && ((containingClass = ((PsiMethod)parent).getContainingClass()) == null || !containingClass.isInterface()))) continue;
            if (modifierList.hasModifierProperty(incompatible)) {
                return incompatible;
            }
            if (!"abstract".equals(incompatible) || !modifierList.hasExplicitModifier(incompatible)) continue;
            return incompatible;
        }
        return null;
    }

    public static boolean isLegalModifierCombination(@NotNull PsiModifierList modifierList) {
        if (modifierList == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(3);
        }
        for (PsiElement child = modifierList.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PsiKeyword) || JavaPsiModifierUtil.getIncompatibleModifier(child.getText(), modifierList) == null) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Set<String>> getIncompatibleModifierMap(@NotNull PsiElement modifierListOwner) {
        if (modifierListOwner == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(4);
        }
        if (PsiUtilCore.hasErrorElementChild((PsiElement)modifierListOwner)) {
            return null;
        }
        if (modifierListOwner instanceof PsiClass) {
            return ((PsiClass)modifierListOwner).isInterface() ? ourInterfaceIncompatibleModifiers : ourClassIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiMethod) {
            return ourMethodIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiVariable) {
            return ourFieldIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiClassInitializer) {
            return ourClassInitializerIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiJavaModule) {
            return ourModuleIncompatibleModifiers;
        }
        if (modifierListOwner instanceof PsiRequiresStatement) {
            return ourRequiresIncompatibleModifiers;
        }
        return null;
    }

    public static boolean isAllowed(@NotNull String modifier, @NotNull PsiModifierList modifierList) {
        PsiElement parent;
        if (modifier == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(5);
        }
        if (modifierList == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(6);
        }
        if ((parent = modifierList.getParent()) == null) {
            return false;
        }
        Map<String, Set<String>> incompatibleModifierMap = JavaPsiModifierUtil.getIncompatibleModifierMap(parent);
        return incompatibleModifierMap == null || incompatibleModifierMap.containsKey(modifier);
    }

    @Nullable
    public static String getIncompatibleModifier(@NotNull String modifier, @NotNull PsiModifierList modifierList) {
        PsiElement parent;
        if (modifier == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(7);
        }
        if (modifierList == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(8);
        }
        if ((parent = modifierList.getParent()) == null) {
            return null;
        }
        Map<String, Set<String>> incompatibleModifierMap = JavaPsiModifierUtil.getIncompatibleModifierMap(parent);
        return incompatibleModifierMap == null ? null : JavaPsiModifierUtil.getIncompatibleModifier(modifier, modifierList, incompatibleModifierMap);
    }

    @Nullable
    public static PsiClass getPackageLocalClassInTheMiddle(@NotNull PsiElement place) {
        if (place == null) {
            JavaPsiModifierUtil.$$$reportNull$$$0(9);
        }
        if (place instanceof PsiReferenceExpression) {
            PsiReferenceExpression expression = (PsiReferenceExpression)place;
            while (true) {
                PsiClass aClass;
                PsiField field;
                if ((field = (PsiField)ObjectUtils.tryCast((Object)expression.resolve(), PsiField.class)) != null && (aClass = field.getContainingClass()) != null && aClass.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance((Project)aClass.getProject()).arePackagesTheSame((PsiElement)aClass, place)) {
                    return aClass;
                }
                PsiExpression qualifier = expression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) break;
                expression = (PsiReferenceExpression)qualifier;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibleModifiersHash";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiModifierUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIncompatibleModifier";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isLegalModifierCombination";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getIncompatibleModifierMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isAllowed";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageLocalClassInTheMiddle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

