/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;

public final class JavaPsiReferenceUtil {
    private JavaPsiReferenceUtil() {
    }

    @NotNull
    public static ForwardReferenceProblem checkForwardReference(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField, boolean acceptQualified) {
        boolean inStaticContext;
        PsiClass containingClass;
        if (expression == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(0);
        }
        if (referencedField == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(1);
        }
        if ((containingClass = referencedField.getContainingClass()) == null) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(2);
            }
            return forwardReferenceProblem;
        }
        if (expression.getContainingFile() != referencedField.getContainingFile()) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(3);
            }
            return forwardReferenceProblem;
        }
        TextRange fieldRange = referencedField.getTextRange();
        if (fieldRange == null || expression.getTextRange().getStartOffset() >= fieldRange.getEndOffset()) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(4);
            }
            return forwardReferenceProblem;
        }
        if (!acceptQualified) {
            if (containingClass.isEnum()) {
                if (JavaPsiReferenceUtil.isLegalForwardReferenceInEnum(expression, referencedField, containingClass)) {
                    ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
                    if (forwardReferenceProblem == null) {
                        JavaPsiReferenceUtil.$$$reportNull$$$0(5);
                    }
                    return forwardReferenceProblem;
                }
            } else if (expression.getQualifierExpression() != null) {
                ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
                if (forwardReferenceProblem == null) {
                    JavaPsiReferenceUtil.$$$reportNull$$$0(6);
                }
                return forwardReferenceProblem;
            }
        }
        PsiField initField = JavaPsiReferenceUtil.findEnclosingFieldInitializer((PsiElement)expression);
        PsiClassInitializer classInitializer = JavaPsiReferenceUtil.findParentClassInitializer((PsiElement)expression);
        if (initField == null && classInitializer == null) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(7);
            }
            return forwardReferenceProblem;
        }
        boolean isStaticClassInitializer = classInitializer != null && classInitializer.hasModifierProperty("static");
        boolean isStaticInitField = initField != null && initField.hasModifierProperty("static");
        boolean bl = inStaticContext = isStaticInitField || isStaticClassInitializer;
        if (!inStaticContext && referencedField.hasModifierProperty("static")) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(8);
            }
            return forwardReferenceProblem;
        }
        if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression) && !PsiUtil.isAccessedForReading((PsiExpression)expression)) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(9);
            }
            return forwardReferenceProblem;
        }
        if (!containingClass.getManager().areElementsEquivalent((PsiElement)containingClass, PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class))) {
            ForwardReferenceProblem forwardReferenceProblem = ForwardReferenceProblem.LEGAL;
            if (forwardReferenceProblem == null) {
                JavaPsiReferenceUtil.$$$reportNull$$$0(10);
            }
            return forwardReferenceProblem;
        }
        ForwardReferenceProblem forwardReferenceProblem = initField == referencedField ? ForwardReferenceProblem.ILLEGAL_SELF_REFERENCE : ForwardReferenceProblem.ILLEGAL_FORWARD_REFERENCE;
        if (forwardReferenceProblem == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(11);
        }
        return forwardReferenceProblem;
    }

    private static boolean isLegalForwardReferenceInEnum(@NotNull PsiReferenceExpression expression, @NotNull PsiField referencedField, @NotNull PsiClass containingClass) {
        PsiExpression qualifierExpr;
        if (expression == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(12);
        }
        if (referencedField == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(13);
        }
        if (containingClass == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(14);
        }
        if ((qualifierExpr = expression.getQualifierExpression()) == null) {
            return false;
        }
        if (!(qualifierExpr instanceof PsiReferenceExpression)) {
            return true;
        }
        PsiElement qualifiedReference = ((PsiReferenceExpression)qualifierExpr).resolve();
        if (containingClass.equals((Object)qualifiedReference)) {
            return PsiUtil.isCompileTimeConstant((PsiVariable)referencedField);
        }
        return true;
    }

    private static PsiField findEnclosingFieldInitializer(@NotNull PsiElement entry) {
        if (entry == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(15);
        }
        PsiElement element = entry;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                if (element == ((PsiField)parent).getInitializer()) {
                    return (PsiField)parent;
                }
                if (parent instanceof PsiEnumConstant && element == ((PsiEnumConstant)parent).getArgumentList()) {
                    return (PsiField)parent;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    private static PsiClassInitializer findParentClassInitializer(@NotNull PsiElement root) {
        if (root == null) {
            JavaPsiReferenceUtil.$$$reportNull$$$0(16);
        }
        for (PsiElement element = root; element != null; element = element.getParent()) {
            if (element instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)element;
                return initializer;
            }
            if (!(element instanceof PsiClass) && !(element instanceof PsiMethod)) continue;
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedField";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiReferenceUtil";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiReferenceUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "checkForwardReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkForwardReference";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isLegalForwardReferenceInEnum";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingFieldInitializer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findParentClassInitializer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    public static enum ForwardReferenceProblem {
        LEGAL,
        ILLEGAL_SELF_REFERENCE,
        ILLEGAL_FORWARD_REFERENCE;

    }
}

