/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.ui.timeline;

import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceLabelEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceMilestoneEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabResourceStateEventDTO;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestDiscussion;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabMergeRequestNote;
import org.jetbrains.plugins.gitlab.mergerequest.data.GitLabNote;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0007\n\u000b\f\r\u000e\u000f\u0010R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u0082\u0001\u0003\u0011\u0012\u0013\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem;", "", "id", "", "getId", "()Ljava/lang/String;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "Immutable", "StateEvent", "LabelEvent", "MilestoneEvent", "SystemNote", "DraftNote", "UserDiscussion", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$DraftNote;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$UserDiscussion;", "intellij.vcs.gitlab"})
public sealed interface GitLabMergeRequestTimelineItem {
    @NotNull
    public String getId();

    @Nullable
    public Date getDate();

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$DraftNote;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem;", "note", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestNote;", "<init>", "(Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestNote;)V", "getNote", "()Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestNote;", "id", "", "getId", "()Ljava/lang/String;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.vcs.gitlab"})
    public static final class DraftNote
    implements GitLabMergeRequestTimelineItem {
        @NotNull
        private final GitLabMergeRequestNote note;
        @NotNull
        private final String id;
        @Nullable
        private final Date date;

        public DraftNote(@NotNull GitLabMergeRequestNote note2) {
            Intrinsics.checkNotNullParameter((Object)note2, (String)"note");
            this.note = note2;
            this.id = this.note.getId().toString();
            this.date = this.note.getCreatedAt();
        }

        @NotNull
        public final GitLabMergeRequestNote getNote() {
            return this.note;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @Nullable
        public Date getDate() {
            return this.date;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem;", "actor", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getActor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$LabelEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$MilestoneEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$StateEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$SystemNote;", "intellij.vcs.gitlab"})
    public static sealed interface Immutable
    extends GitLabMergeRequestTimelineItem
    permits LabelEvent, MilestoneEvent, StateEvent, SystemNote {
        @NotNull
        public GitLabUserDTO getActor();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$LabelEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "event", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceLabelEventDTO;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceLabelEventDTO;)V", "getEvent", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceLabelEventDTO;", "id", "", "getId", "()Ljava/lang/String;", "actor", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getActor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.vcs.gitlab"})
    public static final class LabelEvent
    implements Immutable {
        @NotNull
        private final GitLabResourceLabelEventDTO event;
        @NotNull
        private final String id;
        @NotNull
        private final GitLabUserDTO actor;
        @NotNull
        private final Date date;

        public LabelEvent(@NotNull GitLabResourceLabelEventDTO event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.id = "LabelEvent:" + this.event.getId();
            this.actor = this.event.getUser();
            this.date = this.event.getCreatedAt();
        }

        @NotNull
        public final GitLabResourceLabelEventDTO getEvent() {
            return this.event;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public GitLabUserDTO getActor() {
            return this.actor;
        }

        @Override
        @NotNull
        public Date getDate() {
            return this.date;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$MilestoneEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "event", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceMilestoneEventDTO;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceMilestoneEventDTO;)V", "getEvent", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceMilestoneEventDTO;", "id", "", "getId", "()Ljava/lang/String;", "actor", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getActor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.vcs.gitlab"})
    public static final class MilestoneEvent
    implements Immutable {
        @NotNull
        private final GitLabResourceMilestoneEventDTO event;
        @NotNull
        private final String id;
        @NotNull
        private final GitLabUserDTO actor;
        @NotNull
        private final Date date;

        public MilestoneEvent(@NotNull GitLabResourceMilestoneEventDTO event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.id = "MilestoneEvent:" + this.event.getId();
            this.actor = this.event.getUser();
            this.date = this.event.getCreatedAt();
        }

        @NotNull
        public final GitLabResourceMilestoneEventDTO getEvent() {
            return this.event;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public GitLabUserDTO getActor() {
            return this.actor;
        }

        @Override
        @NotNull
        public Date getDate() {
            return this.date;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$StateEvent;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "event", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceStateEventDTO;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceStateEventDTO;)V", "getEvent", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabResourceStateEventDTO;", "id", "", "getId", "()Ljava/lang/String;", "actor", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getActor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.vcs.gitlab"})
    public static final class StateEvent
    implements Immutable {
        @NotNull
        private final GitLabResourceStateEventDTO event;
        @NotNull
        private final String id;
        @NotNull
        private final GitLabUserDTO actor;
        @NotNull
        private final Date date;

        public StateEvent(@NotNull GitLabResourceStateEventDTO event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.id = "StateEvent:" + this.event.getId();
            this.actor = this.event.getUser();
            this.date = this.event.getCreatedAt();
        }

        @NotNull
        public final GitLabResourceStateEventDTO getEvent() {
            return this.event;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public GitLabUserDTO getActor() {
            return this.actor;
        }

        @Override
        @NotNull
        public Date getDate() {
            return this.date;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$SystemNote;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$Immutable;", "note", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNote;", "<init>", "(Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabNote;)V", "id", "", "getId", "()Ljava/lang/String;", "actor", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "getActor", "()Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "content", "getContent", "intellij.vcs.gitlab"})
    public static final class SystemNote
    implements Immutable {
        @NotNull
        private final String id;
        @NotNull
        private final GitLabUserDTO actor;
        @Nullable
        private final Date date;
        @NotNull
        private final String content;

        public SystemNote(@NotNull GitLabNote note2) {
            Intrinsics.checkNotNullParameter((Object)note2, (String)"note");
            this.id = note2.getId().toString();
            this.actor = note2.getAuthor();
            this.date = note2.getCreatedAt();
            this.content = (String)note2.getBody().getValue();
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public GitLabUserDTO getActor() {
            return this.actor;
        }

        @Override
        @Nullable
        public Date getDate() {
            return this.date;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem$UserDiscussion;", "Lorg/jetbrains/plugins/gitlab/mergerequest/ui/timeline/GitLabMergeRequestTimelineItem;", "discussion", "Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDiscussion;", "<init>", "(Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDiscussion;)V", "getDiscussion", "()Lorg/jetbrains/plugins/gitlab/mergerequest/data/GitLabMergeRequestDiscussion;", "id", "", "getId", "()Ljava/lang/String;", "date", "Ljava/util/Date;", "getDate", "()Ljava/util/Date;", "intellij.vcs.gitlab"})
    public static final class UserDiscussion
    implements GitLabMergeRequestTimelineItem {
        @NotNull
        private final GitLabMergeRequestDiscussion discussion;
        @NotNull
        private final String id;
        @NotNull
        private final Date date;

        public UserDiscussion(@NotNull GitLabMergeRequestDiscussion discussion) {
            Intrinsics.checkNotNullParameter((Object)discussion, (String)"discussion");
            this.discussion = discussion;
            this.id = this.discussion.getId().toString();
            this.date = this.discussion.getCreatedAt();
        }

        @NotNull
        public final GitLabMergeRequestDiscussion getDiscussion() {
            return this.discussion;
        }

        @Override
        @NotNull
        public String getId() {
            return this.id;
        }

        @Override
        @NotNull
        public Date getDate() {
            return this.date;
        }
    }
}

