/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.errors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.utils.CommonRegexPattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Error
extends Message {
    private static final Logger LOGGER = LoggerFactory.getLogger(Error.class);

    public Error() {
    }

    public Error(String _dest, String _errorName, long _replyserial, String _sig, Object ... _args) throws DBusException {
        this(null, _dest, _errorName, _replyserial, _sig, _args);
    }

    public Error(String _source, String _dest, String _errorName, long _replyserial, String _sig, Object ... _args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)3, (byte)0);
        if (null == _errorName) {
            throw new MessageFormatException("Must specify error name to Errors.");
        }
        ArrayList<Object> hargs = new ArrayList<Object>();
        hargs.add(this.createHeaderArgs((byte)4, "s", _errorName));
        hargs.add(this.createHeaderArgs((byte)5, "u", _replyserial));
        if (null != _source) {
            hargs.add(this.createHeaderArgs((byte)7, "s", _source));
        }
        if (null != _dest) {
            hargs.add(this.createHeaderArgs((byte)6, "s", _dest));
        }
        if (null != _sig) {
            hargs.add(this.createHeaderArgs((byte)8, "g", _sig));
            this.setArgs(_args);
        }
        this.padAndMarshall(hargs, this.getSerial(), _sig, _args);
    }

    public Error(String _source, Message _m, Throwable _ex) throws DBusException {
        this(_source, _m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(_ex.getClass().getName()).replaceAll("."), _m.getSerial(), "s", _ex.getMessage());
    }

    public Error(Message _m, Throwable _ex) throws DBusException {
        this(_m.getSource(), AbstractConnection.DOLLAR_PATTERN.matcher(_ex.getClass().getName()).replaceAll("."), _m.getSerial(), "s", _ex.getMessage());
    }

    private static Class<? extends DBusExecutionException> createExceptionClass(String _name) {
        Class<?> c = null;
        if (_name.startsWith("org.freedesktop.DBus.Error.")) {
            _name = _name.replace("org.freedesktop.DBus.Error.", "org.freedesktop.dbus.errors.");
        }
        do {
            try {
                c = Class.forName(_name);
            }
            catch (ClassNotFoundException _exCnf) {
                LOGGER.trace("Could not find class for name {}", (Object)_name, (Object)_exCnf);
            }
            _name = CommonRegexPattern.EXCEPTION_EXTRACT_PATTERN.matcher(_name).replaceAll("\\$$1");
        } while (null == c && CommonRegexPattern.EXCEPTION_PARTIAL_PATTERN.matcher(_name).matches());
        return c;
    }

    public DBusExecutionException getException() {
        try {
            Class<? extends DBusExecutionException> c = Error.createExceptionClass(this.getName());
            if (null == c || !DBusExecutionException.class.isAssignableFrom(c)) {
                c = DBusExecutionException.class;
            }
            Constructor<? extends DBusExecutionException> con = c.getConstructor(String.class);
            Object[] args = this.getParameters();
            DBusExecutionException ex = null == args || 0 == args.length ? con.newInstance("") : con.newInstance(Arrays.stream(args).map(Objects::toString).collect(Collectors.joining(" ")).trim());
            ex.setType(this.getName());
            return ex;
        }
        catch (Exception _ex1) {
            this.logger.debug("", (Throwable)_ex1);
            Object[] args = null;
            try {
                args = this.getParameters();
            }
            catch (Exception _ex2) {
                LOGGER.trace("Cannot retrieve parameters", (Throwable)_ex2);
            }
            DBusExecutionException ex = null == args || 0 == args.length ? new DBusExecutionException("") : new DBusExecutionException(Arrays.stream(args).map(Objects::toString).collect(Collectors.joining(" ")).trim());
            ex.setType(this.getName());
            return ex;
        }
    }

    public void throwException() throws DBusExecutionException {
        throw this.getException();
    }
}

