/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.impl;

import com.intellij.execution.wsl.ijent.AbstractIjentVerificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelPlatform;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.platform.ijent.IjentProcessUtil;
import com.intellij.platform.ijent.impl.IjentVerificationActionsKt;
import com.intellij.platform.ijent.spi.IjentConnectionStrategy;
import com.intellij.platform.ijent.spi.IjentControlledEnvironmentDeployingStrategy;
import com.intellij.platform.ijent.spi.IjentDeployingStrategy;
import com.intellij.platform.ijent.spi.IjentSessionProcessMediator;
import com.intellij.util.system.CpuArch;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094@\u00a2\u0006\u0002\u0010\u0012R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/platform/ijent/impl/IjentLocalVerificationAction;", "Lcom/intellij/execution/wsl/ijent/AbstractIjentVerificationAction;", "<init>", "()V", "currentPlatform", "Lcom/intellij/platform/eel/EelPlatform;", "title", "", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "deployingStrategy", "Lkotlin/Triple;", "Lcom/intellij/platform/ijent/spi/IjentDeployingStrategy;", "Lcom/intellij/platform/eel/EelDescriptor;", "ijentProcessScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ijent.impl"})
public final class IjentLocalVerificationAction
extends AbstractIjentVerificationAction {
    @Nullable
    private final EelPlatform currentPlatform;
    @NotNull
    private final String title;

    public IjentLocalVerificationAction() {
        CpuArch cpuArch = CpuArch.CURRENT;
        this.currentPlatform = switch (cpuArch == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cpuArch.ordinal()]) {
            case 1 -> {
                if (SystemInfoRt.isWindows) {
                    yield (EelPlatform)new EelPlatform.Windows(EelUtilsKt.toEelArch((CpuArch)CpuArch.ARM64));
                }
                if (SystemInfoRt.isLinux) {
                    yield (EelPlatform)new EelPlatform.Linux(EelUtilsKt.toEelArch((CpuArch)CpuArch.ARM64));
                }
                if (SystemInfoRt.isMac) {
                    yield (EelPlatform)new EelPlatform.Darwin(EelUtilsKt.toEelArch((CpuArch)CpuArch.ARM64));
                }
                yield null;
            }
            case 2 -> {
                if (SystemInfoRt.isWindows) {
                    yield (EelPlatform)new EelPlatform.Windows(EelUtilsKt.toEelArch((CpuArch)CpuArch.X86_64));
                }
                if (SystemInfoRt.isLinux) {
                    yield (EelPlatform)new EelPlatform.Linux(EelUtilsKt.toEelArch((CpuArch)CpuArch.X86_64));
                }
                if (SystemInfoRt.isMac) {
                    yield (EelPlatform)new EelPlatform.Darwin(EelUtilsKt.toEelArch((CpuArch)CpuArch.X86_64));
                }
                yield null;
            }
            case -1, 3, 4, 5, 6 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
        this.title = "Test IJent + Local Machine: " + this.currentPlatform;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        Presentation $this$update_u24lambda_u240 = e.getPresentation();
        boolean bl = false;
        $this$update_u24lambda_u240.setText(this.title);
        $this$update_u24lambda_u240.setEnabled($this$update_u24lambda_u240.isEnabled() && this.currentPlatform != null);
    }

    @Nullable
    protected Object deployingStrategy(@NotNull CoroutineScope ijentProcessScope, @NotNull Continuation<? super Triple<String, ? extends IjentDeployingStrategy, ? extends EelDescriptor>> $completion) {
        EelPlatform eelPlatform = this.currentPlatform;
        if (eelPlatform == null) {
            throw new IllegalStateException("Local IJent is not supported on this OS".toString());
        }
        EelPlatform targetPlatform = eelPlatform;
        return new Triple((Object)this.title, (Object)new IjentControlledEnvironmentDeployingStrategy(targetPlatform, ijentProcessScope, this){
            final /* synthetic */ EelPlatform $targetPlatform;
            final /* synthetic */ CoroutineScope $ijentProcessScope;
            final /* synthetic */ IjentLocalVerificationAction this$0;
            {
                this.$targetPlatform = $targetPlatform;
                this.$ijentProcessScope = $ijentProcessScope;
                this.this$0 = $receiver;
            }

            protected Object getTargetPlatform(Continuation<? super EelPlatform> $completion) {
                return this.$targetPlatform;
            }

            protected Object getConnectionStrategy(Continuation<? super IjentConnectionStrategy> $completion) {
                return IjentConnectionStrategy.Default.INSTANCE;
            }

            protected Object createProcess(String binaryPath, Continuation<? super IjentSessionProcessMediator> $completion) {
                Collection $this$toTypedArray$iv = IjentProcessUtil.getIjentGrpcArgv$default((String)binaryPath, (boolean)false, (boolean)false, null, (int)14, null);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                Process process = new ProcessBuilder(Arrays.copyOf(stringArray, stringArray.length)).start();
                Intrinsics.checkNotNullExpressionValue((Object)process, (String)"start(...)");
                return IjentSessionProcessMediator.Companion.create(this.$ijentProcessScope, process, IjentLocalVerificationAction.access$getTitle$p(this.this$0), (Function2)new Function2<Integer, Continuation<? super Boolean>, Object>((Object)((Object)this)){

                    public final Object invoke(int p0, Continuation<? super Boolean> $completion) {
                        return ((Object)this.receiver).isExpectedProcessExit(p0, $completion);
                    }
                });
            }

            protected Object copyFile(Path file, Continuation<? super String> $completion) {
                return ((Object)file).toString();
            }

            protected void close() {
            }
        }, (Object)IjentVerificationActionsKt.access$dummyEelDescriptor(targetPlatform));
    }

    public static final /* synthetic */ String access$getTitle$p(IjentLocalVerificationAction $this) {
        return $this.title;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CpuArch.values().length];
            try {
                nArray[CpuArch.ARM64.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86_64.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.X86.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.ARM32.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.OTHER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CpuArch.UNKNOWN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

