/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.impl.hyperv;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.ijent.IjentLogger;
import com.intellij.platform.ijent.impl.hyperv.HyperV;
import com.intellij.platform.ijent.impl.hyperv.HyperVSocket;
import com.intellij.util.io.IoKt;
import com.sun.jna.LastErrorException;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Guid;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\b\u0010\f\u001a\u00020\tH\u0002\u001a\b\u0010\r\u001a\u0004\u0018\u00010\u0004\u001a\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0012\u0010\u0012\u001a\u00020\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0011\"\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"connectToHyperVSocket", "Lcom/intellij/platform/ijent/impl/hyperv/HyperVSocket;", "Lkotlinx/coroutines/CoroutineScope;", "vmId", "Ljava/util/UUID;", "virtualPort", "", "IS_HYPER_V_AVAILABLE", "Lkotlin/Lazy;", "", "getIS_HYPER_V_AVAILABLE", "()Lkotlin/Lazy;", "isHyperVAvailable", "guessVmIdOfWsl", "readToBufCompletely", "", "buf", "Ljava/nio/ByteBuffer;", "writeToBufCompletely", "intellij.platform.ijent.impl"})
@SourceDebugExtension(value={"SMAP\nHyperVUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HyperVUtils.kt\ncom/intellij/platform/ijent/impl/hyperv/HyperVUtilsKt\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,193:1\n66#2:194\n1#3:195\n1#3:198\n1172#4:196\n1342#4:197\n1343#4:199\n1173#4:200\n*S KotlinDebug\n*F\n+ 1 HyperVUtils.kt\ncom/intellij/platform/ijent/impl/hyperv/HyperVUtilsKt\n*L\n156#1:194\n156#1:195\n157#1:198\n157#1:196\n157#1:197\n157#1:199\n157#1:200\n*E\n"})
public final class HyperVUtilsKt {
    @NotNull
    private static final Lazy<Boolean> IS_HYPER_V_AVAILABLE = LazyKt.lazy(HyperVUtilsKt::IS_HYPER_V_AVAILABLE$lambda$0);

    @NotNull
    public static final HyperVSocket connectToHyperVSocket(@NotNull CoroutineScope $this$connectToHyperVSocket, @NotNull UUID vmId, int virtualPort) {
        Intrinsics.checkNotNullParameter((Object)$this$connectToHyperVSocket, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)vmId, (String)"vmId");
        if (!SystemInfo.isWindows) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        try {
            Pointer socket = HyperV.SocketLibrary.socket(34, 1, 1);
            AtomicBoolean cancellationIndicator = new AtomicBoolean(false);
            Job.DefaultImpls.invokeOnCompletion$default((Job)JobKt.getJob((CoroutineContext)$this$connectToHyperVSocket.getCoroutineContext()), (boolean)true, (boolean)false, arg_0 -> HyperVUtilsKt.connectToHyperVSocket$lambda$0(cancellationIndicator, socket, arg_0), (int)2, null);
            ByteBuffer byteBuffer = ByteBuffer.allocate(16).putLong(vmId.getMostSignificantBits()).putLong(8, vmId.getLeastSignificantBits());
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"putLong(...)");
            Guid.GUID vmIdGUID = new Guid.GUID(IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null));
            Guid.GUID vsockTemplate = new Guid.GUID("{00000000-facb-11e6-bd58-64006a7986d3}");
            HyperV.SockaddrHv addr = new HyperV.SockaddrHv();
            addr.addressFamily = (short)34;
            addr.vmId = new Guid.GUID.ByValue(vmIdGUID);
            addr.serviceId = new Guid.GUID.ByValue(vsockTemplate);
            addr.serviceId.Data1 = virtualPort;
            HyperV.SocketLibrary.connect(socket, addr, addr.size());
            Intrinsics.checkNotNull((Object)socket);
            return new HyperVSocket(socket, cancellationIndicator);
        }
        catch (LastErrorException e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public static final Lazy<Boolean> getIS_HYPER_V_AVAILABLE() {
        return IS_HYPER_V_AVAILABLE;
    }

    private static final boolean isHyperVAvailable() {
        boolean bl;
        if (!SystemInfo.isWindows) {
            return false;
        }
        try {
            Pointer socket = HyperV.SocketLibrary.socket(34, 1, 1);
            HyperV.SocketLibrary.closesocket(socket);
            bl = true;
        }
        catch (Throwable e) {
            IjentLogger.INSTANCE.getHYPERV_LOG().info("Hyper-V sockets are unavailable", e);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public static final UUID guessVmIdOfWsl() {
        HashSet hashSet;
        Charset $this$guessVmIdOfWsl_u24lambda_u240;
        String[] stringArray = new String[3];
        stringArray[0] = "powershell";
        stringArray[1] = "-Command";
        Object object = new StringBuilder();
        StringBuilder stringBuilder = object;
        int n = 2;
        String[] stringArray2 = stringArray;
        boolean bl = false;
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append('\"');
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append("Get-WmiObject Win32_Process -Filter 'Name = ''wslhost.exe'' OR Name = ''wslrelay.exe''' ");
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append("| Select-Object CommandLine ");
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append("| Format-List -Force ");
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append("| Out-String -Width 2000000000");
        ((StringBuilder)((Object)$this$guessVmIdOfWsl_u24lambda_u240)).append('\"');
        Unit unit = Unit.INSTANCE;
        stringArray2[n] = ((StringBuilder)object).toString();
        String[] stringArray3 = stringArray;
        Process process = new ProcessBuilder(stringArray3).start();
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        object = inputStream;
        $this$guessVmIdOfWsl_u24lambda_u240 = Charsets.UTF_8;
        Closeable closeable = new InputStreamReader((InputStream)object, $this$guessVmIdOfWsl_u24lambda_u240);
        int n2 = 8192;
        Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        n2 = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        Throwable throwable = null;
        try {
            void $this$mapNotNullTo$iv;
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl2 = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl3 = false;
            Sequence sequence = lines;
            Collection destination$iv = new HashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv2;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl4 = false;
                String line = (String)element$iv;
                boolean bl5 = false;
                IjentLogger.INSTANCE.getHYPERV_LOG().trace("Finding vmId in line: '''" + line + "'''");
                char[] cArray = new char[]{' '};
                List args = StringsKt.split$default((CharSequence)line, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                int vmIdArg = args.indexOf("--vm-id") + 1;
                if ((vmIdArg > 0 ? (String)CollectionsKt.getOrNull((List)args, (int)vmIdArg) : null) == null) continue;
                it$iv2 = it$iv2;
                boolean bl6 = false;
                destination$iv.add(it$iv2);
            }
            hashSet = (HashSet)destination$iv;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        HashSet vmIds = hashSet;
        if (vmIds.size() > 1) {
            IjentLogger.INSTANCE.getHYPERV_LOG().warn("Unexpected multiple VmId from helper processes: " + vmIds);
            return null;
        }
        String string = (String)CollectionsKt.singleOrNull((Iterable)vmIds);
        if (string == null) {
            return null;
        }
        String singleVmId = string;
        String string2 = singleVmId.substring(1, singleVmId.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String strippedVmId = string2;
        return UUID.fromString(strippedVmId);
    }

    public static final void readToBufCompletely(@NotNull HyperVSocket $this$readToBufCompletely, @NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)$this$readToBufCompletely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        while (buf.hasRemaining()) {
            $this$readToBufCompletely.read(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeToBufCompletely(@NotNull HyperVSocket $this$writeToBufCompletely, @NotNull ByteBuffer buf) {
        Intrinsics.checkNotNullParameter((Object)$this$writeToBufCompletely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        HyperVSocket hyperVSocket = $this$writeToBufCompletely;
        synchronized (hyperVSocket) {
            boolean bl = false;
            while (buf.hasRemaining()) {
                $this$writeToBufCompletely.write(buf);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final Unit connectToHyperVSocket$lambda$0(AtomicBoolean $cancellationIndicator, Pointer $socket, Throwable it) {
        $cancellationIndicator.set(true);
        HyperV.SocketLibrary.shutdown($socket, 2);
        HyperV.SocketLibrary.closesocket($socket);
        return Unit.INSTANCE;
    }

    private static final boolean IS_HYPER_V_AVAILABLE$lambda$0() {
        return HyperVUtilsKt.isHyperVAvailable();
    }
}

