/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.javascript.nodejs.library.yarn.pnp.AllChildrenPsiDirectoryNode;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0014H\u0016J\n\u0010!\u001a\u0004\u0018\u00010\"H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnDependencyNode;", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/AllChildrenPsiDirectoryNode;", "project", "Lcom/intellij/openapi/project/Project;", "dependencyLocation", "Lcom/intellij/psi/PsiDirectory;", "viewSettings", "Lcom/intellij/ide/projectView/ViewSettings;", "dependency", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "packageJsonDeclaringDependencySupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiDirectory;Lcom/intellij/ide/projectView/ViewSettings;Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;Lkotlin/jvm/functions/Function0;)V", "getDependency", "()Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "getPackageJsonDeclaringDependencySupplier", "()Lkotlin/jvm/functions/Function0;", "insideArchive", "", "updateImpl", "", "data", "Lcom/intellij/ide/projectView/PresentationData;", "toTestString", "", "printInfo", "Lcom/intellij/openapi/ui/Queryable$PrintInfo;", "canNavigate", "canNavigateToSource", "navigate", "requestFocus", "findDeclaredDependencyProperty", "Lcom/intellij/json/psi/JsonProperty;", "intellij.javascript.backend"})
final class YarnDependencyNode
extends AllChildrenPsiDirectoryNode {
    @NotNull
    private final YarnPnpDependency dependency;
    @NotNull
    private final Function0<VirtualFile> packageJsonDeclaringDependencySupplier;
    private final boolean insideArchive;

    public YarnDependencyNode(@NotNull Project project, @NotNull PsiDirectory dependencyLocation, @NotNull ViewSettings viewSettings, @NotNull YarnPnpDependency dependency, @NotNull Function0<? extends VirtualFile> packageJsonDeclaringDependencySupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dependencyLocation, (String)"dependencyLocation");
        Intrinsics.checkNotNullParameter((Object)viewSettings, (String)"viewSettings");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        Intrinsics.checkNotNullParameter(packageJsonDeclaringDependencySupplier, (String)"packageJsonDeclaringDependencySupplier");
        super(project, dependencyLocation, viewSettings);
        this.dependency = dependency;
        this.packageJsonDeclaringDependencySupplier = packageJsonDeclaringDependencySupplier;
        this.insideArchive = JarFileSystem.getInstance().getRootByEntry(dependencyLocation.getVirtualFile()) != null;
    }

    @NotNull
    public final YarnPnpDependency getDependency() {
        return this.dependency;
    }

    @NotNull
    public final Function0<VirtualFile> getPackageJsonDeclaringDependencySupplier() {
        return this.packageJsonDeclaringDependencySupplier;
    }

    protected void updateImpl(@NotNull PresentationData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        data2.setPresentableText(this.dependency.getName());
        SemVer semVer = this.dependency.getVersion();
        if (semVer != null) {
            SemVer it = semVer;
            boolean bl = false;
            data2.setLocationString(it.getRawVersion());
        }
        if (this.insideArchive) {
            data2.setIcon(AllIcons.Nodes.JarDirectory);
        } else {
            this.setupIcon(data2, (PsiDirectory)this.getValue());
        }
    }

    @NotNull
    public String toTestString(@Nullable Queryable.PrintInfo printInfo) {
        SemVer semVer = this.dependency.getVersion();
        String versionStr = semVer != null ? semVer.getRawVersion() : null;
        String string = versionStr;
        return this.dependency.getName() + (String)(string != null ? " " + string : "");
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    public void navigate(boolean requestFocus) {
        JsonProperty dependencyProperty = this.findDeclaredDependencyProperty();
        if (dependencyProperty != null) {
            Project project = dependencyProperty.getProject();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)dependencyProperty));
            Intrinsics.checkNotNull((Object)virtualFile);
            new OpenFileDescriptor(project, virtualFile, dependencyProperty.getTextOffset() + 1).navigate(requestFocus);
        }
    }

    private final JsonProperty findDeclaredDependencyProperty() {
        PsiFile psiPackageJsonFile;
        VirtualFile packageJson = (VirtualFile)this.packageJsonDeclaringDependencySupplier.invoke();
        if (packageJson != null && (psiPackageJsonFile = PsiManager.getInstance((Project)this.getProject()).findFile(packageJson)) instanceof JsonFile) {
            return PackageJsonCommonUtil.findDependencyByName((JsonFile)((JsonFile)psiPackageJsonFile), (String)this.dependency.getName());
        }
        return null;
    }
}

