/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.findUsages.JSFindReferencesResultProcessor;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSFindUsagesUtilKt;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/ecmascript6/findUsages/JSImportExportAliasReferenceSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "searchForAliasUsages", "", "element", "Lcom/intellij/psi/PsiElement;", "collector", "Lcom/intellij/psi/search/SearchRequestCollector;", "getAlias", "Lcom/intellij/lang/javascript/psi/JSNamedElement;", "MyProcessor", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSImportExportAliasReferenceSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSImportExportAliasReferenceSearcher.kt\ncom/intellij/lang/ecmascript6/findUsages/JSImportExportAliasReferenceSearcher\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,120:1\n66#2,2:121\n*S KotlinDebug\n*F\n+ 1 JSImportExportAliasReferenceSearcher.kt\ncom/intellij/lang/ecmascript6/findUsages/JSImportExportAliasReferenceSearcher\n*L\n110#1:121,2\n*E\n"})
public final class JSImportExportAliasReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public JSImportExportAliasReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement psiElement = queryParameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement target = psiElement;
        if (!(target instanceof JSElement) || !(target instanceof PsiNamedElement)) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)target);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return;
        }
        SearchRequestCollector searchRequestCollector = queryParameters.getOptimizer();
        Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
        SearchRequestCollector collector = searchRequestCollector;
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getEffectiveSearchScope(...)");
        SearchScope scope2 = searchScope;
        Pair pair = JSFindUsagesUtilKt.isExportWithString(target) ? TuplesKt.to((Object)JSFindUsagesUtilKt.longestWordPartInExportString(target), (Object)((short)(1 | 4))) : TuplesKt.to((Object)((NavigationItem)target).getName(), (Object)1);
        String wordToSearch = (String)pair.component1();
        short searchContext = ((Number)pair.component2()).shortValue();
        if (wordToSearch == null) {
            return;
        }
        collector.searchWord(wordToSearch, scope2, searchContext, true, target, (RequestResultProcessor)new MyProcessor(target, queryParameters));
    }

    private final boolean searchForAliasUsages(PsiElement element2, SearchRequestCollector collector) {
        JSNamedElement alias = this.getAlias(element2);
        if (alias == null) {
            return false;
        }
        String name = alias.getName();
        if (name == null) {
            return false;
        }
        LocalSearchScope fileScope = new LocalSearchScope((PsiElement)element2.getContainingFile());
        collector.searchWord(name, (SearchScope)fileScope, (short)1, true, (PsiElement)alias);
        return true;
    }

    private final JSNamedElement getAlias(PsiElement $this$getAlias) {
        if ($this$getAlias instanceof ES6ImportSpecifier) {
            ES6ImportSpecifierAlias alias = ((ES6ImportSpecifier)$this$getAlias).getAlias();
            if (alias != null) {
                return (JSNamedElement)alias;
            }
        } else if ($this$getAlias instanceof TypeScriptEntityName && !($this$getAlias.getParent() instanceof TypeScriptEntityName)) {
            PsiElement $this$parentOfType_u24default$iv = $this$getAlias;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            TypeScriptImportStatement importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, TypeScriptImportStatement.class, (boolean)true);
            if (importStatement != null) {
                return (JSNamedElement)importStatement;
            }
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000f0\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/ecmascript6/findUsages/JSImportExportAliasReferenceSearcher$MyProcessor;", "Lcom/intellij/lang/ecmascript6/findUsages/JSFindReferencesResultProcessor;", "target", "Lcom/intellij/psi/PsiElement;", "queryParameters", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "(Lcom/intellij/lang/ecmascript6/findUsages/JSImportExportAliasReferenceSearcher;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;)V", "proceedWithReference", "", "element", "collector", "Lcom/intellij/psi/search/SearchRequestCollector;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "intellij.javascript.backend"})
    private final class MyProcessor
    extends JSFindReferencesResultProcessor {
        public MyProcessor(@NotNull PsiElement target, ReferencesSearch.SearchParameters queryParameters) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
            super(target, queryParameters);
        }

        @Override
        protected boolean proceedWithReference(@NotNull PsiElement element2, @NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> consumer) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            consumer.process((Object)element2.getReference());
            return JSImportExportAliasReferenceSearcher.this.searchForAliasUsages(element2, collector);
        }
    }
}

