/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ecmascript6.completion.ES6PropertyCompletionProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSSymbolCompletionUtil;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveProcessorEx;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.completion.PolySymbolsCompletionProviderBase;
import com.intellij.polySymbols.js.JsSymbolKinds;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPropertyNameCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
        if (parameters2 == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(2);
        }
        if (PolySymbolsCompletionProviderBase.isFurtherCodeCompletionPreventedFor((CompletionParameters)parameters2, (PolySymbolKind[])new PolySymbolKind[]{JsSymbolKinds.JS_PROPERTIES})) {
            return;
        }
        PsiElement position = parameters2.getPosition();
        if (position.getParent() instanceof JSReferenceExpression) {
            ES6PropertyCompletionProvider.addCompletions(parameters2, result2);
            return;
        }
        JSCompletionUtil.addCompletions(parameters2, result2, JSPropertyNameReference.class, JSPropertyNameCompletionProvider::addVariants);
    }

    private static void addVariants(@NotNull JSPropertyNameReference reference, @NotNull CompletionParameters completionParameters, @NotNull CompletionResultSet resultSet) {
        if (reference == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(3);
        }
        if (completionParameters == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(4);
        }
        if (resultSet == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(5);
        }
        JSPropertyNameCompletionProvider.calcPropertyNameReferenceVariants(reference.getElement(), completionParameters, resultSet, null);
    }

    public static void calcPropertyNameReferenceVariants(@NotNull JSProperty property, @NotNull CompletionParameters parameters2, @NotNull CompletionResultSet resultSet, @Nullable Function<? super Collection<? extends LookupElement>, ? extends Collection<? extends LookupElement>> transformResults) {
        boolean stop;
        PsiElement parentElement;
        if (property == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(6);
        }
        if (parameters2 == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(7);
        }
        if (resultSet == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(8);
        }
        VariantsProcessor processor = new VariantsProcessor(property.getContainingFile(), (PsiElement)property, false, parameters2, resultSet);
        if (DialectDetector.isTypeScript((PsiElement)property) && Registry.is((String)"typescript.service.powered.property.name.completion") && (parentElement = CompletionUtil.getOriginalElement((PsiElement)property.getParent())) != null) {
            int offsetInDocument = parameters2.getOffset();
            TypeScriptCompilerEvaluationFacade instance = (TypeScriptCompilerEvaluationFacade)property.getProject().getService(TypeScriptCompilerEvaluationFacade.class);
            List symbols2 = instance.getCompletionSymbolsFromService(parentElement, offsetInDocument);
            if (symbols2 != null) {
                List lookupElements = ContainerUtil.mapNotNull((Collection)symbols2, JSLookupUtilImpl::createLookupItemForTSSymbol);
                processor.populateCompletionList(lookupElements, true, resultSet);
                return;
            }
        }
        PsiElement context2 = JSPropertyNameCompletionProvider.getShorthandedPropertyContext(property);
        if (!processor.getTypeInfo().hasExplicitNamespace() && !ContainerUtil.exists((Iterable)processor.getTypeInfo().getRecordTypes(), JSRecordType::hasProperties) && context2 != null) {
            CompletionResultSink sink = new CompletionResultSink(context2, resultSet.getPrefixMatcher());
            SinkResolveProcessor localProcessor = new SinkResolveProcessor((ResultSink)sink);
            JSReferenceExpressionImpl.doProcessLocalDeclarations((PsiElement)context2, null, (JSResolveProcessorEx)localProcessor, (boolean)false, (boolean)true, null);
            processor.populateCompletionList(sink.getResultsAsObjects(), true, resultSet);
        }
        boolean bl = stop = !JSSymbolCompletionUtil.processIndexedSymbols((PsiElement)property, processor, resultSet, null);
        if (stop) {
            return;
        }
        Collection<LookupElement> results = processor.getFinalResults();
        processor.populateCompletionList(transformResults == null ? results : transformResults.apply(results), false, resultSet);
    }

    @Nullable
    private static PsiElement getShorthandedPropertyContext(@NotNull JSProperty property) {
        DialectOptionHolder holder;
        if (property == null) {
            JSPropertyNameCompletionProvider.$$$reportNull$$$0(9);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)property)) == null || !holder.hasFeature(JSLanguageFeature.SHORTHAND_PROPERTY_NAMES)) {
            return null;
        }
        if (property.isShorthanded() && property.getValue() instanceof JSReferenceExpression) {
            return property.getValue();
        }
        if (property.getNextSibling() instanceof PsiErrorElement) {
            return property.getNameIdentifier();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionParameters";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/JSPropertyNameCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addVariants";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "calcPropertyNameReferenceVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getShorthandedPropertyContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

