/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.standardjs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.JsonUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StandardJSUtil {
    public static final String PACKAGE_NAME = "standard";
    public static final String CONFIG_SECTION_NAME = "standard";
    public static final Key<ParameterizedCachedValue<ConfigData, PsiFile>> CACHE_KEY = new Key(StandardJSUtil.class.getName() + ".config");
    public static final Logger LOG = Logger.getInstance(StandardJSUtil.class);
    public static final SemVer MIN_VERSION = new SemVer("10.0.0", 10, 0, 0);

    private StandardJSUtil() {
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static ConfigData getPackageJsonConfigData(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            StandardJSUtil.$$$reportNull$$$0(0);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (virtualFile == null) {
            return null;
        }
        return (ConfigData)ReadAction.compute(() -> {
            PsiFile psiFile = psiManager.findFile(virtualFile);
            if (psiFile == null) {
                return null;
            }
            return (ConfigData)CachedValuesManager.getManager((Project)project).getParameterizedCachedValue((UserDataHolder)psiFile, CACHE_KEY, theFile -> {
                VirtualFile theVirtualFile = theFile.getVirtualFile();
                if (theVirtualFile == null) {
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{psiFile});
                }
                try {
                    String text = VfsUtilCore.loadText((VirtualFile)theVirtualFile);
                    return CachedValueProvider.Result.create((Object)StandardJSUtil.parseSectionData(text), (Object[])new Object[]{psiFile});
                }
                catch (Exception e) {
                    LOG.info(String.format("Could not read config data from file [%s]", theVirtualFile.getCanonicalPath()), (Throwable)e);
                    return CachedValueProvider.Result.create(null, (Object[])new Object[]{psiFile});
                }
            }, false, (Object)psiFile);
        });
    }

    @Nullable
    private static ConfigData parseSectionData(@Nullable String text) {
        JsonObject jsonObject = JsonUtil.tryParseJsonObject((String)text);
        if (jsonObject == null) {
            return null;
        }
        JsonObject sectionObject = JsonUtil.getChildAsObject((JsonObject)jsonObject, (String)"standard");
        if (sectionObject == null) {
            return null;
        }
        List<String> plugins = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "plugins", "plugin");
        List<String> globals = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "globals", "global");
        List<String> ignored = StandardJSUtil.getChildAsSingleStringOrList(sectionObject, "ignore");
        String parser = JsonUtil.getChildAsString((JsonObject)sectionObject, (String)"parser");
        List<String> environment = StandardJSUtil.getEnvironment(sectionObject);
        return new ConfigData(plugins, ignored, globals, environment, parser);
    }

    @NotNull
    private static List<String> getEnvironment(@NotNull JsonObject sectionObject) {
        JsonElement child;
        JsonObject object;
        if (sectionObject == null) {
            StandardJSUtil.$$$reportNull$$$0(1);
        }
        return (object = JsonUtil.getAsObject((JsonElement)(child = JsonUtil.findChild((JsonObject)sectionObject, (String[])new String[]{"env", "envs"})))) != null ? JsonUtil.keys((JsonObject)object) : StandardJSUtil.getAsSingleStringOrList(child);
    }

    @NotNull
    private static List<String> getChildAsSingleStringOrList(@NotNull JsonObject obj, String ... names) {
        JsonElement child;
        if (obj == null) {
            StandardJSUtil.$$$reportNull$$$0(2);
        }
        return (child = JsonUtil.findChild((JsonObject)obj, (String[])names)) == null ? ContainerUtil.emptyList() : StandardJSUtil.getAsSingleStringOrList(child);
    }

    @NotNull
    private static List<String> getAsSingleStringOrList(@Nullable JsonElement element2) {
        if (element2 == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                StandardJSUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        String string = JsonUtil.getString((JsonElement)element2);
        List list = string != null ? Collections.singletonList(string) : JsonUtil.getAsStringList((JsonElement)element2);
        if (list == null) {
            StandardJSUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionObject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsSingleStringOrList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonConfigData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildAsSingleStringOrList";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class ConfigData {
        public final List<String> plugins;
        public final List<String> ignored;
        public final List<String> globals;
        public final List<String> env;
        public final String parser;

        public ConfigData(@NotNull List<String> plugins, @NotNull List<String> ignored, @NotNull List<String> globals, @NotNull List<String> env, String parser) {
            if (plugins == null) {
                ConfigData.$$$reportNull$$$0(0);
            }
            if (ignored == null) {
                ConfigData.$$$reportNull$$$0(1);
            }
            if (globals == null) {
                ConfigData.$$$reportNull$$$0(2);
            }
            if (env == null) {
                ConfigData.$$$reportNull$$$0(3);
            }
            this.plugins = plugins;
            this.ignored = ignored;
            this.globals = globals;
            this.env = env;
            this.parser = parser;
        }

        public String toString() {
            return "ConfigData{plugins=" + String.valueOf(this.plugins) + ", ignored=" + String.valueOf(this.ignored) + ", globals=" + String.valueOf(this.globals) + ", env=" + String.valueOf(this.env) + ", parser='" + this.parser + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "plugins";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ignored";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "globals";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "env";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/eslint/standardjs/StandardJSUtil$ConfigData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

