/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jshint;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.jshint.config.JSHintConfigFileType;
import com.intellij.lang.javascript.linter.ui.JSLinterConfigFileView;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class JSHintConfigFileView {
    private final JPanel myComponent;
    private final JRadioButton myDefaultRadioButton;
    private final JRadioButton myCustomRadioButton;
    private final TextFieldWithHistoryWithBrowseButton myCustomConfigField;
    private final List<Pair<JRadioButton, JComponent>> myRadioButtonWithContentList;
    private final JLabel myCustomConfigFileErrorLabel;

    public JSHintConfigFileView(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(0);
        }
        this.myDefaultRadioButton = new JBRadioButton(JavaScriptBundle.message((String)"jshint.config.option.default.name", (Object[])new Object[0]));
        JEditorPane defaultContentEditor = JSLinterUtil.createDefaultContent(JavaScriptBundle.message((String)"jshint.config.default.description", (Object[])new Object[0]));
        JPanel defaultContent = SwingHelper.wrapWithHorizontalStretch((JComponent)defaultContentEditor);
        this.myCustomRadioButton = new JBRadioButton(JavaScriptBundle.message((String)"jshint.config.option.custom.name", (Object[])new Object[0]));
        this.myCustomConfigField = JSHintConfigFileView.createCustomConfigField(project);
        this.myCustomConfigFileErrorLabel = new JLabel();
        this.myCustomConfigFileErrorLabel.setFont(UIUtil.getTitledBorderFont());
        JPanel customContent = JSHintConfigFileView.createCustomContent(this.myCustomConfigField, this.myCustomConfigFileErrorLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myDefaultRadioButton);
        buttonGroup.add(this.myCustomRadioButton);
        this.myRadioButtonWithContentList = List.of(Pair.create((Object)this.myDefaultRadioButton, (Object)defaultContent), Pair.create((Object)this.myCustomRadioButton, (Object)customContent));
        this.selectOption(this.myDefaultRadioButton, true);
        ((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getTextEditor().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSHintConfigFileView.this.updateCustomErrorMessage();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView$1", "textChanged"));
            }
        });
        this.myComponent = this.createResultPanel(this.myRadioButtonWithContentList);
    }

    private void selectOption(@NotNull JRadioButton radioButton, boolean selected) {
        if (radioButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(1);
        }
        for (Pair<JRadioButton, JComponent> pair : this.myRadioButtonWithContentList) {
            boolean pairSelected = pair.getFirst() == radioButton ? selected : !selected;
            ((JRadioButton)pair.getFirst()).setSelected(pairSelected);
            UIUtil.setEnabled((Component)((Component)pair.getSecond()), (boolean)pairSelected, (boolean)true);
        }
        this.updateCustomErrorMessage();
    }

    private void updateCustomErrorMessage() {
        boolean visible = this.myCustomRadioButton.isSelected() && this.myCustomRadioButton.isEnabled();
        this.myCustomConfigFileErrorLabel.setVisible(visible);
        if (visible) {
            String errorMessage = JSLinterConfigFileView.formatErrorMessage(((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
            if (errorMessage != null) {
                String html = JSLinterUtil.getRedErrorTextHtml(errorMessage);
                this.myCustomConfigFileErrorLabel.setText(html);
            } else {
                this.myCustomConfigFileErrorLabel.setText("");
            }
        }
    }

    @NotNull
    private JPanel createResultPanel(@NotNull List<? extends Pair<JRadioButton, JComponent>> contentByRadioButton) {
        if (contentByRadioButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(2);
        }
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            final JRadioButton jRadioButton = (JRadioButton)pair.getFirst();
            jRadioButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JSHintConfigFileView.this.selectOption(jRadioButton, jRadioButton.isSelected());
                }
            });
        }
        ArrayList<Component> components = new ArrayList<Component>();
        for (Pair<JRadioButton, JComponent> pair : contentByRadioButton) {
            if (!components.isEmpty()) {
                components.add(Box.createVerticalStrut(10));
            }
            JRadioButton radioButton = (JRadioButton)pair.getFirst();
            components.add(radioButton);
            int leftMargin = JSLinterUtil.getMarginForRadioButton(radioButton);
            JPanel wrap = SwingHelper.wrapWithHorizontalStretch((JComponent)((JComponent)pair.getSecond()));
            wrap.setBorder(BorderFactory.createEmptyBorder(0, leftMargin, 0, 0));
            components.add(wrap);
        }
        JPanel jPanel = SwingHelper.newLeftAlignedVerticalPanel(components);
        jPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JavaScriptBundle.message((String)"border.title.inspection.export.results.capitalized.location", (Object[])new Object[0]), (boolean)false));
        JPanel jPanel2 = SwingHelper.wrapWithHorizontalStretch((JComponent)jPanel);
        if (jPanel2 == null) {
            JSHintConfigFileView.$$$reportNull$$$0(3);
        }
        return jPanel2;
    }

    @NotNull
    private static JPanel createCustomContent(@NotNull TextFieldWithHistoryWithBrowseButton configField, @NotNull JLabel configErrorLabel) {
        if (configField == null) {
            JSHintConfigFileView.$$$reportNull$$$0(4);
        }
        if (configErrorLabel == null) {
            JSHintConfigFileView.$$$reportNull$$$0(5);
        }
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(configErrorLabel);
        panel2.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        JPanel jPanel = FormBuilder.createFormBuilder().setHorizontalGap(10).setVerticalGap(4).addLabeledComponent(JavaScriptBundle.message((String)"label.path", (Object[])new Object[0]), (JComponent)configField).addComponentToRightColumn((JComponent)panel2).getPanel();
        if (jPanel == null) {
            JSHintConfigFileView.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createCustomConfigField(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(7);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(JavaScriptBundle.message((String)"jshint.config.option.custom.browser.title", (Object[])new Object[0]));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (FileChooserDescriptor)descriptor, () -> {
            List<VirtualFile> files = JSHintConfigFileView.listConfigFilesInContentScope(project);
            return ContainerUtil.sorted((Collection)ContainerUtil.map(files, file -> FileUtil.toSystemDependentName((String)file.getPath())));
        });
        if (textFieldWithHistoryWithBrowseButton == null) {
            JSHintConfigFileView.$$$reportNull$$$0(8);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    private static List<VirtualFile> listConfigFilesInContentScope(@NotNull Project project) {
        if (project == null) {
            JSHintConfigFileView.$$$reportNull$$$0(9);
        }
        GlobalSearchScope scope2 = ProjectScope.getContentScope((Project)project);
        Collection configs = FileTypeIndex.getFiles((FileType)JSHintConfigFileType.INSTANCE, (GlobalSearchScope)scope2);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (VirtualFile config : configs) {
            String path2;
            if (config == null || !config.isValid() || config.isDirectory() || (path2 = config.getPath()).contains("/node_modules/") || path2.contains("/bower_components/")) continue;
            result2.add(config);
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JSHintConfigFileView.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public Component getComponent() {
        return this.myComponent;
    }

    public void onEnabledStateChange(boolean enabled) {
        if (enabled) {
            this.selectOption(this.myDefaultRadioButton, this.myDefaultRadioButton.isSelected());
        }
        this.updateCustomErrorMessage();
    }

    public boolean isCustomConfigFileUsed() {
        return this.myCustomRadioButton.isSelected();
    }

    @NotNull
    public String getCustomConfigFilePath() {
        String string = StringUtil.notNullize((String)((TextFieldWithHistory)this.myCustomConfigField.getChildComponent()).getText());
        if (string == null) {
            JSHintConfigFileView.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setCustomConfigFileUsed(boolean used) {
        this.myCustomRadioButton.setSelected(used);
    }

    public void setCustomConfigFilePath(@NotNull String customConfigFilePath) {
        if (customConfigFilePath == null) {
            JSHintConfigFileView.$$$reportNull$$$0(12);
        }
        TextFieldWithHistory history = (TextFieldWithHistory)this.myCustomConfigField.getChildComponent();
        history.setText(customConfigFilePath);
        history.addCurrentTextToHistory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "radioButton";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentByRadioButton";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configErrorLabel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customConfigFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jshint/JSHintConfigFileView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomConfigField";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "listConfigFilesInContentScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomConfigFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createResultPanel";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCustomContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCustomConfigField";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "listConfigFilesInContentScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCustomConfigFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

