/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.events.BaseEventId;
import com.intellij.internal.statistic.eventLog.events.EventDataCollector;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventIdName;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BC\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0007\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\t0\b\"\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\r\u001a\u00020\u000e2\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012J1\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u0015J\"\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012J(\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0016\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\f0\u0017J)\u0010\r\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000e0\u0018\u00a2\u0006\u0002\b\u001aJ\"\u0010\u001b\u001a\u00020\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012J'\u0010\u001c\u001a\u00020\u001d2\u001a\u0010\u000f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00100\b\"\u0006\u0012\u0002\b\u00030\u0010\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012J\u001a\u0010\u001f\u001a\u00020 2\u0010\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u0012H\u0002J\u0012\u0010!\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0012H\u0016J\n\u0010\"\u001a\u00020\u0005H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "group", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "eventId", "", "description", "fields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "<init>", "(Lcom/intellij/internal/statistic/eventLog/EventLogGroup;Ljava/lang/String;Ljava/lang/String;[Lcom/intellij/internal/statistic/eventLog/events/EventField;)V", "", "log", "", "pairs", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "dataBuilder", "Ljava/util/function/Consumer;", "Lkotlin/Function1;", "Lcom/intellij/internal/statistic/eventLog/events/EventDataCollector;", "Lkotlin/ExtensionFunctionType;", "logState", "metric", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)Lcom/intellij/internal/statistic/beans/MetricEvent;", "buildUsageData", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "getFields", "toString", "intellij.platform.statistics"})
public final class VarargEventId
extends BaseEventId {
    @NotNull
    private final EventLogGroup group;
    @NotNull
    private final List<EventField<?>> fields;

    public VarargEventId(@NotNull EventLogGroup group, @EventIdName @NonNls @NotNull String eventId, @NonNls @Nullable String description, EventField<?> ... fields) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super(group.getId(), eventId, group.getRecorder(), description);
        this.group = group;
        this.fields = ArraysKt.toMutableList((Object[])fields);
    }

    public final void log(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> VarargEventId.log$lambda$0(this, pairs, arg_0)));
    }

    public final void log(@Nullable Project project, EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.log(project, CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    public final void log(@Nullable Project project, @NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> VarargEventId.log$lambda$1(this, pairs, project, arg_0)));
    }

    public final void log(@Nullable Project project, @NotNull Consumer<List<EventPair<?>>> dataBuilder) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        this.log(project, (Function1<? super EventDataCollector, Unit>)new Function1<List<EventPair<?>>, Unit>(dataBuilder){

            public final void invoke(List<EventPair<?>> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((Consumer)this.receiver).accept(p0);
            }
        });
    }

    public final void log(@Nullable Project project, @NotNull Function1<? super EventDataCollector, Unit> dataBuilder) {
        Intrinsics.checkNotNullParameter(dataBuilder, (String)"dataBuilder");
        this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> VarargEventId.log$lambda$2(this, dataBuilder, project, arg_0)));
    }

    public final void logState(@Nullable Project project, @NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        this.processLoggers$intellij_platform_statistics((Function1<? super StatisticsEventLogger, Unit>)((Function1)arg_0 -> VarargEventId.logState$lambda$0(this, pairs, project, arg_0)));
    }

    @NotNull
    public final MetricEvent metric(EventPair<?> ... pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return this.metric(CollectionsKt.listOf((Object[])Arrays.copyOf(pairs, pairs.length)));
    }

    @NotNull
    public final MetricEvent metric(@NotNull List<? extends EventPair<?>> pairs) {
        Intrinsics.checkNotNullParameter(pairs, (String)"pairs");
        return new MetricEvent(this.getEventId(), this.buildUsageData(pairs), this.group.getRecorder());
    }

    private final FeatureUsageData buildUsageData(List<? extends EventPair<?>> pairs) {
        FeatureUsageData data = new FeatureUsageData(this.group.getRecorder());
        this.extendFeatureUsageData(this.group, data);
        for (EventPair<?> pair : pairs) {
            if (!this.fields.contains(pair.getField())) {
                throw new IllegalArgumentException("Field " + pair.getField().getName() + " not in fields for event ID " + this.getEventId());
            }
            EventField<?> eventField = pair.getField();
            Intrinsics.checkNotNull(eventField, (String)"null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.events.EventField<kotlin.Any?>");
            eventField.addData(data, pair.getData());
        }
        return data;
    }

    @Override
    @NotNull
    public List<EventField<?>> getFields() {
        return this.extendEventFields(this.group, this.fields);
    }

    @NotNull
    public String toString() {
        return "VarargEventId(eventId='" + this.getEventId() + "')";
    }

    private static final Unit log$lambda$0(VarargEventId this$0, List $pairs, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), this$0.buildUsageData($pairs).build(), false);
        return Unit.INSTANCE;
    }

    private static final Unit log$lambda$1(VarargEventId this$0, List $pairs, Project $project, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), this$0.buildUsageData($pairs).addProject($project).build(), false);
        return Unit.INSTANCE;
    }

    private static final Map log$lambda$2$0(Function1 $dataBuilder, VarargEventId this$0, Project $project) {
        EventDataCollector list = new EventDataCollector();
        $dataBuilder.invoke((Object)list);
        return !list.getSkipped() ? this$0.buildUsageData(list).addProject($project).build() : null;
    }

    private static final Unit log$lambda$2(VarargEventId this$0, Function1 $dataBuilder, Project $project, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), (Function0<? extends Map<String, ? extends Object>>)((Function0)() -> VarargEventId.log$lambda$2$0($dataBuilder, this$0, $project)), false);
        return Unit.INSTANCE;
    }

    private static final Unit logState$lambda$0(VarargEventId this$0, List $pairs, Project $project, StatisticsEventLogger it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.logAsync(this$0.group, this$0.getEventId(), this$0.buildUsageData($pairs).addProject($project).build(), true);
        return Unit.INSTANCE;
    }
}

