/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.MissingMethodBodyFixer;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement == null) {
            SemicolonFixer.$$$reportNull$$$0(0);
        }
        if (SemicolonFixer.fixReturn(editor, psiElement)) {
            return;
        }
        if (SemicolonFixer.fixForUpdate(editor, psiElement)) {
            return;
        }
        SemicolonFixer.fixAfterLastValidElement(editor, psiElement);
    }

    private static boolean fixReturn(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(1);
        }
        if (psiElement instanceof PsiReturnStatement) {
            PsiReturnStatement stmt = (PsiReturnStatement)psiElement;
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class});
            if (method != null && PsiTypes.voidType().equals(method.getReturnType()) && stmt.getReturnValue() != null) {
                Document doc = editor.getDocument();
                doc.insertString(stmt.getTextRange().getStartOffset() + "return".length(), (CharSequence)";");
                return true;
            }
        }
        return false;
    }

    private static boolean fixForUpdate(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof PsiForStatement)) {
            return false;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiExpression condition = forStatement.getCondition();
        if (forStatement.getUpdate() != null || condition == null) {
            return false;
        }
        TextRange range = condition.getTextRange();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int max = forStatement.getTextRange().getEndOffset();
        for (int i = range.getEndOffset() - 1; i < max; ++i) {
            if (text.charAt(i) != ';') continue;
            return false;
        }
        Object toInsert = ";";
        if (CodeStyle.getSettings((PsiFile)psiElement.getContainingFile()).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_SEMICOLON) {
            toInsert = (String)toInsert + " ";
        }
        document.insertString(range.getEndOffset(), (CharSequence)toInsert);
        return true;
    }

    private static boolean fixAfterLastValidElement(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        if (editor == null) {
            SemicolonFixer.$$$reportNull$$$0(3);
        }
        if (psiElement instanceof PsiExpressionStatement || psiElement instanceof PsiDeclarationStatement || psiElement instanceof PsiImportStatementBase || psiElement instanceof PsiDoWhileStatement || psiElement instanceof PsiReturnStatement || psiElement instanceof PsiThrowStatement || psiElement instanceof PsiBreakStatement || psiElement instanceof PsiContinueStatement || psiElement instanceof PsiYieldStatement || psiElement instanceof PsiAssertStatement || psiElement instanceof PsiPackageStatement || SemicolonFixer.isStandaloneField(psiElement) || psiElement instanceof PsiMethod && ((PsiMethod)psiElement).getBody() == null && !MissingMethodBodyFixer.shouldHaveBody((PsiMethod)psiElement) || psiElement instanceof PsiRequiresStatement || psiElement instanceof PsiPackageAccessibilityStatement || psiElement instanceof PsiUsesStatement || psiElement instanceof PsiProvidesStatement) {
            PsiWhiteSpace ws;
            PsiPatternVariable variable;
            PsiIdentifier identifier;
            PsiElement psiElement2;
            PsiAssignmentExpression assignment;
            PsiExpressionStatement exprStmt;
            PsiTypeTestPattern typePattern;
            PsiInstanceOfExpression instanceOf;
            PsiErrorElement error;
            PsiElement psiElement3;
            String text = psiElement.getText();
            int tailLength = 0;
            ASTNode leaf = TreeUtil.findLastLeaf((ASTNode)psiElement.getNode());
            while (leaf != null && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(leaf.getElementType())) {
                tailLength += leaf.getTextLength();
                leaf = TreeUtil.prevLeaf((ASTNode)leaf);
            }
            if (leaf == null) {
                return false;
            }
            if (tailLength > 0) {
                text = text.substring(0, text.length() - tailLength);
            }
            int insertionOffset = leaf.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            if (psiElement instanceof PsiField && ((PsiField)psiElement).hasModifierProperty("abstract")) {
                doc.insertString(insertionOffset, (CharSequence)"()");
                insertionOffset += "()".length();
            }
            if ((psiElement3 = psiElement.getLastChild()) instanceof PsiErrorElement && (psiElement3 = (error = (PsiErrorElement)psiElement3).getPrevSibling()) instanceof PsiInstanceOfExpression && (psiElement3 = (instanceOf = (PsiInstanceOfExpression)psiElement3).getLastChild()) instanceof PsiTypeTestPattern && (typePattern = (PsiTypeTestPattern)psiElement3).getPatternVariable() != null && (psiElement3 = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement)) instanceof PsiExpressionStatement && (psiElement3 = (exprStmt = (PsiExpressionStatement)psiElement3).getExpression()) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)psiElement3).getOperationTokenType().equals(JavaTokenType.EQ) && (psiElement2 = (identifier = (variable = typePattern.getPatternVariable()).getNameIdentifier()).getPrevSibling()) instanceof PsiWhiteSpace && (ws = (PsiWhiteSpace)psiElement2).getText().contains("\n") && editor.getCaretModel().getOffset() < identifier.getTextRange().getStartOffset()) {
                insertionOffset = ws.getTextRange().getStartOffset();
            }
            if (!StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                PsiElement parent = psiElement.getParent();
                Object toInsert = ";";
                if (parent instanceof PsiForStatement) {
                    if (((PsiForStatement)parent).getUpdate() == psiElement) {
                        return false;
                    }
                    if (CodeStyle.getSettings((PsiFile)psiElement.getContainingFile()).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_SEMICOLON) {
                        toInsert = (String)toInsert + " ";
                    }
                }
                doc.insertString(insertionOffset, (CharSequence)toInsert);
                return true;
            }
        }
        return false;
    }

    private static boolean isStandaloneField(@Nullable PsiElement psiElement) {
        return psiElement instanceof PsiField && !(psiElement instanceof PsiEnumConstant) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText(","))).accepts(psiElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/SemicolonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fixReturn";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixForUpdate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fixAfterLastValidElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

