/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.lang.BracePair;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaBraceMatcher
implements PairedBraceMatcher {
    private final BracePair[] pairs = new BracePair[]{new BracePair(JavaTokenType.LPARENTH, JavaTokenType.RPARENTH, false), new BracePair(JavaTokenType.LBRACE, JavaTokenType.RBRACE, true), new BracePair(JavaTokenType.LBRACKET, JavaTokenType.RBRACKET, false), new BracePair(JavaDocTokenType.DOC_INLINE_TAG_START, JavaDocTokenType.DOC_INLINE_TAG_END, false), new BracePair(JavaTokenType.LT, JavaTokenType.GT, false), new BracePair(JavaDocTokenType.DOC_LBRACKET, JavaDocTokenType.DOC_RBRACKET, false), new BracePair(JavaDocTokenType.DOC_LPAREN, JavaDocTokenType.DOC_RPAREN, false)};

    public BracePair @NotNull [] getPairs() {
        if (this.pairs == null) {
            JavaBraceMatcher.$$$reportNull$$$0(0);
        }
        return this.pairs;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            JavaBraceMatcher.$$$reportNull$$$0(1);
        }
        if (contextType instanceof IJavaElementType) {
            return JavaBraceMatcher.isPairedBracesAllowedBeforeTypeInJava(contextType);
        }
        return true;
    }

    private static boolean isPairedBracesAllowedBeforeTypeInJava(IElementType tokenType) {
        return ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(tokenType) || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA || tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.RBRACKET || tokenType == JavaTokenType.RBRACE || tokenType == JavaTokenType.LBRACE || tokenType == JavaTokenType.DOT;
    }

    public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
        PsiElement element = file.findElementAt(openingBraceOffset);
        if (element == null || element instanceof PsiFile) {
            return openingBraceOffset;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiCodeBlock) {
            if ((parent = parent.getParent()) instanceof PsiMethod || parent instanceof PsiClassInitializer) {
                TextRange range = DeclarationRangeUtil.getDeclarationRange((PsiElement)parent);
                return range.getStartOffset();
            }
            if (parent instanceof PsiStatement) {
                if (parent instanceof PsiBlockStatement && parent.getParent() instanceof PsiStatement) {
                    parent = parent.getParent();
                }
                return parent.getTextRange().getStartOffset();
            }
        } else if (parent instanceof PsiClass) {
            TextRange range = DeclarationRangeUtil.getDeclarationRange((PsiElement)parent);
            return range.getStartOffset();
        }
        return openingBraceOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/JavaBraceMatcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPairs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/JavaBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

