/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CompilerManager {
    public static final Key<RunConfiguration> RUN_CONFIGURATION_KEY = Key.create((String)"RUN_CONFIGURATION");
    public static final Key<String> RUN_CONFIGURATION_TYPE_ID_KEY = Key.create((String)"RUN_CONFIGURATION_TYPE_ID");

    public static CompilerManager getInstance(@NotNull Project project) {
        if (project == null) {
            CompilerManager.$$$reportNull$$$0(0);
        }
        return (CompilerManager)project.getService(CompilerManager.class);
    }

    @ApiStatus.Internal
    @NotNull
    public static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Compiler");
        if (notificationGroup == null) {
            CompilerManager.$$$reportNull$$$0(1);
        }
        return notificationGroup;
    }

    public abstract boolean isCompilationActive();

    @Deprecated(forRemoval=true)
    public abstract void addCompiler(@NotNull Compiler var1);

    @Deprecated(forRemoval=true)
    public abstract void removeCompiler(@NotNull Compiler var1);

    public abstract <T extends Compiler> T @NotNull [] getCompilers(@NotNull Class<T> var1);

    @Deprecated(forRemoval=true)
    public abstract void addCompilableFileType(@NotNull FileType var1);

    public abstract boolean isCompilableFileType(@NotNull FileType var1);

    public abstract void addBeforeTask(@NotNull CompileTask var1);

    @Deprecated(forRemoval=true)
    public abstract void addAfterTask(@NotNull CompileTask var1);

    @NotNull
    public abstract List<CompileTask> getBeforeTasks();

    @NotNull
    public abstract List<CompileTask> getAfterTaskList();

    public abstract void compile(VirtualFile @NotNull [] var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void compile(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@Nullable CompileStatusNotification var1);

    public abstract void make(@NotNull Module var1, @Nullable CompileStatusNotification var2);

    public abstract void make(@NotNull Project var1, Module @NotNull [] var2, @Nullable CompileStatusNotification var3);

    public abstract void make(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract void makeWithModalProgress(@NotNull CompileScope var1, @Nullable CompileStatusNotification var2);

    public abstract boolean isUpToDate(@NotNull CompileScope var1);

    public abstract boolean isUpToDate(@NotNull CompileScope var1, @NotNull ProgressIndicator var2);

    public abstract void rebuild(@Nullable CompileStatusNotification var1);

    public void rebuildClean(@Nullable CompileStatusNotification callback) {
        this.rebuild(callback);
    }

    public abstract void executeTask(@NotNull CompileTask var1, @NotNull CompileScope var2, String var3, @Nullable Runnable var4);

    @Deprecated
    public abstract void addCompilationStatusListener(@NotNull CompilationStatusListener var1);

    @Deprecated
    public abstract void removeCompilationStatusListener(@NotNull CompilationStatusListener var1);

    public abstract boolean isExcludedFromCompilation(@NotNull VirtualFile var1);

    @NotNull
    public abstract CompileScope createFilesCompileScope(VirtualFile @NotNull [] var1);

    @NotNull
    public CompileScope createModuleCompileScope(@NotNull Module module, boolean includeDependentModules) {
        if (module == null) {
            CompilerManager.$$$reportNull$$$0(2);
        }
        CompileScope compileScope = this.createModulesCompileScope(new Module[]{module}, includeDependentModules);
        if (compileScope == null) {
            CompilerManager.$$$reportNull$$$0(3);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(Module @NotNull [] modules, boolean includeDependentModules) {
        if (modules == null) {
            CompilerManager.$$$reportNull$$$0(4);
        }
        CompileScope compileScope = this.createModulesCompileScope(modules, includeDependentModules, false);
        if (compileScope == null) {
            CompilerManager.$$$reportNull$$$0(5);
        }
        return compileScope;
    }

    @NotNull
    public CompileScope createModulesCompileScope(Module @NotNull [] modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        if (modules == null) {
            CompilerManager.$$$reportNull$$$0(6);
        }
        CompileScope compileScope = this.createModulesCompileScope(modules, includeDependentModules, includeRuntimeDependencies, true);
        if (compileScope == null) {
            CompilerManager.$$$reportNull$$$0(7);
        }
        return compileScope;
    }

    public abstract CompileScope createModulesCompileScope(Module @NotNull [] var1, boolean var2, boolean var3, boolean var4);

    @NotNull
    public abstract CompileScope createModuleGroupCompileScope(@NotNull Project var1, Module @NotNull [] var2, boolean var3);

    @NotNull
    public abstract CompileScope createProjectCompileScope(@NotNull Project var1);

    public abstract void setValidationEnabled(ModuleType<?> var1, boolean var2);

    public abstract boolean isValidationEnabled(Module var1);

    public abstract Collection<ClassObject> compileJavaCode(List<String> var1, Collection<? extends File> var2, Collection<? extends File> var3, Collection<? extends File> var4, Collection<? extends File> var5, Collection<? extends File> var6, Collection<? extends File> var7, File var8) throws IOException, CompilationException;

    @Nullable
    public abstract File getJavacCompilerWorkingDir();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/compiler/CompilerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/compiler/CompilerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleCompileScope";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModulesCompileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModuleCompileScope";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createModulesCompileScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 7 -> new IllegalStateException(string);
        };
    }
}

