/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.gradle;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.gradle.GradleBuildFileProviderKt;
import com.intellij.packageChecker.gradle.workaround.DependencyModificator;
import com.intellij.packageChecker.java.BuildFileProviderBase;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.util.PackageUtils;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J0\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u00182\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bH\u0016J\"\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u00182\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J*\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00190\u00182\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00150\u001b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/gradle/GradleBuildFileProvider;", "Lcom/intellij/packageChecker/java/BuildFileProviderBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "getModule", "Lcom/intellij/openapi/module/Module;", "file", "Lcom/intellij/psi/PsiFile;", "moduleScript", "module", "supports", "", "updatePackageDeclaration", "", "pkg", "Lcom/intellij/packageChecker/model/Package;", "version", "getRoots", "", "", "pkgs", "", "mainModuleData", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "importedPackages", "findExternalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "intellij.packageChecker.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildFileProvider.kt\ncom/intellij/packageChecker/gradle/GradleBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1642#2,10:121\n1915#2:131\n1916#2:133\n1652#2:134\n1#3:132\n*S KotlinDebug\n*F\n+ 1 GradleBuildFileProvider.kt\ncom/intellij/packageChecker/gradle/GradleBuildFileProvider\n*L\n94#1:121,10\n94#1:131\n94#1:133\n94#1:134\n94#1:132\n*E\n"})
public final class GradleBuildFileProvider
extends BuildFileProviderBase {
    @NotNull
    private final String id;

    public GradleBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.id = "gradle";
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public Module getModule(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = (Module)ReadAction.compute(() -> GradleBuildFileProvider.getModule$lambda$0(file));
        if (module == null) {
            GradleBuildFileProviderKt.access$getLogger$p().warn("Not a Gradle module by file: " + file.getName());
        }
        return module;
    }

    @Override
    @Nullable
    public PsiFile moduleScript(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = this.findExternalProject(this.getProject(), module);
        if (object == null || (object = object.getBuildFile()) == null) {
            return null;
        }
        Object buildFile = object;
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)buildFile, (boolean)true);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile vFile = virtualFile;
        if (this.getProject().isDisposed() || !vFile.isValid()) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(vFile);
    }

    @Override
    public boolean supports(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)"build.gradle") || Intrinsics.areEqual((Object)file.getName(), (Object)"build.gradle.kts");
    }

    @Override
    protected void updatePackageDeclaration(@NotNull Module module, @NotNull Package pkg, @NotNull String version) {
        UnifiedDependency unifiedDependency;
        Object v2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Iterable iterable = DependencyModifierService.Companion.getInstance(this.getProject()).declaredDependencies(module);
            for (Object t : iterable) {
                DeclaredDependency it = (DeclaredDependency)t;
                boolean bl = false;
                Object object = PackageUtils.INSTANCE.toModelPackageDeclaration(it, this.getProject());
                boolean bl2 = object != null && (object = ((PackageDeclaration)object).getPkg()) != null ? ((Package)object).matches(pkg) : false;
                if (!bl2) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        DeclaredDependency declaredDependency = v2;
        if (declaredDependency == null || (unifiedDependency = declaredDependency.getUnifiedDependency()) == null) {
            throw new IllegalStateException(("There are no " + pkg.getCoordinates() + " in " + module.getName() + " module").toString());
        }
        UnifiedDependency previous = unifiedDependency;
        UnifiedDependency updated = UnifiedDependency.copy$default((UnifiedDependency)previous, (UnifiedCoordinates)UnifiedCoordinates.copy$default((UnifiedCoordinates)previous.getCoordinates(), null, null, (String)version, (int)3, null), null, (int)2, null);
        DependencyModificator.Companion.getModificator(this.getProject()).updateDependency(module, previous, updated);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
    }

    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull PsiFile file, @NotNull List<Package> pkgs2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Module module = ModuleUtil.findModuleForFile((PsiFile)file);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module moduleForFile = module;
        DataNode dataNode = CachedModuleDataFinder.Companion.findMainModuleData(moduleForFile);
        if (dataNode == null) {
            return MapsKt.emptyMap();
        }
        DataNode mainModuleData = dataNode;
        return this.getRoots((DataNode<? extends ModuleData>)mainModuleData);
    }

    @Override
    @NotNull
    public Map<Package, Set<Package>> getRoots(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        DataNode dataNode = CachedModuleDataFinder.Companion.findMainModuleData(module);
        if (dataNode == null) {
            return MapsKt.emptyMap();
        }
        DataNode mainModuleData = dataNode;
        return this.getRoots((DataNode<? extends ModuleData>)mainModuleData);
    }

    private final Map<Package, Set<Package>> getRoots(DataNode<? extends ModuleData> mainModuleData) {
        DataNode dataNode = ExternalSystemApiUtil.find(mainModuleData, (Key)ProjectKeys.DEPENDENCIES_GRAPH);
        if (dataNode == null) {
            return MapsKt.emptyMap();
        }
        DataNode dependenciesDataNode = dataNode;
        Object object = dependenciesDataNode.getData();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getData(...)");
        ProjectDependencies projectDependencies = (ProjectDependencies)object;
        return PackageUtils.INSTANCE.rootDependencies(this.getProject(), projectDependencies);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module moduleForFile = module;
        DataNode dataNode = CachedModuleDataFinder.Companion.findMainModuleData(moduleForFile);
        if (dataNode == null) {
            return CollectionsKt.emptyList();
        }
        DataNode mainModuleData = dataNode;
        Collection collection = ExternalSystemApiUtil.findAllRecursively((DataNode)mainModuleData, (Key)ProjectKeys.LIBRARY_DEPENDENCY);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAllRecursively(...)");
        Collection libraryNodes = collection;
        Iterable $this$mapNotNull$iv = libraryNodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            String version;
            String name;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            AbstractExternalEntityData abstractExternalEntityData = ((LibraryDependencyData)it.getData()).getTarget();
            Intrinsics.checkNotNullExpressionValue((Object)abstractExternalEntityData, (String)"getTarget(...)");
            LibraryData libraryData = (LibraryData)abstractExternalEntityData;
            String namespace = libraryData.getGroupId();
            if ((libraryData.getArtifactId() == null ? null : (libraryData.getVersion() == null ? null : Package.Companion.create(this.getProject(), PackageType.maven, namespace, name, version))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ExternalProject findExternalProject(Project project, Module module) {
        DataNode find;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectPath((Module)module);
        if (projectId == null) {
            GradleBuildFileProviderKt.access$getLogger$p().debug("Root external project was not yet imported, project=" + project.getProjectFilePath() + ", module=" + module.getModuleFilePath());
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.findProjectNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectId);
        if (dataNode == null) {
            return null;
        }
        DataNode projectData = dataNode;
        DataNode dataNode2 = find = ExternalSystemApiUtil.find((DataNode)projectData, (Key)ExternalProjectDataCache.KEY);
        return dataNode2 != null ? (ExternalProject)dataNode2.getData() : null;
    }

    private static final Module getModule$lambda$0(PsiFile $file) {
        if (!$file.isValid()) {
            return null;
        }
        return ProjectFileIndex.getInstance((Project)$file.getProject()).getModuleForFile($file.getVirtualFile());
    }
}

